/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.compat.craftingtweaks.ICraftingTweaks;
import com.tiviacz.travelersbackpack.compat.craftingtweaks.TravelersBackpackCraftingGridAddition;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.network.ServerboundSettingsPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CraftingWidget
extends WidgetBase {
    private static ICraftingTweaks craftingTweaksAddition = ICraftingTweaks.EMPTY;

    public CraftingWidget(TravelersBackpackScreen screen, int x, int y, int width, int height) {
        super(screen, x, y, width, height);
        this.isVisible = screen.container.getSettingsManager().hasCraftingGrid();
        this.isWidgetActive = screen.container.getSettingsManager().showCraftingGrid();
        this.showTooltip = true;
        if (!screen.container.getSettingsManager().hasCraftingGrid()) {
            this.width = 0;
            this.height = 0;
        }
        craftingTweaksAddition.setScreen(screen);
        if (this.isWidgetActive) {
            this.height = 107;
            this.width = 66;
            if (this.isCraftingTweaksAdditionEnabled()) {
                this.width = 83;
            }
            craftingTweaksAddition.onCraftingSlotsDisplayed();
        } else {
            this.height = 18;
            this.width = 15;
        }
        this.zOffset = 0;
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.zOffset != 0) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, (double)this.zOffset);
        }
        RenderSystem.m_69482_();
        this.renderBg(poseStack, Minecraft.m_91087_(), mouseX, mouseY);
        if (this.zOffset != 0) {
            poseStack.m_85849_();
        }
    }

    @Override
    protected void renderBg(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TravelersBackpackScreen.SETTINGS_TRAVELERS_BACKPACK);
        if (this.isVisible()) {
            this.m_93228_(poseStack, this.isWidgetActive ? this.x - 3 : this.x, this.y, this.isWidgetActive ? 29 : 48, this.isWidgetActive ? 41 : 0, this.width - (this.isCraftingTweaksAdditionEnabled() && this.isWidgetActive() ? 17 : 0), this.height);
            if (this.isWidgetActive()) {
                if (TravelersBackpackConfig.enableLegacyGui) {
                    this.drawLegacyGridAndResult(poseStack, this.x + 3, this.y + 17);
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)TravelersBackpackScreen.SETTINGS_TRAVELERS_BACKPACK);
                if (this.isCraftingTweaksAdditionEnabled()) {
                    this.m_93228_(poseStack, this.x + 60, this.y, 96, 41, 20, 107);
                }
                if (this.screen.container.getSettingsManager().shiftClickToBackpack()) {
                    this.m_93228_(poseStack, this.x + 6, this.y + 88, 16, 73, 10, 8);
                } else {
                    this.m_93228_(poseStack, this.x + 7, this.y + 87, 3, 72, 8, 10);
                }
            }
        }
    }

    @Override
    public void renderTooltip(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isWidgetActive() && this.isVisible()) {
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)Component.m_237115_((String)"container.crafting"), (float)(this.x + 13), (float)(this.y + 6), 0x404040);
        }
        if (this.m_5953_(mouseX, mouseY) && this.showTooltip && this.isVisible) {
            if (!this.isWidgetActive()) {
                this.screen.m_96602_(poseStack, (Component)Component.m_237115_((String)"screen.travelersbackpack.crafting"), mouseX, mouseY);
            } else {
                if (this.in(mouseX, mouseY, this.x, this.y + 3, 13, 11)) {
                    this.screen.m_96602_(poseStack, (Component)Component.m_237115_((String)"screen.travelersbackpack.crafting"), mouseX, mouseY);
                }
                if (mouseX >= this.x + 6 && mouseY >= this.y + 87 && mouseX < this.x + 16 && mouseY < this.y + 97) {
                    if (this.screen.container.getSettingsManager().shiftClickToBackpack()) {
                        this.screen.m_96602_(poseStack, (Component)Component.m_237115_((String)"screen.travelersbackpack.crafting_to_backpack"), mouseX, mouseY);
                    } else {
                        this.screen.m_96602_(poseStack, (Component)Component.m_237115_((String)"screen.travelersbackpack.crafting_to_player"), mouseX, mouseY);
                    }
                }
            }
        }
    }

    @Override
    public void setWidgetStatus(boolean status) {
        boolean showCraftingWidget = this.screen.container.getSettingsManager().showCraftingGrid();
        this.screen.container.getSettingsManager().set((byte)0, 1, (byte)(!showCraftingWidget ? 1 : 0));
        TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSettingsPacket(this.screen.container.getScreenID(), 0, 1, (byte)(!showCraftingWidget ? 1 : 0)));
        super.setWidgetStatus(status);
    }

    @Override
    public boolean m_5953_(double pMouseX, double pMouseY) {
        if (this.isWidgetActive()) {
            if (pMouseX >= (double)(this.x + 3) && pMouseY >= (double)(this.y + 16) && pMouseX < (double)(this.x + 57) && pMouseY < (double)(this.y + 70)) {
                return false;
            }
            if (pMouseX >= (double)(this.x + 21) && pMouseY >= (double)(this.y + 83) && pMouseX < (double)(this.x + 39) && pMouseY < (double)(this.y + 101)) {
                return false;
            }
        }
        return pMouseX >= (double)this.x && pMouseY >= (double)this.y && pMouseX < (double)(this.x + this.width) && pMouseY < (double)(this.y + this.height);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.screen.settingsWidget.isWidgetActive()) {
            return false;
        }
        if (!this.isVisible()) {
            return false;
        }
        if (this.isWidgetActive() && this.isCraftingTweaksAdditionEnabled()) {
            if (mouseX >= (double)(this.x + 59) && mouseY >= (double)(this.y + 18) && mouseX < (double)(this.x + 75) && mouseY < (double)(this.y + 34)) {
                return false;
            }
            if (mouseX >= (double)(this.x + 59) && mouseY >= (double)(this.y + 36) && mouseX < (double)(this.x + 75) && mouseY < (double)(this.y + 52)) {
                return false;
            }
            if (mouseX >= (double)(this.x + 59) && mouseY >= (double)(this.y + 54) && mouseX < (double)(this.x + 75) && mouseY < (double)(this.y + 70)) {
                return false;
            }
        }
        if (this.m_5953_(mouseX, mouseY)) {
            if (this.isWidgetActive) {
                if (mouseX >= (double)this.x && mouseY >= (double)(this.y + 3) && mouseX < (double)(this.x + 13) && mouseY < (double)(this.y + 15)) {
                    this.setWidgetStatus(false);
                    craftingTweaksAddition.onCraftingSlotsHidden();
                    this.screen.playUIClickSound();
                }
                if (mouseX >= (double)(this.x + 6) && mouseY >= (double)(this.y + 87) && mouseX < (double)(this.x + 16) && mouseY < (double)(this.y + 97)) {
                    boolean shiftClickToBackpack = this.screen.container.getSettingsManager().shiftClickToBackpack();
                    this.screen.container.getSettingsManager().set((byte)0, 2, (byte)(!shiftClickToBackpack ? 1 : 0));
                    TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSettingsPacket(this.screen.container.getScreenID(), 0, 2, (byte)(!shiftClickToBackpack ? 1 : 0)));
                    this.screen.playUIClickSound();
                }
            } else {
                this.setWidgetStatus(true);
                craftingTweaksAddition.onCraftingSlotsDisplayed();
                this.screen.playUIClickSound();
            }
            if (this.isWidgetActive) {
                this.height = 107;
                this.width = 66;
                if (this.isCraftingTweaksAdditionEnabled()) {
                    this.width = 83;
                }
                this.zOffset = 0;
            }
            if (!this.isWidgetActive) {
                this.height = 18;
                this.width = 15;
                this.zOffset = 0;
            }
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }

    public void drawLegacyGridAndResult(PoseStack poseStack, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TravelersBackpackScreen.EXTRAS_TRAVELERS_BACKPACK);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.screen.drawSlotLegacy(poseStack, x + i * 18, y + j * 18, 213, 19);
            }
        }
        this.screen.drawSlotLegacy(poseStack, x + 18, y + 66, 213, 19);
    }

    public static void setCraftingTweaksAddition(ICraftingTweaks addition) {
        craftingTweaksAddition = addition;
    }

    public ICraftingTweaks getCraftingTweaksAddition() {
        return craftingTweaksAddition;
    }

    public boolean isCraftingTweaksAdditionEnabled() {
        if (!this.screen.container.getSettingsManager().hasCraftingGrid()) {
            return false;
        }
        return craftingTweaksAddition instanceof TravelersBackpackCraftingGridAddition;
    }

    @Override
    public boolean isSettingsChild() {
        return false;
    }

    @Override
    public int[] getWidgetSizeAndPos() {
        int[] size = new int[]{this.x, this.y, this.width, this.height};
        return size;
    }
}

