/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackWearable;
import com.tiviacz.travelersbackpack.capability.entity.IEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.capability.entity.TravelersBackpackEntityCapability;
import com.tiviacz.travelersbackpack.capability.entity.TravelersBackpackEntityWearable;
import com.tiviacz.travelersbackpack.commands.AccessBackpackCommand;
import com.tiviacz.travelersbackpack.commands.ClearBackpackCommand;
import com.tiviacz.travelersbackpack.commands.RestoreBackpackCommand;
import com.tiviacz.travelersbackpack.commands.UnpackBackpackCommand;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipe;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurios;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.items.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundSendMessagePacket;
import com.tiviacz.travelersbackpack.network.ClientboundSyncCapabilityPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.LogHelper;
import com.tiviacz.travelersbackpack.util.Reference;
import com.tiviacz.travelersbackpack.util.ResourceUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.command.ConfigCommand;

@Mod.EventBusSubscriber(modid="travelersbackpack", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    private static boolean checkAbilitiesForRemoval = true;
    private static long nextBackpackCountCheck = 0L;
    private static final int BACKPACK_COUNT_CHECK_COOLDOWN = 100;

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ITravelersBackpack.class);
        event.register(IEntityTravelersBackpack.class);
    }

    @SubscribeEvent
    public static void playerSetSpawn(PlayerSetSpawnEvent event) {
        Level level = event.getEntity().f_19853_;
        if (event.getNewSpawn() != null) {
            Block block = level.m_8055_(event.getNewSpawn()).m_60734_();
            if (!level.f_46443_ && block instanceof SleepingBagBlock && !event.isForced()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block list;
        BlockEntity oldSleepingBag;
        TravelersBackpackBlockEntity blockEntity;
        BlockEntity context;
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        if (TravelersBackpackConfig.enableBackpackRightClickUnequip && CapabilityUtils.isWearingBackpack(player) && !level.f_46443_ && player.m_6144_() && event.getHand() == InteractionHand.MAIN_HAND && player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            TravelersBackpackItem item;
            ItemStack backpackStack = CapabilityUtils.getWearingBackpack(player);
            context = new UseOnContext(level, player, InteractionHand.MAIN_HAND, backpackStack, event.getHitVec());
            Item item2 = backpackStack.m_41720_();
            if (item2 instanceof TravelersBackpackItem && (item = (TravelersBackpackItem)item2).m_40576_(new BlockPlaceContext((UseOnContext)context)) == InteractionResult.m_19078_((boolean)level.f_46443_)) {
                player.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.05f, (1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
                CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::removeWearable);
                if (TravelersBackpack.enableCurios()) {
                    TravelersBackpackCurios.rightClickUnequip(player, backpackStack);
                }
                CapabilityUtils.synchronise(player);
                CapabilityUtils.synchroniseToOthers(player);
                event.setCanceled(true);
                return;
            }
        }
        if (player.m_6144_() && event.getHand() == InteractionHand.MAIN_HAND && player.m_21120_(InteractionHand.MAIN_HAND).m_204117_(ModTags.SLEEPING_BAGS) && (context = level.m_7702_(pos)) instanceof TravelersBackpackBlockEntity) {
            blockEntity = (TravelersBackpackBlockEntity)context;
            oldSleepingBag = blockEntity.getProperSleepingBag(blockEntity.getSleepingBagColor()).m_60734_().m_5456_().m_7968_();
            blockEntity.setSleepingBagColor(ShapedBackpackRecipe.getProperColor(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_()));
            if (!level.f_46443_) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_7494_().m_123342_(), (double)pos.m_123343_(), (ItemStack)oldSleepingBag);
                stack.m_41774_(1);
            }
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (player.f_19853_.f_46441_.m_188501_() - player.f_19853_.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            player.m_21011_(InteractionHand.MAIN_HAND, true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (player.m_6144_() && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == ModItems.BLANK_UPGRADE.get() && (oldSleepingBag = level.m_7702_(pos)) instanceof TravelersBackpackBlockEntity) {
            int fluidAmountRight;
            int fluidAmountLeft;
            blockEntity = (TravelersBackpackBlockEntity)oldSleepingBag;
            list = NonNullList.m_122779_();
            for (int i = 0; i < blockEntity.getCombinedHandler().getSlots(); ++i) {
                ItemStack stackInSlot = blockEntity.getCombinedHandler().getStackInSlot(i);
                if (stackInSlot.m_41619_()) continue;
                list.add((Object)stackInSlot);
                blockEntity.getCombinedHandler().setStackInSlot(i, ItemStack.f_41583_);
            }
            list.addAll(UpgradeItem.getUpgrades(blockEntity));
            if (!blockEntity.getSlotManager().getUnsortableSlots().isEmpty()) {
                blockEntity.getSlotManager().getUnsortableSlots().clear();
            }
            if (!blockEntity.getSlotManager().getMemorySlots().isEmpty()) {
                blockEntity.getSlotManager().getMemorySlots().clear();
            }
            int n = fluidAmountLeft = blockEntity.getLeftTank().isEmpty() ? 0 : blockEntity.getLeftTank().getFluidAmount();
            if (fluidAmountLeft > Tiers.LEATHER.getTankCapacity()) {
                blockEntity.getLeftTank().drain(fluidAmountLeft - Tiers.LEATHER.getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
            }
            int n2 = fluidAmountRight = blockEntity.getRightTank().isEmpty() ? 0 : blockEntity.getRightTank().getFluidAmount();
            if (fluidAmountRight > Tiers.LEATHER.getTankCapacity()) {
                blockEntity.getRightTank().drain(fluidAmountRight - Tiers.LEATHER.getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
            }
            if (!level.f_46443_) {
                Containers.m_19010_((Level)level, (BlockPos)pos.m_7494_(), (NonNullList)list);
            }
            blockEntity.getHandler().setSize(Tiers.LEATHER.getStorageSlots());
            blockEntity.getToolSlotsHandler().setSize(Tiers.LEATHER.getToolSlots());
            blockEntity.resetTier();
            blockEntity.getLeftTank().setCapacity(Tiers.LEATHER.getTankCapacity());
            blockEntity.getRightTank().setCapacity(Tiers.LEATHER.getTankCapacity());
            blockEntity.getSettingsManager().loadDefaults();
            player.m_21011_(InteractionHand.MAIN_HAND, true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (event.getLevel().f_46443_) {
            return;
        }
        if (TravelersBackpackConfig.enableBackpackBlockWearable && (list = event.getLevel().m_8055_(event.getPos()).m_60734_()) instanceof TravelersBackpackBlock) {
            TravelersBackpackBlock block = (TravelersBackpackBlock)list;
            if (player.m_6144_() && !CapabilityUtils.isWearingBackpack(player)) {
                boolean canEquipCurio;
                TravelersBackpackBlockEntity blockEntity2 = (TravelersBackpackBlockEntity)level.m_7702_(pos);
                ItemStack backpack = new ItemStack((ItemLike)block, 1);
                Direction bagDirection = (Direction)level.m_8055_(pos).m_61143_((Property)TravelersBackpackBlock.FACING);
                if (TravelersBackpack.enableCurios() && !(canEquipCurio = TravelersBackpackCurios.rightClickEquip(player, backpack, true))) {
                    return;
                }
                if (level.m_46597_(pos, Blocks.f_50016_.m_49966_())) {
                    blockEntity2.transferToItemStack(backpack);
                    if (TravelersBackpack.enableCurios()) {
                        TravelersBackpackCurios.rightClickEquip(player, backpack, false);
                    } else {
                        CapabilityUtils.equipBackpack(player, backpack);
                    }
                    player.m_21011_(InteractionHand.MAIN_HAND, true);
                    if (blockEntity2.isSleepingBagDeployed()) {
                        level.m_46597_(pos.m_121945_(bagDirection), Blocks.f_50016_.m_49966_());
                        level.m_46597_(pos.m_121945_(bagDirection).m_121945_(bagDirection), Blocks.f_50016_.m_49966_());
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
            }
        }
        if (event.getLevel().f_46443_ || event.getEntity().m_6144_()) {
            return;
        }
        if (stack.m_41720_() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            BlockState blockState = event.getLevel().m_8055_(event.getPos());
            if (BackpackDyeRecipe.hasColor(stack) && blockState.m_60734_() instanceof LayeredCauldronBlock && (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) > 0) {
                stack.m_41783_().m_128473_("Color");
                LayeredCauldronBlock.m_153559_((BlockState)blockState, (Level)event.getLevel(), (BlockPos)event.getPos());
                event.getLevel().m_6263_(null, (double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123342_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onEnderManAngerEvent(EnderManAngerEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.pumpkinAbility(event);
        }
    }

    @SubscribeEvent
    public static void blockBlazeProjectile(ProjectileImpactEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.blazeAbility(event);
        }
    }

    @SubscribeEvent
    public static void livingChangeTarget(LivingChangeTargetEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.ghastAbility(event);
        }
    }

    @SubscribeEvent
    public static void onHit(AttackEntityEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.beeAbility(event);
        }
    }

    @SubscribeEvent
    public static void onExpPickup(PlayerXpEvent.PickupXp event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.ABILITIES.lapisAbility(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        ItemEntity itemEntity;
        block8: {
            block7: {
                Entity entity = event.getEntity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    CapabilityUtils.synchronise(player);
                }
                if ((entity = event.getEntity()) instanceof LivingEntity) {
                    IEntityTravelersBackpack travelersBackpack;
                    LazyOptional<IEntityTravelersBackpack> cap;
                    LivingEntity living = (LivingEntity)entity;
                    if (!event.loadedFromDisk() && TravelersBackpackConfig.spawnEntitiesWithBackpack && (cap = CapabilityUtils.getEntityCapability(living)).isPresent() && Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().m_6095_()) && !(travelersBackpack = (IEntityTravelersBackpack)cap.resolve().get()).hasWearable() && event.getLevel().m_213780_().m_216339_(0, TravelersBackpackConfig.spawnChance) == 0) {
                        boolean isNether = living.m_6095_() == EntityType.f_20511_ || living.m_6095_() == EntityType.f_20497_;
                        RandomSource rand = event.getLevel().f_46441_;
                        ItemStack backpack = isNether ? ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.get(rand.m_216332_(0, ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.size() - 1)).m_7968_() : ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.get(rand.m_216332_(0, ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.size() - 1)).m_7968_();
                        backpack.m_41784_().m_128405_("SleepingBagColor", DyeColor.values()[rand.m_216332_(0, DyeColor.values().length - 1)].m_41060_());
                        travelersBackpack.setWearable(backpack);
                        travelersBackpack.synchronise();
                    }
                }
                if (!((entity = event.getEntity()) instanceof ItemEntity)) break block7;
                itemEntity = (ItemEntity)entity;
                if (TravelersBackpackConfig.invulnerableBackpack) break block8;
            }
            return;
        }
        if (itemEntity.m_32055_().m_41720_() instanceof TravelersBackpackItem) {
            itemEntity.m_149678_();
            itemEntity.m_20331_(true);
        }
    }

    @SubscribeEvent
    public static void entityLeave(EntityLeaveLevelEvent event) {
        ItemEntity itemEntity;
        block8: {
            block7: {
                Entity entity = event.getEntity();
                if (!(entity instanceof ItemEntity)) break block7;
                itemEntity = (ItemEntity)entity;
                if (TravelersBackpackConfig.voidProtection) break block8;
            }
            return;
        }
        if (itemEntity.m_32055_().m_41720_() instanceof TravelersBackpackItem) {
            if (event.getLevel().f_46443_) {
                return;
            }
            BlockPos entityPos = itemEntity.m_20183_();
            Vec3 entityPosCentered = Vec3.m_82512_((Vec3i)entityPos);
            double y = entityPosCentered.m_7098_();
            if (y < (double)event.getLevel().m_141937_()) {
                ItemEntity protectedItemEntity = new ItemEntity(event.getLevel(), entityPosCentered.m_7096_(), y, entityPosCentered.m_7094_(), itemEntity.m_32055_());
                protectedItemEntity.m_20242_(true);
                protectedItemEntity.m_32060_();
                for (double i = y = (double)event.getLevel().m_141937_(); i < (double)event.getLevel().m_141928_(); i += 1.0) {
                    if (!event.getLevel().m_8055_(new BlockPos(Mth.m_14107_((double)entityPosCentered.m_7096_()), Mth.m_14107_((double)i), Mth.m_14107_((double)entityPosCentered.m_7094_()))).m_60767_().m_76336_()) continue;
                    y = i;
                    break;
                }
                protectedItemEntity.m_6034_(entityPosCentered.m_7096_(), y, entityPosCentered.m_7094_());
                protectedItemEntity.m_20334_(0.0, 0.0, 0.0);
                event.getLevel().m_7967_((Entity)protectedItemEntity);
            }
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        LivingEntity livingEntity;
        Object travelersBackpack;
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            travelersBackpack = new TravelersBackpackWearable(player);
            event.addCapability(TravelersBackpackCapability.ID, TravelersBackpackCapability.createProvider((ITravelersBackpack)travelersBackpack));
        }
        if ((travelersBackpack = event.getObject()) instanceof LivingEntity && Reference.ALLOWED_TYPE_ENTRIES.contains((livingEntity = (LivingEntity)travelersBackpack).m_6095_())) {
            travelersBackpack = new TravelersBackpackEntityWearable(livingEntity);
            event.addCapability(TravelersBackpackEntityCapability.ID, TravelersBackpackEntityCapability.createProvider((IEntityTravelersBackpack)travelersBackpack));
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && CapabilityUtils.isWearingBackpack(player = (Player)livingEntity) && TravelersBackpackConfig.enableBackpackAbilities && BackpackAbilities.creeperAbility(event)) {
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerDrops(LivingDropsEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && CapabilityUtils.isWearingBackpack(player = (Player)livingEntity)) {
            if (player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
                return;
            }
            ItemStack stack = CapabilityUtils.getWearingBackpack(player);
            if (BackpackUtils.onPlayerDrops(player.f_19853_, player, stack)) {
                if (player.f_19853_.f_46443_) {
                    return;
                }
                ItemEntity itemEntity = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                itemEntity.m_32060_();
                TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientboundSendMessagePacket(true, player.m_20183_()));
                LogHelper.info("There's no space for backpack. Dropping backpack item at X: " + player.m_20183_().m_123341_() + " Y: " + player.m_20186_() + " Z: " + player.m_20183_().m_123343_(), new Object[0]);
                if (!TravelersBackpack.enableCurios()) {
                    event.getDrops().add(itemEntity);
                }
                CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::removeWearable);
                CapabilityUtils.synchronise(player);
            }
        }
        if (Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().m_6095_()) && CapabilityUtils.isWearingBackpack(event.getEntity())) {
            ItemEntity itemEntity = new ItemEntity(event.getEntity().f_19853_, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), CapabilityUtils.getWearingBackpack(event.getEntity()));
            event.getDrops().add(itemEntity);
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        CapabilityUtils.getCapability(oldPlayer).ifPresent(oldTravelersBackpack -> CapabilityUtils.getCapability(event.getEntity()).ifPresent(newTravelersBackpack -> {
            newTravelersBackpack.setWearable(oldTravelersBackpack.getWearable());
            newTravelersBackpack.setContents(oldTravelersBackpack.getWearable());
        }));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        ServerPlayer target;
        if (event.getTarget() instanceof Player && !event.getTarget().f_19853_.f_46443_) {
            target = (ServerPlayer)event.getTarget();
            CapabilityUtils.getCapability((Player)target).ifPresent(c -> TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new ClientboundSyncCapabilityPacket(target.m_19879_(), true, CapabilityUtils.getWearingBackpack((Player)target).m_41739_(new CompoundTag()))));
        }
        if (Reference.ALLOWED_TYPE_ENTRIES.contains(event.getTarget().m_6095_()) && !event.getTarget().f_19853_.f_46443_) {
            target = (LivingEntity)event.getTarget();
            CapabilityUtils.getEntityCapability((LivingEntity)target).ifPresent(arg_0 -> ForgeEventHandler.lambda$playerTracking$6(event, (LivingEntity)target, arg_0));
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities && event.phase == TickEvent.Phase.END && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, CapabilityUtils.getWearingBackpack(event.player))) {
            TravelersBackpackContainer.abilityTick(event.player);
            if (!checkAbilitiesForRemoval && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, CapabilityUtils.getWearingBackpack(event.player))) {
                checkAbilitiesForRemoval = true;
            }
        }
        if (!(!checkAbilitiesForRemoval || event.phase != TickEvent.Phase.END || event.player.f_19853_.f_46443_ || CapabilityUtils.isWearingBackpack(event.player) && TravelersBackpackConfig.enableBackpackAbilities)) {
            BackpackAbilities.ABILITIES.armorAbilityRemovals(event.player);
            checkAbilitiesForRemoval = false;
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !TravelersBackpackConfig.tooManyBackpacksSlowness || nextBackpackCountCheck > event.level.m_46467_()) {
            return;
        }
        nextBackpackCountCheck = event.level.m_46467_() + 100L;
        event.level.m_6907_().forEach(player -> {
            if (player.m_7500_() || player.m_5833_()) {
                return;
            }
            AtomicInteger numberOfBackpacks = ForgeEventHandler.checkBackpacksForSlowness(player);
            if (numberOfBackpacks.get() == 0) {
                return;
            }
            int maxNumberOfBackpacks = TravelersBackpackConfig.maxNumberOfBackpacks;
            if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * TravelersBackpackConfig.slownessPerExcessedBackpack));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, numberOfSlownessLevels - 1, false, false));
            }
        });
    }

    public static AtomicInteger checkBackpacksForSlowness(Player player) {
        AtomicInteger atomic = new AtomicInteger(0);
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            if (!(((ItemStack)player.m_150109_().f_35974_.get(i)).m_41720_() instanceof TravelersBackpackItem)) continue;
            atomic.incrementAndGet();
        }
        if (((ItemStack)player.m_150109_().f_35976_.get(0)).m_41720_() instanceof TravelersBackpackItem) {
            atomic.incrementAndGet();
        }
        return atomic;
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        new AccessBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new RestoreBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClearBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new UnpackBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void explosionDetonate(ExplosionEvent.Detonate event) {
        for (int i = 0; i < event.getAffectedEntities().size(); ++i) {
            ItemEntity itemEntity;
            Entity entity = (Entity)event.getAffectedEntities().get(i);
            if (!(entity instanceof ItemEntity) || !((itemEntity = (ItemEntity)entity).m_32055_().m_41720_() instanceof TravelersBackpackItem)) continue;
            event.getAffectedEntities().remove(i);
        }
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (TravelersBackpackConfig.enableLoot) {
            if (event.getName().equals((Object)BuiltInLootTables.f_78759_)) {
                event.getTable().addPool(LootPool.m_79043_().name("abandoned_mineshaft_bat").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ResourceUtils.create("chests/bat"))).m_79082_());
                event.getTable().addPool(LootPool.m_79043_().name("abandoned_mineshaft_inject").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ResourceUtils.create("chests/abandoned_mineshaft_inject"))).m_79082_());
            }
            if (event.getName().equals((Object)BuiltInLootTables.f_78745_)) {
                event.getTable().addPool(LootPool.m_79043_().name("village_armorer_iron_golem").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ResourceUtils.create("chests/iron_golem"))).m_79082_());
            }
            if (event.getName().equals((Object)BuiltInLootTables.f_78742_)) {
                event.getTable().addPool(LootPool.m_79043_().name("simple_dungeon_inject").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ResourceUtils.create("chests/simple_dungeon_inject"))).m_79082_());
            }
            if (event.getName().equals((Object)BuiltInLootTables.f_78764_)) {
                event.getTable().addPool(LootPool.m_79043_().name("desert_pyramid_inject").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ResourceUtils.create("chests/desert_pyramid_inject"))).m_79082_());
            }
            if (event.getName().equals((Object)BuiltInLootTables.f_78695_)) {
                event.getTable().addPool(LootPool.m_79043_().name("shipwreck_treasure_inject").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ResourceUtils.create("chests/shipwreck_treasure_inject"))).m_79082_());
            }
            if (event.getName().equals((Object)BuiltInLootTables.f_78689_)) {
                event.getTable().addPool(LootPool.m_79043_().name("woodland_mansion_inject").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ResourceUtils.create("chests/woodland_mansion_inject"))).m_79082_());
            }
            if (event.getName().equals((Object)BuiltInLootTables.f_78760_)) {
                event.getTable().addPool(LootPool.m_79043_().name("nether_bridge_inject").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ResourceUtils.create("chests/nether_bridge_inject"))).m_79082_());
            }
            if (event.getName().equals((Object)BuiltInLootTables.f_78697_)) {
                event.getTable().addPool(LootPool.m_79043_().name("bastion_treasure_inject").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ResourceUtils.create("chests/bastion_treasure_inject"))).m_79082_());
            }
            if (event.getName().equals((Object)BuiltInLootTables.f_78741_)) {
                event.getTable().addPool(LootPool.m_79043_().name("end_city_treasure_inject").m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ResourceUtils.create("chests/end_city_treasure_inject"))).m_79082_());
            }
        }
    }

    @SubscribeEvent
    public static void addVillagerTrade(VillagerTradesEvent event) {
        if (TravelersBackpackConfig.enableVillagerTrade && event.getType() == VillagerProfession.f_35594_) {
            ((List)event.getTrades().get(3)).add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, random.m_188503_(64) + 48), new ItemStack((ItemLike)((Item)ModItems.VILLAGER_TRAVELERS_BACKPACK.get()).m_5456_(), 1), 1, 50, 0.5f));
        }
    }

    private static /* synthetic */ void lambda$playerTracking$6(PlayerEvent.StartTracking event, LivingEntity target, IEntityTravelersBackpack c) {
        TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new ClientboundSyncCapabilityPacket(target.m_19879_(), false, CapabilityUtils.getWearingBackpack(target).m_41739_(new CompoundTag())));
    }
}

