/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.model.renderable.CompositeRenderable;
import net.minecraftforge.client.model.renderable.ITextureRenderTypeLookup;

public class ObjEntityModel<T extends Entity> {
    public static final Matrix4f INVISIBLE = Matrix4f.m_27632_((float)0.0f, (float)0.0f, (float)0.0f);
    public final String modelId;
    private final Map<String, Matrix4f> transforms = new HashMap<String, Matrix4f>();
    private CompositeRenderable model;
    private ObjEntityModels.ModelOverrides modelOverride;

    public ObjEntityModel(String modelId) {
        this.modelId = modelId;
    }

    public void render(T entity, PoseStack poseStack, MultiBufferSource bufferSource, int lightmap, float partialTicks) {
        this.rotate(entity, partialTicks, poseStack);
        this.handleGlobalOverrides(entity, partialTicks, poseStack);
        this.getModel().render(poseStack, bufferSource, this.getTextureRenderTypeLookup(entity), this.getLight(entity, lightmap), this.getOverlay(entity), partialTicks, this.getComponentTransforms(entity, partialTicks));
    }

    protected void rotate(T entity, float partialTicks, PoseStack poseStack) {
        Vector3f pivot = this.getGlobalPivot();
        Quaternion yRot = Vector3f.f_122224_.m_122240_(entity.m_5675_(partialTicks));
        Quaternion xRot = Vector3f.f_122223_.m_122240_(entity.m_5686_(partialTicks));
        if (!UtilGeometry.isZero(pivot)) {
            if (this.globalRotateY()) {
                poseStack.m_166854_(UtilAngles.pivotInvRot(pivot, yRot));
            }
            if (this.globalRotateX()) {
                poseStack.m_166854_(UtilAngles.pivotInvRot(pivot, xRot));
            }
        } else {
            if (this.globalRotateY()) {
                poseStack.m_85845_(yRot);
            }
            if (this.globalRotateX()) {
                poseStack.m_85845_(xRot);
            }
        }
    }

    protected void handleGlobalOverrides(T entity, float partialTicks, PoseStack poseStack) {
        Vector3f pivot = this.getGlobalPivot();
        if (!UtilGeometry.isZero(pivot)) {
            poseStack.m_85837_((double)pivot.m_122239_(), (double)pivot.m_122260_(), (double)pivot.m_122269_());
        }
        this.getModelOverride().applyNoTranslate(poseStack);
    }

    public CompositeRenderable getModel() {
        if (this.model == null) {
            this.model = ObjEntityModels.get().getBakedModel(this.modelId);
        }
        return this.model;
    }

    public ObjEntityModels.ModelOverrides getModelOverride() {
        if (this.modelOverride == null) {
            this.modelOverride = ObjEntityModels.get().getModelOverride(this.modelId);
        }
        return this.modelOverride;
    }

    protected CompositeRenderable.Transforms getComponentTransforms(T entity, float partialTicks) {
        this.transforms.clear();
        this.addComponentTransforms(this.transforms, entity, partialTicks);
        if (this.transforms.isEmpty()) {
            return CompositeRenderable.Transforms.EMPTY;
        }
        return CompositeRenderable.Transforms.of((ImmutableMap)ImmutableMap.builder().putAll(this.transforms).build());
    }

    protected void addComponentTransforms(Map<String, Matrix4f> transforms, T entity, float partialTicks) {
    }

    protected ITextureRenderTypeLookup getTextureRenderTypeLookup(T entity) {
        return RenderType::m_110473_;
    }

    protected int getLight(T entity, int lightmap) {
        return lightmap;
    }

    protected int getOverlay(T entity) {
        return OverlayTexture.f_118083_;
    }

    public Vector3f getGlobalPivot() {
        return this.getModelOverride().translate;
    }

    public boolean globalRotateX() {
        return true;
    }

    public boolean globalRotateY() {
        return true;
    }
}

