/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Vector3f;
import com.onewhohears.onewholibs.client.model.obj.ObjModelParser;
import com.onewhohears.onewholibs.util.UtilParse;
import java.io.File;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.obj.ObjModel;
import net.minecraftforge.client.model.obj.ObjTokenizer;
import net.minecraftforge.client.model.renderable.CompositeRenderable;
import org.slf4j.Logger;

public class ObjEntityModels
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ObjEntityModels instance;
    public static final String DIRECTORY = "models/entity";
    public static final String MODEL_FILE_TYPE = ".obj";
    public static final String OVERRIDE_FILE_TYPE = ".json";
    public static final String NULL_MODEL_NAME = "simple_test";
    private final Map<String, ModelOverrides> modelOverrides = new HashMap<String, ModelOverrides>();
    private final Map<String, ObjModel> unbakedModels = new HashMap<String, ObjModel>();
    private final Map<String, CompositeRenderable> models = new HashMap<String, CompositeRenderable>();
    public static final ModelOverrides NO_OVERRIDES;

    public static ObjEntityModels get() {
        if (instance == null) {
            instance = new ObjEntityModels();
        }
        return instance;
    }

    public static void close() {
        instance = null;
    }

    private ObjEntityModels() {
    }

    public ObjModel getUnbakedModel(String name) {
        if (!this.unbakedModels.containsKey(name)) {
            return this.unbakedModels.get(NULL_MODEL_NAME);
        }
        return this.unbakedModels.get(name);
    }

    public ModelOverrides getModelOverride(String name) {
        if (!this.modelOverrides.containsKey(name)) {
            return NO_OVERRIDES;
        }
        return this.modelOverrides.get(name);
    }

    public CompositeRenderable getBakedModel(String name) {
        if (!this.models.containsKey(name)) {
            return this.models.get(NULL_MODEL_NAME);
        }
        return this.models.get(name);
    }

    public boolean hasModel(String id) {
        return this.models.containsKey(id);
    }

    public void bakeModels() {
        LOGGER.info("BAKING OBJ MODELS");
        this.models.clear();
        this.unbakedModels.forEach((key, obj) -> {
            StandaloneGeometryBakingContext ctx = StandaloneGeometryBakingContext.create((ResourceLocation)obj.modelLocation);
            CompositeRenderable comp = obj.bakeRenderable((IGeometryBakingContext)ctx);
            this.models.put((String)key, comp);
            LOGGER.debug("BAKED {} {} {}", new Object[]{key, obj.getRootComponentNames().size(), obj.getConfigurableComponentNames()});
        });
    }

    public void m_6213_(ResourceManager manager) {
        LOGGER.info("RELOAD ASSETS: models/entity");
        this.readUnbakedModels(manager);
        this.readModelOverrides(manager);
        this.bakeModels();
    }

    public void readUnbakedModels(ResourceManager manager) {
        this.unbakedModels.clear();
        manager.m_214159_(DIRECTORY, key -> key.m_135815_().endsWith(MODEL_FILE_TYPE)).forEach((key, resource) -> {
            try {
                String name = new File(key.m_135815_()).getName().replace(MODEL_FILE_TYPE, "");
                if (this.unbakedModels.containsKey(name)) {
                    LOGGER.debug("The model {} is overriding {}!", key, (Object)this.unbakedModels.get((Object)name).modelLocation);
                }
                ObjTokenizer tokenizer = new ObjTokenizer(resource.m_215507_());
                String mtlOverride = key.toString().replace(MODEL_FILE_TYPE, ".mtl");
                ObjModel model = ObjModelParser.parse(tokenizer, new ObjModel.ModelSettings(key, false, false, true, false, mtlOverride));
                tokenizer.close();
                this.unbakedModels.put(name, model);
                LOGGER.debug("ADDING MODEL = {}", key);
            }
            catch (Exception e) {
                LOGGER.error("ERROR: SKIPPING {} because {}", key, (Object)e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public void readModelOverrides(ResourceManager manager) {
        this.modelOverrides.clear();
        manager.m_214159_(DIRECTORY, key -> key.m_135815_().endsWith(OVERRIDE_FILE_TYPE)).forEach((key, resource) -> {
            try {
                String name = new File(key.m_135815_()).getName().replace(OVERRIDE_FILE_TYPE, "");
                if (this.modelOverrides.containsKey(name)) {
                    LOGGER.warn("ERROR: Can't have 2 model overrides with the same name! {}", key);
                    return;
                }
                JsonObject json = (JsonObject)UtilParse.GSON.fromJson((Reader)resource.m_215508_(), JsonObject.class);
                this.modelOverrides.put(name, new ModelOverrides(json));
                LOGGER.debug("ADDING OVERRIDE = {}", key);
            }
            catch (Exception e) {
                LOGGER.warn("ERROR: SKIPPING {} because {}", (Object)key.toString(), (Object)e.getMessage());
                e.printStackTrace();
            }
        });
    }

    static {
        NO_OVERRIDES = new ModelOverrides();
    }

    public static class ModelOverrides {
        public float scale = 1.0f;
        public float[] scale3d = new float[]{1.0f, 1.0f, 1.0f};
        public Vector3f translate = new Vector3f();
        public float[] rotation = new float[]{0.0f, 0.0f, 0.0f};
        private boolean none = false;

        public ModelOverrides(JsonObject json) {
            if (json.has("scale_all") && json.get("scale_all").isJsonPrimitive()) {
                this.scale = UtilParse.getFloatSafe(json, "scale_all", 1.0f);
            }
            if (json.has("scale")) {
                JsonElement scaleEle = json.get("scale");
                if (scaleEle.isJsonObject()) {
                    Vec3 scaleVec = UtilParse.readVec3(json, "scale");
                    this.scale3d[0] = (float)scaleVec.m_7096_();
                    this.scale3d[1] = (float)scaleVec.m_7098_();
                    this.scale3d[2] = (float)scaleVec.m_7094_();
                } else if (scaleEle.isJsonPrimitive()) {
                    this.scale = json.get("scale").getAsFloat();
                }
            }
            if (json.has("scalex")) {
                this.scale3d[0] = json.get("scalex").getAsFloat();
            }
            if (json.has("scaley")) {
                this.scale3d[1] = json.get("scaley").getAsFloat();
            }
            if (json.has("scalez")) {
                this.scale3d[2] = json.get("scalez").getAsFloat();
            }
            if (json.has("translate") && json.get("translate").isJsonObject()) {
                this.translate = UtilParse.readVec3f(json, "translate");
            } else {
                if (json.has("translatex")) {
                    this.translate.m_122272_(json.get("translatex").getAsFloat(), 0.0f, 0.0f);
                }
                if (json.has("translatey")) {
                    this.translate.m_122272_(0.0f, json.get("translatey").getAsFloat(), 0.0f);
                }
                if (json.has("translatez")) {
                    this.translate.m_122272_(0.0f, 0.0f, json.get("translatez").getAsFloat());
                }
            }
            if (json.has("rotation") && json.get("rotation").isJsonObject()) {
                Vec3 rotVec = UtilParse.readVec3(json, "rotation");
                this.rotation[0] = (float)rotVec.m_7096_();
                this.rotation[1] = (float)rotVec.m_7098_();
                this.rotation[2] = (float)rotVec.m_7094_();
            } else {
                if (json.has("rotationx")) {
                    this.rotation[0] = json.get("rotationx").getAsFloat();
                }
                if (json.has("rotationy")) {
                    this.rotation[1] = json.get("rotationy").getAsFloat();
                }
                if (json.has("rotationz")) {
                    this.rotation[2] = json.get("rotationz").getAsFloat();
                }
            }
        }

        private ModelOverrides() {
            this.none = true;
        }

        public boolean isNone() {
            return this.none;
        }

        public void apply(PoseStack poseStack) {
            if (this.isNone()) {
                return;
            }
            this.applyRotation(poseStack);
            poseStack.m_85837_((double)this.translate.m_122239_(), (double)this.translate.m_122260_(), (double)this.translate.m_122269_());
            poseStack.m_85841_(this.scale * this.scale3d[0], this.scale * this.scale3d[1], this.scale * this.scale3d[2]);
        }

        public void applyNoTranslate(PoseStack poseStack) {
            if (this.isNone()) {
                return;
            }
            this.applyRotation(poseStack);
            poseStack.m_85841_(this.scale * this.scale3d[0], this.scale * this.scale3d[1], this.scale * this.scale3d[2]);
        }

        public void applyRotation(PoseStack poseStack) {
            if (this.isNone()) {
                return;
            }
            if (this.rotation[0] != 0.0f) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(this.rotation[0]));
            }
            if (this.rotation[1] != 0.0f) {
                poseStack.m_85845_(Vector3f.f_122224_.m_122240_(this.rotation[1]));
            }
            if (this.rotation[2] != 0.0f) {
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(this.rotation[2]));
            }
        }
    }
}

