/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj;

import com.onewhohears.onewholibs.mixin.ModelGroupAccess;
import com.onewhohears.onewholibs.mixin.ModelObjectAccess;
import com.onewhohears.onewholibs.mixin.ObjModelAccess;
import com.onewhohears.onewholibs.util.UtilClientReflection;
import com.onewhohears.onewholibs.util.UtilParse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import joptsimple.internal.Strings;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.obj.ObjLoader;
import net.minecraftforge.client.model.obj.ObjMaterialLibrary;
import net.minecraftforge.client.model.obj.ObjModel;
import net.minecraftforge.client.model.obj.ObjTokenizer;

public class ObjModelParser {
    public static ObjModel parse(ObjTokenizer tokenizer, ObjModel.ModelSettings settings) throws IOException {
        String[] line;
        Map<String, String> deprecationWarnings = Map.of();
        ResourceLocation modelLocation = settings.modelLocation();
        String materialLibraryOverrideLocation = settings.mtlOverride();
        ObjModel model = UtilClientReflection.createNewObjModel(settings, deprecationWarnings);
        String modelDomain = modelLocation.m_135827_();
        String modelPath = modelLocation.m_135815_();
        int lastSlash = modelPath.lastIndexOf(47);
        modelPath = lastSlash >= 0 ? modelPath.substring(0, lastSlash + 1) : "";
        ObjMaterialLibrary mtllib = ObjMaterialLibrary.EMPTY;
        ObjMaterialLibrary.Material currentMat = null;
        String currentSmoothingGroup = null;
        ObjModel.ModelGroup currentGroup = null;
        ObjModel.ModelObject currentObject = null;
        Object currentMesh = null;
        if (materialLibraryOverrideLocation != null) {
            mtllib = materialLibraryOverrideLocation.contains(":") ? ObjLoader.INSTANCE.loadMaterialLibrary(new ResourceLocation(materialLibraryOverrideLocation)) : ObjLoader.INSTANCE.loadMaterialLibrary(new ResourceLocation(modelDomain, modelPath + materialLibraryOverrideLocation));
        }
        while ((line = tokenizer.readAndSplitLine(true)) != null) {
            switch (line[0]) {
                case "mtllib": {
                    if (materialLibraryOverrideLocation != null) break;
                    String lib = line[1];
                    if (lib.contains(":")) {
                        mtllib = ObjLoader.INSTANCE.loadMaterialLibrary(new ResourceLocation(lib));
                        break;
                    }
                    mtllib = ObjLoader.INSTANCE.loadMaterialLibrary(new ResourceLocation(modelDomain, modelPath + lib));
                    break;
                }
                case "usemtl": {
                    String lib = Strings.join((String[])Arrays.copyOfRange(line, 1, line.length), (String)" ");
                    ObjMaterialLibrary.Material newMat = mtllib.getMaterial(lib);
                    if (Objects.equals(newMat, currentMat)) break;
                    currentMat = newMat;
                    if (currentMesh != null && UtilClientReflection.getModelMeshMat(currentMesh) == null && UtilClientReflection.getModelMeshFaces(currentMesh).isEmpty()) {
                        UtilClientReflection.setModelMeshMat(currentMesh, currentMat);
                        break;
                    }
                    currentMesh = null;
                    break;
                }
                case "v": {
                    ((ObjModelAccess)model).getPositions().add(UtilParse.parseVector4To3(line));
                    break;
                }
                case "vt": {
                    ((ObjModelAccess)model).getTexCoords().add(UtilParse.parseVector2(line));
                    break;
                }
                case "vn": {
                    ((ObjModelAccess)model).getNormals().add(UtilParse.parseVector3(line));
                    break;
                }
                case "vc": {
                    ((ObjModelAccess)model).getColors().add(UtilParse.parseVector4(line));
                    break;
                }
                case "f": {
                    if (currentMesh == null) {
                        Objects.requireNonNull(model);
                        currentMesh = UtilClientReflection.createNewModelMesh(model, currentMat, currentSmoothingGroup);
                        if (currentObject != null) {
                            ((ModelObjectAccess)currentObject).getMeshes().add(currentMesh);
                        } else {
                            if (currentGroup == null) {
                                Objects.requireNonNull(model);
                                currentGroup = UtilClientReflection.createModelGroup(model, "");
                                ((ObjModelAccess)model).getParts().put("", currentGroup);
                            }
                            ((ModelObjectAccess)currentGroup).getMeshes().add(currentMesh);
                        }
                    }
                    int[][] vertices = new int[line.length - 1][];
                    for (int i = 0; i < vertices.length; ++i) {
                        String vertexData = line[i + 1];
                        String[] vertexParts = vertexData.split("/");
                        int[] vertex = Arrays.stream(vertexParts).mapToInt(num -> Strings.isNullOrEmpty((String)num) ? 0 : Integer.parseInt(num)).toArray();
                        vertex[0] = vertex[0] < 0 ? vertex[0] + ((ObjModelAccess)model).getPositions().size() : vertex[0] - 1;
                        if (vertex.length > 1) {
                            vertex[1] = vertex[1] < 0 ? vertex[1] + ((ObjModelAccess)model).getTexCoords().size() : vertex[1] - 1;
                            if (vertex.length > 2) {
                                vertex[2] = vertex[2] < 0 ? vertex[2] + ((ObjModelAccess)model).getNormals().size() : vertex[2] - 1;
                                if (vertex.length > 3) {
                                    vertex[3] = vertex[3] < 0 ? vertex[3] + ((ObjModelAccess)model).getColors().size() : vertex[3] - 1;
                                }
                            }
                        }
                        vertices[i] = vertex;
                    }
                    UtilClientReflection.getModelMeshFaces(currentMesh).add(vertices);
                    break;
                }
                case "s": {
                    String lib;
                    String string = lib = "off".equals(line[1]) ? null : line[1];
                    if (Objects.equals(currentSmoothingGroup, lib)) break;
                    currentSmoothingGroup = lib;
                    if (currentMesh != null && UtilClientReflection.getModelMeshSmoothingGroup(currentMesh) == null && UtilClientReflection.getModelMeshFaces(currentMesh).isEmpty()) {
                        UtilClientReflection.setModelMeshSmoothingGroup(currentMesh, currentSmoothingGroup);
                        break;
                    }
                    currentMesh = null;
                    break;
                }
                case "g": {
                    String groupName = line[line.length - 1];
                    Objects.requireNonNull(model);
                    if (((ObjModelAccess)model).getParts().containsKey(groupName)) {
                        currentGroup = ((ObjModelAccess)model).getParts().get(groupName);
                    } else {
                        currentGroup = UtilClientReflection.createModelGroup(model, groupName);
                        ((ObjModelAccess)model).getParts().put(groupName, currentGroup);
                    }
                    for (int i = line.length - 2; i >= 1; --i) {
                        groupName = line[i];
                        ObjModel.ModelGroup prevGroup = currentGroup;
                        currentGroup = ((ModelGroupAccess)prevGroup).getParts().containsKey(groupName) ? (ObjModel.ModelGroup)((ModelGroupAccess)prevGroup).getParts().get(groupName) : UtilClientReflection.createModelGroup(model, groupName);
                        ((ModelGroupAccess)prevGroup).getParts().put(groupName, (ObjModel.ModelObject)currentGroup);
                    }
                    currentObject = null;
                    currentMesh = null;
                    break;
                }
                case "o": {
                    String lib = line[1];
                    Objects.requireNonNull(model);
                    if (currentGroup != null) {
                        currentObject = UtilClientReflection.createModelObject(model, lib);
                        ((ModelGroupAccess)currentGroup).getParts().put(lib, currentObject);
                    } else {
                        currentObject = UtilClientReflection.createModelGroup(model, lib);
                        ((ObjModelAccess)model).getParts().put(lib, (ObjModel.ModelGroup)currentObject);
                    }
                    currentMesh = null;
                }
            }
        }
        return model;
    }
}

