/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj.customanims;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import com.onewhohears.onewholibs.client.model.obj.customanims.EntityModelTransform;
import com.onewhohears.onewholibs.util.UtilParse;

public class CustomAnimsBuilder {
    protected final JsonArray anims = new JsonArray();

    public static CustomAnimsBuilder create() {
        return new CustomAnimsBuilder();
    }

    protected CustomAnimsBuilder() {
    }

    public JsonArray build() {
        return this.anims;
    }

    protected JsonObject createAnimJson(String model_part_key) {
        JsonObject anim = new JsonObject();
        anim.addProperty("model_part_key", model_part_key);
        this.anims.add((JsonElement)anim);
        return anim;
    }

    protected void fillAxisRotationParams(JsonObject anim, float pivotX, float pivotY, float pivotZ, EntityModelTransform.RotationAxis rot_axis) {
        UtilParse.writeVec3f(anim, "pivot", new Vector3f(pivotX, pivotY, pivotZ));
        UtilParse.writeEnum(anim, "rot_axis", rot_axis);
    }

    protected void fillAxisRotationPixelParams(JsonObject anim, float pivotX, float pivotY, float pivotZ, EntityModelTransform.RotationAxis rot_axis) {
        this.fillAxisRotationParams(anim, pivotX / 16.0f, pivotY / 16.0f, pivotZ / 16.0f, rot_axis);
    }

    public CustomAnimsBuilder addContinuousRotAnim(String model_part_key, float pivotX, float pivotY, float pivotZ, EntityModelTransform.RotationAxis rot_axis, float rot_rate) {
        JsonObject anim = this.createAnimJson(model_part_key);
        anim.addProperty("anim_id", "continuous_rotation");
        this.fillAxisRotationParams(anim, pivotX, pivotY, pivotZ, rot_axis);
        anim.addProperty("rot_rate", (Number)Float.valueOf(rot_rate));
        return this;
    }

    public CustomAnimsBuilder addContinuousRotPixelAnim(String model_part_key, float pivotX, float pivotY, float pivotZ, EntityModelTransform.RotationAxis rot_axis, float rot_rate) {
        JsonObject anim = this.createAnimJson(model_part_key);
        anim.addProperty("anim_id", "continuous_rotation");
        this.fillAxisRotationPixelParams(anim, pivotX, pivotY, pivotZ, rot_axis);
        anim.addProperty("rot_rate", (Number)Float.valueOf(rot_rate));
        return this;
    }

    public CustomAnimsBuilder addAlwaysHideAnim(String model_part_key) {
        JsonObject anim = this.createAnimJson(model_part_key);
        anim.addProperty("anim_id", "always_hide");
        return this;
    }

    public CustomAnimsBuilder addAlwaysHideAnims(String ... model_part_keys) {
        for (String key : model_part_keys) {
            this.addAlwaysHideAnim(key);
        }
        return this;
    }
}

