/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.item.ObjModelItem;
import com.onewhohears.onewholibs.mixin.ObjModelAccess;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.obj.ObjModel;
import net.minecraftforge.client.model.renderable.CompositeRenderable;

public class RendererObjModelItems
extends BlockEntityWithoutLevelRenderer {
    private static RendererObjModelItems instance;
    private final Map<String, ItemObjModelData> models = new HashMap<String, ItemObjModelData>();

    public static RendererObjModelItems get() {
        if (instance == null) {
            Minecraft m = Minecraft.m_91087_();
            instance = new RendererObjModelItems(m.m_167982_(), m.m_167973_());
        }
        return instance;
    }

    protected RendererObjModelItems(BlockEntityRenderDispatcher blockEntityRenderDispatcher, EntityModelSet entityModelSet) {
        super(blockEntityRenderDispatcher, entityModelSet);
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.models.clear();
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Item item = stack.m_41720_();
        if (item instanceof ObjModelItem) {
            ObjModelItem objItem = (ObjModelItem)item;
            String preset = objItem.getPreset(stack);
            ItemObjModelData model = this.models.get(preset);
            if (model == null) {
                String modelId = objItem.getObjModelId(preset);
                CompositeRenderable composite = ObjEntityModels.get().getBakedModel(modelId);
                ObjEntityModels.ModelOverrides override = ObjEntityModels.get().getModelOverride(modelId);
                ObjModel obj = ObjEntityModels.get().getUnbakedModel(modelId);
                ObjEntityModels.ModelOverrides itemModelOverrides = objItem.getItemModelOverrides(preset);
                model = new ItemObjModelData(composite, override, obj, itemModelOverrides);
                this.models.put(preset, model);
            }
            model.render(transformType, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    public static class ItemObjModelData {
        public static final float SIZE_SCALE_FACTOR = 1.25f;
        public final CompositeRenderable compositeRenderable;
        public final ObjEntityModels.ModelOverrides modelOverrides;
        public final ObjEntityModels.ModelOverrides itemModelOverrides;
        public final Vec3 center;
        public final float scale;

        public ItemObjModelData(CompositeRenderable compositeRenderable, ObjEntityModels.ModelOverrides modelOverrides, ObjModel obj, ObjEntityModels.ModelOverrides itemModelOverrides) {
            this.compositeRenderable = compositeRenderable;
            this.modelOverrides = modelOverrides;
            this.itemModelOverrides = itemModelOverrides;
            Vec3[] sizeCenter = UtilGeometry.getSizeCenter(((ObjModelAccess)obj).getPositions());
            Vec3 size = sizeCenter[0];
            float maxSize = (float)Math.max(size.m_7094_(), Math.max(size.m_7096_(), size.m_7098_()));
            this.center = sizeCenter[1];
            this.scale = 1.25f / maxSize;
        }

        public void render(ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
            poseStack.m_85836_();
            this.modelOverrides.applyRotation(poseStack);
            this.itemModelOverrides.apply(poseStack);
            if (transformType == ItemTransforms.TransformType.GUI) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(30.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
            } else if (transformType == ItemTransforms.TransformType.FIXED) {
                poseStack.m_85837_(0.5, 0.5, 0.35);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            } else if (transformType == ItemTransforms.TransformType.GROUND) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
            } else if (transformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                poseStack.m_85837_(0.5, 0.5, 0.3);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(30.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(225.0f));
            } else if (transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
                poseStack.m_85837_(0.5, 0.5, 0.3);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(30.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(135.0f));
            } else if (transformType == ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(225.0f));
            } else if (transformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(135.0f));
            } else if (transformType == ItemTransforms.TransformType.HEAD) {
                poseStack.m_85837_(0.5, 1.2, 0.5);
                poseStack.m_85841_(2.0f, 2.0f, 2.0f);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            } else if (transformType == ItemTransforms.TransformType.NONE) {
                poseStack.m_85837_(0.5, 0.5, 0.5);
            }
            poseStack.m_85841_(this.scale, this.scale, this.scale);
            poseStack.m_85837_((double)((float)(-this.center.m_7096_())), (double)((float)(-this.center.m_7098_())), (double)((float)(-this.center.m_7094_())));
            this.compositeRenderable.render(poseStack, buffer, RenderType::m_110446_, packedLight, packedOverlay, 0.0f, CompositeRenderable.Transforms.EMPTY);
            poseStack.m_85849_();
        }
    }
}

