/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.onewholibs.util.UtilMCText;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class BackgroundScreen
extends Screen {
    public final ResourceLocation background_texture;
    public final int image_width;
    public final int image_height;
    public final int texture_width;
    public final int texture_height;
    protected int guiX;
    protected int guiY;
    protected int top_padding = 4;
    protected int bottom_padding = 4;
    protected int left_padding = 4;
    protected int right_padding = 4;
    protected int vertical_widget_shift = 0;

    protected BackgroundScreen(Component title, ResourceLocation backgroundTexture, int imageWidth, int imageHeight, int textureWidth, int textureHeight) {
        super(title);
        this.background_texture = backgroundTexture;
        this.image_width = imageWidth;
        this.image_height = imageHeight;
        this.texture_width = textureWidth;
        this.texture_height = textureHeight;
    }

    protected BackgroundScreen(String translatableScreenName, ResourceLocation backgroundTexture, int imageWidth, int imageHeight, int textureWidth, int textureHeight) {
        this((Component)UtilMCText.translatable(translatableScreenName), backgroundTexture, imageWidth, imageHeight, textureWidth, textureHeight);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiX = this.f_96543_ / 2 - this.image_width / 2;
        this.guiY = this.f_96544_ / 2 - this.image_height / 2;
    }

    protected AbstractWidget positionWidgetGrid(AbstractWidget widget, int rows, int columns, int index, int padding, int widget_columns) {
        if (rows <= 0) {
            rows = 1;
        }
        if (columns <= 0) {
            columns = 1;
        }
        int index_max = rows * columns - 1;
        if (index < 0) {
            index = 0;
        } else if (index > index_max) {
            index = index_max;
        }
        int widget_row = index / columns;
        int widget_column = index % columns;
        int column_width = (this.image_width - this.left_padding - this.right_padding) / columns;
        int row_height = (this.image_height - this.top_padding - this.bottom_padding) / rows;
        int widget_x = this.guiX + this.left_padding + widget_column * column_width + padding / 2;
        int widget_y = this.guiY + this.vertical_widget_shift + this.top_padding + widget_row * row_height;
        int widget_width = column_width * widget_columns - padding;
        widget.f_93620_ = widget_x;
        widget.f_93621_ = widget_y += (row_height - widget.m_93694_() + padding) / 2;
        widget.m_93674_(widget_width);
        this.m_142416_((GuiEventListener)widget);
        return widget;
    }

    protected AbstractWidget positionWidgetGrid(AbstractWidget widget, int rows, int columns, int index, int padding) {
        return this.positionWidgetGrid(widget, rows, columns, index, padding, 1);
    }

    protected AbstractWidget positionWidgetGrid(AbstractWidget widget, int rows, int columns, int index) {
        return this.positionWidgetGrid(widget, rows, columns, index, 2);
    }

    public void m_6305_(@NotNull PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, pMouseX, pMouseY, pPartialTick);
    }

    public void m_7333_(@NotNull PoseStack poseStack) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.background_texture);
        BackgroundScreen.m_93133_((PoseStack)poseStack, (int)this.guiX, (int)this.guiY, (float)0.0f, (float)0.0f, (int)this.image_width, (int)this.image_height, (int)this.texture_width, (int)this.texture_height);
    }
}

