/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.common.command;

import com.onewhohears.onewholibs.util.UtilSync;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;

public class CustomGameRules {
    private static final List<GameRules.Key<GameRules.BooleanValue>> syncBools = new ArrayList<GameRules.Key<GameRules.BooleanValue>>();
    private static final List<GameRules.Key<GameRules.IntegerValue>> syncInts = new ArrayList<GameRules.Key<GameRules.IntegerValue>>();

    public static List<GameRules.Key<GameRules.BooleanValue>> getSyncBools() {
        return syncBools;
    }

    public static List<GameRules.Key<GameRules.IntegerValue>> getSyncInts() {
        return syncInts;
    }

    public static BiConsumer<MinecraftServer, GameRules.BooleanValue> clientSyncListener() {
        return (server, value) -> UtilSync.syncGameRules(server);
    }

    public static GameRules.Key<GameRules.BooleanValue> registerBoolean(String name, boolean defaultValue) {
        return CustomGameRules.registerBoolean(name, defaultValue, GameRules.Category.MISC);
    }

    public static GameRules.Key<GameRules.BooleanValue> registerBoolean(String name, boolean defaultValue, GameRules.Category category) {
        return GameRules.m_46189_((String)name, (GameRules.Category)category, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)defaultValue));
    }

    public static GameRules.Key<GameRules.BooleanValue> registerBoolean(String name, boolean defaultValue, GameRules.Category category, BiConsumer<MinecraftServer, GameRules.BooleanValue> listener) {
        return GameRules.m_46189_((String)name, (GameRules.Category)category, (GameRules.Type)GameRules.BooleanValue.m_46252_((boolean)defaultValue, listener));
    }

    public static GameRules.Key<GameRules.BooleanValue> registerSyncBoolean(String name, boolean defaultValue, GameRules.Category category) {
        GameRules.Key<GameRules.BooleanValue> bool = CustomGameRules.registerBoolean(name, defaultValue, category, CustomGameRules.clientSyncListener());
        syncBools.add(bool);
        return bool;
    }

    public static GameRules.Key<GameRules.IntegerValue> registerInteger(String name, int defaultValue, GameRules.Category category) {
        return GameRules.m_46189_((String)name, (GameRules.Category)category, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)defaultValue));
    }
}

