/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.common.network.toclient;

import com.onewhohears.onewholibs.common.command.CustomGameRules;
import com.onewhohears.onewholibs.common.event.OnSyncBoolGameRuleEvent;
import com.onewhohears.onewholibs.common.event.OnSyncIntGameRuleEvent;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;

public class ToClientSyncGameRules {
    private final MinecraftServer server;

    public ToClientSyncGameRules(MinecraftServer server) {
        this.server = server;
    }

    public ToClientSyncGameRules(FriendlyByteBuf buffer) {
        this.server = null;
        int boolNum = buffer.readInt();
        for (int i = 0; i < boolNum; ++i) {
            String id = buffer.m_130277_();
            boolean bool = buffer.readBoolean();
            MinecraftForge.EVENT_BUS.post((Event)new OnSyncBoolGameRuleEvent(id, bool));
        }
        int intNum = buffer.readInt();
        for (int i = 0; i < intNum; ++i) {
            String id = buffer.m_130277_();
            int integer = buffer.readInt();
            MinecraftForge.EVENT_BUS.post((Event)new OnSyncIntGameRuleEvent(id, integer));
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        GameRules gamerules = this.server.m_129900_();
        buffer.writeInt(CustomGameRules.getSyncBools().size());
        CustomGameRules.getSyncBools().forEach(booleanValueKey -> {
            buffer.m_130070_(booleanValueKey.m_46328_());
            buffer.writeBoolean(gamerules.m_46207_(booleanValueKey));
        });
        buffer.writeInt(CustomGameRules.getSyncInts().size());
        CustomGameRules.getSyncInts().forEach(integerValueKey -> {
            buffer.m_130070_(integerValueKey.m_46328_());
            buffer.writeInt(gamerules.m_46215_(integerValueKey));
        });
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        return true;
    }
}

