/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.crafting;

import com.onewhohears.onewholibs.util.UtilItem;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientStack
extends Ingredient {
    public final int cost;

    public static IngredientStack fromItem(String itemId, int cost) {
        return new IngredientStack((Ingredient.Value)new Ingredient.ItemValue(UtilItem.getItem(itemId).m_7968_()), cost);
    }

    public static IngredientStack fromTag(String tagId, int cost) {
        return new IngredientStack((Ingredient.Value)new Ingredient.TagValue(ItemTags.create((ResourceLocation)new ResourceLocation(tagId))), cost);
    }

    public static IngredientStack fromIngredient(Ingredient ingredient) {
        Ingredient.Value[] values = new Ingredient.Value[ingredient.m_43908_().length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new Ingredient.ItemValue(ingredient.m_43908_()[i]);
        }
        return new IngredientStack(Stream.of(values), 1);
    }

    protected IngredientStack(Ingredient.Value value, int cost) {
        this(Stream.of(value), cost);
    }

    protected IngredientStack(Stream<Ingredient.Value> values, int cost) {
        super(values);
        this.cost = cost;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        ItemStack[] items = this.m_43908_();
        if (items.length == 0) {
            return stack.m_41619_();
        }
        for (ItemStack itemstack : items) {
            if (!itemstack.m_150930_(stack.m_41720_()) || stack.m_41613_() < this.cost) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] m_43908_() {
        ItemStack[] items;
        for (ItemStack item : items = super.m_43908_()) {
            item.m_41764_(this.cost);
        }
        return items;
    }
}

