/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.data.jsonpreset;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public abstract class JsonPresetGenerator<T extends JsonPresetStats>
implements DataProvider {
    protected final Logger LOGGER = LogUtils.getLogger();
    protected final DataGenerator.PathProvider pathProvider;
    public final Map<ResourceLocation, T> GEN_MAP = new HashMap<ResourceLocation, T>();

    public JsonPresetGenerator(DataGenerator output, String kind) {
        this(output, kind, DataGenerator.Target.DATA_PACK);
    }

    public JsonPresetGenerator(DataGenerator output, String kind, DataGenerator.Target target) {
        this.pathProvider = output.m_236036_(target, kind);
    }

    protected abstract void registerPresets();

    public void m_213708_(CachedOutput cache) throws IOException {
        this.GEN_MAP.clear();
        this.registerPresets();
        HashSet set = Sets.newHashSet();
        Consumer<JsonPresetStats> consumer = preset -> {
            this.LOGGER.debug("GENERATING: {}", (Object)preset.getKey().toString());
            if (!set.add(preset.getKey())) {
                throw new IllegalStateException("Duplicate Preset! " + String.valueOf(preset.getKey()));
            }
            Path path = this.pathProvider.m_236048_(preset.getKey());
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)preset.getJsonData(), (Path)path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        this.generatePresets(consumer);
    }

    protected void generatePresets(Consumer<T> consumer) {
        this.GEN_MAP.forEach((key, preset) -> consumer.accept(preset));
    }

    public void addPresetToGenerate(T preset) {
        this.GEN_MAP.put(((JsonPresetStats)preset).getKey(), preset);
    }
}

