/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.util.math;

import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class UtilAngles {
    public static double getHorizontalDistanceSqr(Vec3 vec3) {
        return Math.sqrt(vec3.f_82479_ * vec3.f_82479_ + vec3.f_82481_ * vec3.f_82481_);
    }

    public static double normalizedDotProduct(Vec3 v1, Vec3 v2) {
        return v1.m_82526_(v2) / (v1.m_82553_() * v2.m_82553_());
    }

    public static float getPitch(Vec3 motion) {
        double y = -motion.f_82480_;
        return (float)Math.toDegrees(Math.atan2(y, Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)));
    }

    public static float getYaw(Vec3 motion) {
        return (float)Math.toDegrees(Math.atan2(-motion.f_82479_, motion.f_82481_));
    }

    public static float lerpAngle(float perc, float start, float end) {
        return start + perc * Mth.m_14177_((float)(end - start));
    }

    public static float lerpAngle180(float perc, float start, float end) {
        if (UtilAngles.degreesDifferenceAbs(start, end) > 90.0) {
            end += 180.0f;
        }
        return start + perc * Mth.m_14177_((float)(end - start));
    }

    public static double lerpAngle180(double perc, double start, double end) {
        if (UtilAngles.degreesDifferenceAbs(start, end) > 90.0) {
            end += 180.0;
        }
        return start + perc * Mth.m_14175_((double)(end - start));
    }

    public static double lerpAngle(double perc, double start, double end) {
        return start + perc * Mth.m_14175_((double)(end - start));
    }

    public static double degreesDifferenceAbs(double p_203301_0_, double p_203301_1_) {
        return Math.abs(UtilAngles.wrapSubtractDegrees(p_203301_0_, p_203301_1_));
    }

    public static double wrapSubtractDegrees(double p_203302_0_, double p_203302_1_) {
        return Mth.m_14175_((double)(p_203302_1_ - p_203302_0_));
    }

    public static float rotLerp(float currentAngle, float targetAngle, float stepSize) {
        float f = Mth.m_14177_((float)(targetAngle - currentAngle));
        if (f > stepSize) {
            f = stepSize;
        }
        if (f < -stepSize) {
            f = -stepSize;
        }
        return currentAngle + f;
    }

    public static Vec3 rotationToVector(double yaw, double pitch) {
        yaw = Math.toRadians(yaw);
        pitch = Math.toRadians(pitch);
        double xzLen = Math.cos(pitch);
        double x = -xzLen * Math.sin(yaw);
        double y = Math.sin(-pitch);
        double z = xzLen * Math.cos(-yaw);
        return new Vec3(x, y, z);
    }

    public static Vec3 rotationToVector(double yaw, double pitch, double size) {
        Vec3 vec = UtilAngles.rotationToVector(yaw, pitch);
        return vec.m_82490_(size / vec.m_82553_());
    }

    public static Vec3 inaccurateDirection(Vec3 dir, float inaccuracy) {
        float yaw = UtilAngles.getYaw(dir);
        float pitch = UtilAngles.getPitch(dir);
        Random r = new Random();
        return UtilAngles.rotationToVector(yaw += (r.nextFloat() - 0.5f) * 2.0f * inaccuracy, pitch += (r.nextFloat() - 0.5f) * 2.0f * inaccuracy);
    }

    public static void normalizeRCloseToONE(Quaternion q, float d) {
        q.m_80160_();
        if (Mth.m_14154_((float)(Mth.m_14154_((float)q.m_80156_()) - 1.0f)) < d) {
            q.m_80143_(0.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    public static Quaternion qDiff(Quaternion q1, Quaternion q2) {
        if (q1.equals((Object)q2)) {
            return Quaternion.f_80118_.m_80161_();
        }
        Quaternion iq2 = q2.m_80161_();
        iq2.m_80157_();
        Quaternion d = q1.m_80161_();
        d.m_80148_(iq2);
        d.m_80160_();
        return d;
    }

    public static EulerAngles toRadians(Quaternion q) {
        EulerAngles angles = new EulerAngles();
        double sinr_cosp = 2.0f * (q.m_80156_() * q.m_80153_() + q.m_80140_() * q.m_80150_());
        double cosr_cosp = 1.0f - 2.0f * (q.m_80153_() * q.m_80153_() + q.m_80140_() * q.m_80140_());
        angles.roll = Math.atan2(sinr_cosp, cosr_cosp);
        double sinp = 2.0f * (q.m_80156_() * q.m_80140_() - q.m_80150_() * q.m_80153_());
        angles.pitch = Math.abs(sinp) >= 0.999 ? Math.signum(sinp) * Math.PI / 2.0 : Math.asin(sinp);
        double siny_cosp = 2.0f * (q.m_80156_() * q.m_80150_() + q.m_80153_() * q.m_80140_());
        double cosy_cosp = 1.0f - 2.0f * (q.m_80140_() * q.m_80140_() + q.m_80150_() * q.m_80150_());
        angles.yaw = -Math.atan2(siny_cosp, cosy_cosp);
        return angles;
    }

    public static EulerAngles toDegrees(Quaternion q) {
        EulerAngles angles = UtilAngles.toRadians(q);
        angles.roll = Math.toDegrees(angles.roll);
        angles.pitch = Math.toDegrees(angles.pitch);
        angles.yaw = Math.toDegrees(angles.yaw);
        return angles;
    }

    public static float fastInvSqrt(float number) {
        float f = 0.5f * number;
        int i = Float.floatToIntBits(number);
        i = 1597463007 - (i >> 1);
        number = Float.intBitsToFloat(i);
        return number * (1.5f - f * number * number);
    }

    public static Quaternion normalizeQuaternion(Quaternion q) {
        float f = q.m_80140_() * q.m_80140_() + q.m_80150_() * q.m_80150_() + q.m_80153_() * q.m_80153_() + q.m_80156_() * q.m_80156_();
        float x = q.m_80140_();
        float y = q.m_80150_();
        float z = q.m_80153_();
        float w = q.m_80156_();
        if (f > 1.0E-6f) {
            float f1 = UtilAngles.fastInvSqrt(f);
            return new Quaternion(x *= f1, y *= f1, z *= f1, w *= f1);
        }
        return new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Quaternion toQuaternion(double yaw, double pitch, double roll) {
        yaw = -Math.toRadians(yaw);
        pitch = Math.toRadians(pitch);
        roll = Math.toRadians(roll);
        double cy = Math.cos(yaw * 0.5);
        double sy = Math.sin(yaw * 0.5);
        double cp = Math.cos(pitch * 0.5);
        double sp = Math.sin(pitch * 0.5);
        double cr = Math.cos(roll * 0.5);
        double sr = Math.sin(roll * 0.5);
        float w = (float)(cr * cp * cy + sr * sp * sy);
        float z = (float)(sr * cp * cy - cr * sp * sy);
        float x = (float)(cr * sp * cy + sr * cp * sy);
        float y = (float)(cr * cp * sy - sr * sp * cy);
        return new Quaternion(x, y, z, w);
    }

    public static Quaternion lerpQ(float perc, Quaternion start, Quaternion end) {
        return UtilAngles.lerpQ(perc, start, end, false);
    }

    public static Quaternion lerpQ(float perc, Quaternion start, Quaternion end, boolean normalize) {
        double DOT_THRESHOLD;
        double dot;
        if (normalize) {
            start = UtilAngles.normalizeQuaternion(start);
            end = UtilAngles.normalizeQuaternion(end);
        }
        if ((dot = (double)(start.m_80140_() * end.m_80140_() + start.m_80150_() * end.m_80150_() + start.m_80153_() * end.m_80153_() + start.m_80156_() * end.m_80156_())) < 0.0) {
            end = new Quaternion(-end.m_80140_(), -end.m_80150_(), -end.m_80153_(), -end.m_80156_());
            dot = -dot;
        }
        if (dot > (DOT_THRESHOLD = 0.9995)) {
            Quaternion quaternion = new Quaternion(start.m_80140_() * (1.0f - perc) + end.m_80140_() * perc, start.m_80150_() * (1.0f - perc) + end.m_80150_() * perc, start.m_80153_() * (1.0f - perc) + end.m_80153_() * perc, start.m_80156_() * (1.0f - perc) + end.m_80156_() * perc);
            if (normalize) {
                return UtilAngles.normalizeQuaternion(quaternion);
            }
            return quaternion;
        }
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * (double)perc;
        double sin_theta = Math.sin(theta);
        double sin_theta_0 = Math.sin(theta_0);
        float s0 = (float)(Math.cos(theta) - dot * sin_theta / sin_theta_0);
        float s1 = (float)(sin_theta / sin_theta_0);
        Quaternion quaternion = new Quaternion(start.m_80140_() * s0 + end.m_80140_() * s1, start.m_80150_() * s0 + end.m_80150_() * s1, start.m_80153_() * s0 + end.m_80153_() * s1, start.m_80156_() * s0 + end.m_80156_() * s1);
        if (normalize) {
            return UtilAngles.normalizeQuaternion(quaternion);
        }
        return quaternion;
    }

    public static Vec3 getRollAxis(Quaternion q) {
        EulerAngles a = UtilAngles.toRadians(q);
        return UtilAngles.getRollAxis(a.pitch, a.yaw);
    }

    public static Vec3 getRollAxis(double pitchRad, double yawRad) {
        return new Vec3(-Math.sin(yawRad) * Math.cos(pitchRad), Math.sin(-pitchRad), Math.cos(yawRad) * Math.cos(pitchRad));
    }

    public static Vec3 getPitchAxis(Quaternion q) {
        EulerAngles a = UtilAngles.toRadians(q);
        return UtilAngles.getPitchAxis(a.pitch, a.yaw, a.roll);
    }

    public static Vec3 getPitchAxis(double pitchRad, double yawRad, double rollRad) {
        double CP = Math.cos(-pitchRad);
        double SP = Math.sin(-pitchRad);
        double CY = Math.cos(yawRad);
        double SY = Math.sin(yawRad);
        double CR = Math.cos(rollRad);
        double SR = Math.sin(rollRad);
        return new Vec3(CY * CR + SY * SP * SR, CP * SR, -(CY * SP * SR - CR * SY));
    }

    public static Vec3 getYawAxis(Quaternion q) {
        EulerAngles a = UtilAngles.toRadians(q);
        return UtilAngles.getYawAxis(a.pitch, a.yaw, a.roll);
    }

    public static Vec3 getYawAxis(double pitchRad, double yawRad, double rollRad) {
        double CP = Math.cos(-pitchRad);
        double SP = Math.sin(-pitchRad);
        double CY = Math.cos(yawRad);
        double SY = Math.sin(yawRad);
        double CR = Math.cos(rollRad);
        double SR = Math.sin(rollRad);
        return new Vec3(CR * SY * SP - CY * SR, CP * CR, -(SY * SR + CY * SP * CR));
    }

    public static Vector3f rotateVector(Vector3f n, Quaternion q) {
        float p = 1000.0f;
        float pi = 0.001f;
        Quaternion nq = new Quaternion(n.m_122239_() * p, n.m_122260_() * p, n.m_122269_() * p, 0.0f);
        Quaternion cq = q.m_80161_();
        cq.m_80157_();
        Quaternion q1 = q.m_80161_();
        q1.m_80148_(nq);
        q1.m_80148_(cq);
        return new Vector3f(q1.m_80140_() * pi, q1.m_80150_() * pi, q1.m_80153_() * pi);
    }

    public static Vector3f rotateVectorInverse(Vector3f n, Quaternion q) {
        Quaternion q1 = q.m_80161_();
        q1.m_80157_();
        return UtilAngles.rotateVector(n, q1);
    }

    public static Vec3 rotateVector(Vec3 n, Quaternion q) {
        Quaternion nq = new Quaternion((float)n.f_82479_, (float)n.f_82480_, (float)n.f_82481_, 0.0f);
        Quaternion cq = q.m_80161_();
        cq.m_80157_();
        Quaternion q1 = q.m_80161_();
        q1.m_80148_(nq);
        q1.m_80148_(cq);
        Vec3 a = new Vec3((double)q1.m_80140_(), (double)q1.m_80150_(), (double)q1.m_80153_());
        return a;
    }

    public static Vec3 rotateVectorInverse(Vec3 n, Quaternion q) {
        Quaternion q1 = q.m_80161_();
        q1.m_80157_();
        return UtilAngles.rotateVector(n, q1);
    }

    public static float[] globalToRelativeDegrees(float gx, float gy, Quaternion ra) {
        Vec3 dir = UtilAngles.rotationToVector(gy, gx);
        EulerAngles ea = UtilAngles.toRadians(ra);
        Vec3 yaxis = UtilAngles.getYawAxis(ea.pitch, ea.yaw, ea.roll).m_82490_(-1.0);
        Vec3 zaxis = UtilAngles.getRollAxis(ea.pitch, ea.yaw);
        Vec3 xaxis = UtilAngles.getPitchAxis(ea.pitch, ea.yaw, ea.roll).m_82490_(-1.0);
        float rx = (float)UtilGeometry.angleBetweenVecPlaneDegrees(dir, yaxis);
        double xc = UtilGeometry.vecCompMagDirByNormAxis(dir, xaxis);
        double zc = UtilGeometry.vecCompMagDirByNormAxis(dir, zaxis);
        float ry = (float)Math.toDegrees(Math.atan2(xc, zc));
        return new float[]{rx, ry};
    }

    public static float[] relativeToGlobalDegrees(float rx, float ry, Quaternion ra) {
        Quaternion r = ra.m_80161_();
        r.m_80148_(Vector3f.f_122224_.m_122240_(ry));
        r.m_80148_(Vector3f.f_122223_.m_122240_(rx));
        EulerAngles ea = UtilAngles.toDegrees(r);
        return new float[]{(float)ea.pitch, (float)ea.yaw};
    }

    public static Matrix4f pivotRot(Vector3f pivot, Quaternion rot) {
        return UtilAngles.pivotRot(pivot.m_122239_(), pivot.m_122260_(), pivot.m_122269_(), rot);
    }

    public static Matrix4f pivotInvRot(Vector3f pivot, Quaternion rot) {
        return UtilAngles.pivotRot(-pivot.m_122239_(), -pivot.m_122260_(), -pivot.m_122269_(), rot);
    }

    public static Matrix4f pivotRot(float x, float y, float z, Quaternion rot) {
        Matrix4f mat = Matrix4f.m_27653_((float)x, (float)y, (float)z);
        mat.m_27646_(rot);
        mat.m_27644_(Matrix4f.m_27653_((float)(-x), (float)(-y), (float)(-z)));
        return mat;
    }

    public static Matrix4f pivotRotX(float x, float y, float z, float degrees) {
        return UtilAngles.pivotRot(x, y, z, Vector3f.f_122223_.m_122240_(degrees));
    }

    public static Matrix4f pivotRotY(float x, float y, float z, float degrees) {
        return UtilAngles.pivotRot(x, y, z, Vector3f.f_122225_.m_122240_(degrees));
    }

    public static Matrix4f pivotRotZ(float x, float y, float z, float degrees) {
        return UtilAngles.pivotRot(x, y, z, Vector3f.f_122227_.m_122240_(degrees));
    }

    public static Matrix4f pivotPixelsRot(float x, float y, float z, Quaternion rot) {
        return UtilAngles.pivotRot(x * 0.0625f, y * 0.0625f, z * 0.0625f, rot);
    }

    public static Matrix4f pivotPixelsRotX(float x, float y, float z, float degrees) {
        return UtilAngles.pivotPixelsRot(x, y, z, Vector3f.f_122223_.m_122240_(degrees));
    }

    public static Matrix4f pivotPixelsRotY(float x, float y, float z, float degrees) {
        return UtilAngles.pivotPixelsRot(x, y, z, Vector3f.f_122225_.m_122240_(degrees));
    }

    public static Matrix4f pivotPixelsRotZ(float x, float y, float z, float degrees) {
        return UtilAngles.pivotPixelsRot(x, y, z, Vector3f.f_122227_.m_122240_(degrees));
    }

    public static class EulerAngles {
        public double pitch;
        public double yaw;
        public double roll;

        public EulerAngles() {
        }

        private EulerAngles(EulerAngles a) {
            this.pitch = a.pitch;
            this.yaw = a.yaw;
            this.roll = a.roll;
        }

        public EulerAngles copy() {
            return new EulerAngles(this);
        }

        public String toString() {
            return "EulerAngles{pitch=" + this.pitch + ", yaw=" + this.yaw + ", roll=" + this.roll + "}";
        }
    }
}

