/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.configbuilder.entry.ConfigEntry;
import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceList;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class SelectDeviceScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_audio_devices.png");
    protected static final Component BACK = Component.m_237115_((String)"message.voicechat.back");
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    @Nullable
    protected Screen parent;
    protected AudioDeviceList deviceList;
    protected Button back;
    protected int units;

    public SelectDeviceScreen(Component title, @Nullable Screen parent) {
        super(title, 236, 0);
        this.parent = parent;
    }

    public abstract List<String> getDevices();

    public abstract ResourceLocation getIcon();

    public abstract Component getEmptyListComponent();

    public abstract ConfigEntry<String> getConfigEntry();

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = Mth.m_14167_((float)2.2222223f);
        this.units = Math.max(minUnits, (this.f_96544_ - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        if (this.deviceList != null) {
            this.deviceList.updateSize(this.f_96543_, this.units * 18, this.guiTop + 16);
        } else {
            this.deviceList = new AudioDeviceList(this.f_96543_, this.units * 18, this.guiTop + 16).setIcon(this.getIcon()).setConfigEntry(this.getConfigEntry());
        }
        this.m_7787_((GuiEventListener)this.deviceList);
        this.back = new Button(this.guiLeft + 7, this.guiTop + this.ySize - 20 - 7, this.xSize - 14, 20, BACK, button -> this.f_96541_.m_91152_(this.parent));
        this.m_142416_((GuiEventListener)this.back);
        this.deviceList.setAudioDevices(this.getDevices());
    }

    @Override
    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        if (this.isIngame()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            this.m_93228_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
            for (int i = 0; i < this.units; ++i) {
                this.m_93228_(poseStack, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
            }
            this.m_93228_(poseStack, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
            this.m_93228_(poseStack, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
        }
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2), (float)(this.guiTop + 5), this.isIngame() ? 0x404040 : ChatFormatting.WHITE.m_126665_());
        if (!this.deviceList.isEmpty()) {
            this.deviceList.m_6305_(poseStack, mouseX, mouseY, delta);
        } else {
            Component component = this.getEmptyListComponent();
            int n = this.f_96543_ / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            Objects.requireNonNull(this.f_96547_);
            SelectDeviceScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)component, (int)n, (int)(n2 - 9 / 2), (int)-1);
        }
    }
}

