/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import snownee.jade.api.Accessor;

public abstract class AccessorImpl<T extends HitResult>
implements Accessor<T> {
    private final Level level;
    private final Player player;
    private final CompoundTag serverData;
    private final T hit;
    private final boolean serverConnected;
    private final boolean showDetails;

    public AccessorImpl(Level level, Player player, CompoundTag serverData, T hit, boolean serverConnected, boolean showDetails) {
        this.level = level;
        this.player = player;
        this.serverData = serverData;
        this.hit = hit;
        this.serverConnected = serverConnected;
        this.showDetails = showDetails;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public CompoundTag getServerData() {
        return this.serverData == null ? new CompoundTag() : this.serverData;
    }

    @Override
    public T getHitResult() {
        return this.hit;
    }

    @Override
    public boolean isServerConnected() {
        return this.serverConnected;
    }

    @Override
    public boolean showDetails() {
        return this.showDetails;
    }

    @Override
    public abstract ItemStack getPickedResult();
}

