/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.network;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.balm.api.config.Synced;

public class ConfigReflection {
    public static List<Field> getAllFields(Class<?> clazz) {
        return Arrays.stream(clazz.getFields()).filter(it -> !Modifier.isFinal(it.getModifiers())).toList();
    }

    public static List<Field> getSyncedFields(Class<?> clazz) {
        Field[] fields;
        ArrayList<Field> syncedFields = new ArrayList<Field>();
        for (Field field : fields = clazz.getFields()) {
            boolean isObject;
            boolean hasSyncedAnnotation = field.getAnnotation(Synced.class) != null;
            boolean bl = isObject = !field.getType().isPrimitive() && !field.getType().isEnum() && field.getType() != String.class && field.getType() != List.class;
            if (!hasSyncedAnnotation && !isObject) continue;
            syncedFields.add(field);
        }
        return syncedFields;
    }

    public static Object deepCopy(Object from, Object to) {
        Field[] fields;
        for (Field field : fields = from.getClass().getFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            Class<?> type = field.getType();
            try {
                if (String.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type) || type.isPrimitive()) {
                    field.set(to, field.get(from));
                    continue;
                }
                if (List.class.isAssignableFrom(type)) {
                    field.set(to, new ArrayList((Collection)field.get(from)));
                    continue;
                }
                field.set(to, ConfigReflection.deepCopy(field.get(from), field.get(to)));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return to;
    }
}

