/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.client.rendering;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.blay09.mods.balm.common.CachedDynamicModel;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;

public class ForgeBalmModels
implements BalmModels {
    private static ModelBakery bakery;
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();

    @Override
    public DeferredObject<BakedModel> loadModel(final ResourceLocation identifier) {
        DeferredModel deferredModel = new DeferredModel(identifier){

            @Override
            public BakedModel resolve(ModelBakery bakery, Map<ResourceLocation, BakedModel> modelRegistry) {
                UnbakedModel model = bakery.m_119341_(identifier);
                return model.m_7611_(bakery, Material::m_119204_, ForgeBalmModels.this.getModelState(Transformation.m_121093_()), identifier);
            }
        };
        this.getActiveRegistrations().modelsToBake.add(deferredModel);
        return deferredModel;
    }

    @Override
    public DeferredObject<BakedModel> bakeModel(final ResourceLocation identifier, final UnbakedModel model) {
        DeferredModel deferredModel = new DeferredModel(identifier){

            @Override
            public BakedModel resolve(ModelBakery bakery, Map<ResourceLocation, BakedModel> modelRegistry) {
                return model.m_7611_(bakery, Material::m_119204_, ForgeBalmModels.this.getModelState(Transformation.m_121093_()), identifier);
            }
        };
        this.getActiveRegistrations().modelsToBake.add(deferredModel);
        return deferredModel;
    }

    @Override
    public DeferredObject<BakedModel> retexture(final ResourceLocation identifier, final Map<String, String> textureMap) {
        DeferredModel deferredModel = new DeferredModel(identifier){

            @Override
            public BakedModel resolve(ModelBakery bakery, Map<ResourceLocation, BakedModel> modelRegistry) {
                UnbakedModel model = ForgeBalmModels.this.retexture(bakery, identifier, textureMap);
                return model.m_7611_(bakery, Material::m_119204_, ForgeBalmModels.this.getModelState(Transformation.m_121093_()), identifier);
            }
        };
        this.getActiveRegistrations().modelsToBake.add(deferredModel);
        return deferredModel;
    }

    @Override
    public DeferredObject<BakedModel> loadDynamicModel(final ResourceLocation identifier, @Nullable Function<BlockState, ResourceLocation> modelFunction, final @Nullable Function<BlockState, Map<String, String>> textureMapFunction, final @Nullable BiConsumer<BlockState, Matrix4f> transformFunction) {
        final Function<BlockState, ResourceLocation> effectiveModelFunction = modelFunction != null ? modelFunction : it -> identifier;
        DeferredModel deferredModel = new DeferredModel(identifier){

            @Override
            public BakedModel resolve(ModelBakery bakery, Map<ResourceLocation, BakedModel> modelRegistry) {
                return new CachedDynamicModel(bakery, effectiveModelFunction, null, textureMapFunction, transformFunction, identifier);
            }
        };
        this.getActiveRegistrations().modelsToBake.add(deferredModel);
        return deferredModel;
    }

    @Override
    public void overrideModel(Supplier<Block> block, Supplier<BakedModel> model) {
        this.getActiveRegistrations().overrides.add((Pair<Supplier<Block>, Supplier<BakedModel>>)Pair.of(block, model));
    }

    @Override
    public ModelState getModelState(Transformation transformation) {
        return new SimpleModelState(transformation);
    }

    @Override
    public UnbakedModel getUnbakedModelOrMissing(ResourceLocation location) {
        return bakery.m_119341_(location);
    }

    @Override
    public UnbakedModel getUnbakedMissingModel() {
        return bakery.m_119341_((ResourceLocation)ModelBakery.f_119230_);
    }

    public void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.getActiveRegistrations());
    }

    private Registrations getActiveRegistrations() {
        return this.registrations.computeIfAbsent(ModLoadingContext.get().getActiveNamespace(), it -> new Registrations());
    }

    private static class Registrations {
        public final List<DeferredModel> modelsToBake = new ArrayList<DeferredModel>();
        public final List<Pair<Supplier<Block>, Supplier<BakedModel>>> overrides = new ArrayList<Pair<Supplier<Block>, Supplier<BakedModel>>>();

        private Registrations() {
        }

        @SubscribeEvent
        public void onBakeModels(ModelEvent.BakingCompleted event) {
            bakery = event.getModelBakery();
            for (DeferredModel deferredModel : this.modelsToBake) {
                deferredModel.resolveAndSet(event.getModelBakery(), event.getModels());
            }
            for (Pair pair : this.overrides) {
                Block block = (Block)((Supplier)pair.getFirst()).get();
                BakedModel bakedModel = (BakedModel)((Supplier)pair.getSecond()).get();
                block.m_49965_().m_61056_().forEach(state -> {
                    ModelResourceLocation modelLocation = BlockModelShaper.m_110895_((BlockState)state);
                    event.getModels().put(modelLocation, bakedModel);
                });
            }
        }
    }

    private static abstract class DeferredModel
    extends DeferredObject<BakedModel> {
        public DeferredModel(ResourceLocation identifier) {
            super(identifier);
        }

        public void resolveAndSet(ModelBakery modelBakery, Map<ResourceLocation, BakedModel> modelRegistry) {
            this.set(this.resolve(modelBakery, modelRegistry));
        }

        public abstract BakedModel resolve(ModelBakery var1, Map<ResourceLocation, BakedModel> var2);
    }
}

