/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.render.gun.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.guns.client.GunModel;
import com.mrcrayfish.guns.client.SpecialModels;
import com.mrcrayfish.guns.client.render.gun.IOverrideModel;
import com.mrcrayfish.guns.client.util.RenderUtil;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MiniGunModel
implements IOverrideModel {
    private WeakHashMap<LivingEntity, Rotations> rotationMap = new WeakHashMap();

    @Override
    public void tick(Player player) {
        this.rotationMap.putIfAbsent((LivingEntity)player, new Rotations());
        Rotations rotations = this.rotationMap.get(player);
        rotations.prevRotation = rotations.rotation;
        boolean shooting = (Boolean)ModSyncedDataKeys.SHOOTING.getValue((Entity)player);
        ItemStack heldItem = player.m_21205_();
        if (!Gun.hasAmmo(heldItem) && !player.m_7500_()) {
            shooting = false;
        }
        rotations.rotation = shooting ? (rotations.rotation += 20) : ++rotations.rotation;
    }

    @Override
    public void render(float partialTicks, ItemTransforms.TransformType transformType, ItemStack stack, ItemStack parent, @Nullable LivingEntity entity, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, int overlay) {
        Rotations rotations = entity != null ? this.rotationMap.computeIfAbsent(entity, uuid -> new Rotations()) : Rotations.ZERO;
        Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemTransforms.TransformType.NONE, false, poseStack, renderTypeBuffer, light, overlay, GunModel.wrap(SpecialModels.MINI_GUN_BASE.getModel()));
        poseStack.m_85836_();
        RenderUtil.rotateZ(poseStack, 0.0f, -0.375f, (float)rotations.prevRotation + (float)(rotations.rotation - rotations.prevRotation) * partialTicks);
        Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemTransforms.TransformType.NONE, false, poseStack, renderTypeBuffer, light, overlay, GunModel.wrap(SpecialModels.MINI_GUN_BARRELS.getModel()));
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        this.rotationMap.clear();
    }

    private static class Rotations {
        private static final Rotations ZERO = new Rotations();
        private int rotation;
        private int prevRotation;

        private Rotations() {
        }
    }
}

