/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block.InfestationEntries;

import com.github.sculkhorde.common.block.InfestationEntries.BlockInfestationTableEntry;
import com.github.sculkhorde.common.block.InfestationEntries.BlockTagInfestationTableEntry;
import com.github.sculkhorde.common.block.InfestationEntries.IBlockInfestationEntry;
import com.github.sculkhorde.common.block.InfestationEntries.ITagInfestedBlock;
import com.github.sculkhorde.common.block.InfestationEntries.ToolTaglInfestationTableEntry;
import com.github.sculkhorde.common.block.SculkNodeBlock;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockInfestationTable {
    private List<IBlockInfestationEntry> entries = new ArrayList<IBlockInfestationEntry>();

    public void addEntry(Block normalVariant, BlockState infectedVariant) {
        this.entries.add(new BlockInfestationTableEntry(normalVariant, infectedVariant));
    }

    public void addEntry(TagKey<Block> normalTag, ITagInfestedBlock infectedVariant) {
        this.entries.add(new BlockTagInfestationTableEntry(normalTag, infectedVariant));
    }

    public void addEntry(TagKey<Block> toolRequired, Tier tier, ITagInfestedBlock infectedVariant) {
        this.entries.add(new ToolTaglInfestationTableEntry(toolRequired, tier, infectedVariant));
    }

    public BlockState getInfestedVariant(Level level, BlockPos blockPos, BlockState blockState) {
        for (IBlockInfestationEntry entry : this.entries) {
            if (!entry.isNormalVariant(blockState)) continue;
            return entry.getInfectedVariant(level, blockPos, blockState);
        }
        return null;
    }

    public BlockState getNormalVariant(Level level, BlockPos blockPos, BlockState blockState) {
        for (IBlockInfestationEntry entry : this.entries) {
            if (!entry.isInfectedVariant(blockState)) continue;
            return entry.getNormalVariant(level, blockPos, blockState);
        }
        return null;
    }

    public boolean isInfectable(BlockState blockState) {
        if (blockState.m_204336_(ModBlocks.BlockTags.NOT_INFESTABLE)) {
            return false;
        }
        if (blockState.m_204336_(ModBlocks.BlockTags.INFESTED_BLOCK)) {
            return false;
        }
        for (IBlockInfestationEntry entry : this.entries) {
            if (!entry.isNormalVariant(blockState)) continue;
            return true;
        }
        return false;
    }

    public boolean isCurable(BlockState blockState) {
        for (IBlockInfestationEntry entry : this.entries) {
            if (!entry.isInfectedVariant(blockState)) continue;
            return true;
        }
        return false;
    }

    private void removeNearbyVein(ServerLevel world, BlockPos position) {
        ArrayList<BlockPos> adjacentBlockPos = BlockAlgorithms.getAdjacentNeighbors(position);
        for (BlockPos neighbors : adjacentBlockPos) {
            BlockState blockState = world.m_8055_(neighbors);
            if (blockState.m_60734_() != ModBlocks.TENDRILS.get() || blockState.m_60734_().m_7898_(blockState, (LevelReader)world, neighbors)) continue;
            world.m_46961_(neighbors, false);
        }
    }

    private void placeSculkFlora(ServerLevel world, BlockPos position) {
        if (world.f_46441_.m_188503_(4) <= 0) {
            BlockAlgorithms.tryPlaceSculkFlora(position.m_7494_(), world);
        }
    }

    public boolean infectBlock(ServerLevel world, BlockPos targetPos) {
        if (world == null || !this.isInfectable(world.m_8055_(targetPos))) {
            return false;
        }
        BlockState oldBlock = world.m_8055_(targetPos);
        BlockState newBlock = this.getInfestedVariant((Level)world, targetPos, world.m_8055_(targetPos));
        if (newBlock == null) {
            return false;
        }
        world.m_46597_(targetPos, newBlock);
        world.m_8767_((ParticleOptions)ParticleTypes.f_235900_, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 1.15, (double)targetPos.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
        world.m_5594_((Player)null, targetPos, SoundEvents.f_215753_, SoundSource.BLOCKS, 2.0f, 1.6f);
        if (newBlock.m_60734_() instanceof ITagInfestedBlock) {
            ((ITagInfestedBlock)newBlock.m_60734_()).getTagInfestedBlockEntity((Level)world, targetPos).setNormalBlockState(oldBlock);
        }
        this.removeNearbyVein(world, targetPos);
        this.placeSculkFlora(world, targetPos);
        SculkNodeBlock.tryPlaceSculkNode(world, targetPos, false);
        BlockAlgorithms.tryPlaceSculkBeeHive(world, targetPos.m_7494_());
        return true;
    }

    public boolean cureBlock(ServerLevel world, BlockPos targetPos) {
        if (world == null || !this.isCurable(world.m_8055_(targetPos))) {
            return false;
        }
        BlockState targetBlock = world.m_8055_(targetPos);
        BlockState curedVersion = this.getNormalVariant((Level)world, targetPos, targetBlock);
        if (curedVersion == null) {
            return false;
        }
        BlockState victimVariant = curedVersion;
        if (victimVariant != null) {
            world.m_46597_(targetPos, victimVariant);
            return true;
        }
        return false;
    }
}

