/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.blockentity;

import com.github.sculkhorde.common.advancement.SculkHordeStartTrigger;
import com.github.sculkhorde.common.entity.SculkPhantomEntity;
import com.github.sculkhorde.common.entity.SculkSporeSpewerEntity;
import com.github.sculkhorde.common.entity.infection.SculkNodeInfectionHandler;
import com.github.sculkhorde.core.ModBlockEntities;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.ModSavedData;
import com.github.sculkhorde.core.ModSounds;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.AdvancementUtil;
import com.github.sculkhorde.util.ChunkLoading.BlockEntityChunkLoaderHelper;
import com.github.sculkhorde.util.TickUnits;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.slf4j.Logger;

public class SculkAncientNodeBlockEntity
extends BlockEntity
implements VibrationListener.VibrationListenerConfig {
    private long tickedAt = System.nanoTime();
    public static final int tickIntervalSeconds = 5;
    private long heartBeatDelayMillis = TimeUnit.SECONDS.toMillis(5L);
    private long lastHeartBeat = System.currentTimeMillis();
    private SculkNodeInfectionHandler infectionHandler;
    private static final int LISTENER_RADIUS = 24;
    private final PositionSource positionSource = new BlockPositionSource(this.f_58858_);
    private VibrationListener listener = new VibrationListener(this.positionSource, 24, (VibrationListener.VibrationListenerConfig)this, (VibrationListener.ReceivingEvent)null, 0.0f, 0);
    private final Predicate<BlockPos> VALID_SPAWN_BLOCKS = blockPos -> this.isValidSpawnPosition((ServerLevel)this.f_58857_, (BlockPos)blockPos);

    public SculkAncientNodeBlockEntity(BlockPos blockPos2, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SCULK_ANCIENT_NODE_BLOCK_ENTITY.get(), blockPos2, blockState);
    }

    public boolean isValidSpawnPosition(ServerLevel worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_60767_().m_76333_() && worldIn.m_8055_(pos).m_60722_((Fluid)Fluids.f_76193_) && worldIn.m_8055_(pos).m_60722_((Fluid)Fluids.f_76193_) && worldIn.m_8055_(pos.m_7494_()).m_60722_((Fluid)Fluids.f_76193_);
    }

    public static ArrayList<BlockPos> getSpawnPositions(ServerLevel worldIn, BlockPos origin, Predicate<BlockPos> predicateIn, double pDistance) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int i = 0;
        while ((double)i <= pDistance) {
            int j = 0;
            while ((double)j < pDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        BlockPos temp = new BlockPos(origin.m_123341_() + k, origin.m_123342_() + i - 1, origin.m_123343_() + l);
                        if (origin.m_123314_((Vec3i)temp, pDistance) && predicateIn.test(temp)) {
                            list.add(temp);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return list;
    }

    public ArrayList<BlockPos> getSpawnPositionsInCube(ServerLevel worldIn, BlockPos origin, int amountOfPositions) {
        int RADIUS = 20;
        ArrayList<BlockPos> listOfPossibleSpawns = SculkAncientNodeBlockEntity.getSpawnPositions(worldIn, origin, this.VALID_SPAWN_BLOCKS, RADIUS);
        ArrayList<BlockPos> finalList = new ArrayList<BlockPos>();
        Random rng = new Random();
        for (int count = 0; count < amountOfPositions && listOfPossibleSpawns.size() > 0; ++count) {
            int randomIndex = rng.nextInt(listOfPossibleSpawns.size());
            finalList.add(listOfPossibleSpawns.get(randomIndex));
            listOfPossibleSpawns.remove(randomIndex);
        }
        return finalList;
    }

    private void initializeInfectionHandler() {
        if (this.infectionHandler == null) {
            this.infectionHandler = new SculkNodeInfectionHandler(this, this.m_58899_());
        }
    }

    private static void addDarknessEffectToNearbyPlayers(Level level, BlockPos blockPos, int distance) {
        level.m_6907_().forEach(player -> {
            if (player.m_20183_().m_123314_((Vec3i)blockPos, (double)distance) && !player.m_7500_() && !player.m_20147_() && !player.m_5833_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, TickUnits.convertMinutesToTicks(1), 1));
            }
        });
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SculkAncientNodeBlockEntity blockEntity) {
        if (level.m_5776_()) {
            SculkAncientNodeBlockEntity.tickClient(level, blockPos, blockState, blockEntity);
        } else if (SculkHorde.savedData.isHordeUnactivated() && ((Boolean)ModConfig.SERVER.trigger_ancient_node_automatically.get()).booleanValue()) {
            SculkAncientNodeBlockEntity.tickTriggerAutomatically(level, blockPos, blockState, blockEntity);
        } else if (SculkHorde.savedData.isHordeUnactivated() && !((Boolean)ModConfig.SERVER.trigger_ancient_node_automatically.get()).booleanValue()) {
            SculkAncientNodeBlockEntity.tickUnactivated(level, blockPos, blockState, blockEntity);
        } else if (SculkHorde.savedData.isHordeActive()) {
            SculkAncientNodeBlockEntity.tickActive(level, blockPos, blockState, blockEntity);
        }
    }

    public static void tickClient(Level level, BlockPos blockPos, BlockState blockState, SculkAncientNodeBlockEntity blockEntity) {
        if (System.currentTimeMillis() - blockEntity.lastHeartBeat > blockEntity.heartBeatDelayMillis) {
            blockEntity.lastHeartBeat = System.currentTimeMillis();
            level.m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_215762_, SoundSource.BLOCKS, 5.0f, 1.0f, false);
        }
    }

    public static void tickUnactivated(Level level, BlockPos blockPos, BlockState blockState, SculkAncientNodeBlockEntity blockEntity) {
        long timeElapsed = TimeUnit.SECONDS.convert(System.nanoTime() - blockEntity.tickedAt, TimeUnit.NANOSECONDS);
        if (timeElapsed < 5L) {
            return;
        }
        blockEntity.tickedAt = System.nanoTime();
        if (SculkAncientNodeBlockEntity.areAnyPlayersInRange((ServerLevel)level, blockPos, 15)) {
            SculkAncientNodeBlockEntity.tryInitializeHorde(level, blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity);
        }
    }

    public static void tickActive(Level level, BlockPos blockPos, BlockState blockState, SculkAncientNodeBlockEntity blockEntity) {
        long timeElapsed = TimeUnit.SECONDS.convert(System.nanoTime() - blockEntity.tickedAt, TimeUnit.NANOSECONDS);
        if (blockEntity.infectionHandler == null) {
            blockEntity.initializeInfectionHandler();
        }
        if (blockEntity.infectionHandler.canBeActivated()) {
            blockEntity.infectionHandler.activate();
        }
        blockEntity.infectionHandler.tick();
        if (timeElapsed < 5L) {
            return;
        }
        AdvancementUtil.giveAdvancementToAllPlayers((ServerLevel)level, SculkHordeStartTrigger.INSTANCE);
        blockEntity.tickedAt = System.nanoTime();
        SculkAncientNodeBlockEntity.addDarknessEffectToNearbyPlayers(level, blockPos, 25);
        BlockEntityChunkLoaderHelper.getChunkLoaderHelper().createChunkLoadRequestSquare((ServerLevel)level, blockPos, (Integer)ModConfig.SERVER.sculk_node_chunkload_radius.get(), 1, TickUnits.convertMinutesToTicks(30));
    }

    public static void tickTriggerAutomatically(Level level, BlockPos blockPos, BlockState blockState, SculkAncientNodeBlockEntity blockEntity) {
        if (!((Boolean)ModConfig.SERVER.trigger_ancient_node_automatically.get()).booleanValue()) {
            return;
        }
        if (level.m_46468_() < (long)((Integer)ModConfig.SERVER.trigger_ancient_node_wait_days.get() * 24000)) {
            return;
        }
        if (level.m_46468_() % 24000L < (long)((Integer)ModConfig.SERVER.trigger_ancient_node_time_of_day.get()).intValue()) {
            return;
        }
        SculkAncientNodeBlockEntity.tryInitializeHorde(level, blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity);
    }

    private static boolean areAnyPlayersInRange(ServerLevel level, BlockPos blockPos, int range) {
        return level.m_6907_().stream().anyMatch(player -> player.m_20183_().m_123314_((Vec3i)blockPos, (double)range) && !player.m_7500_() && !player.m_5833_() && !player.m_20147_());
    }

    private static void spawnSculkPhantomsAtTopOfWorld(SculkAncientNodeBlockEntity blockEntity, int amount) {
        ServerLevel level = (ServerLevel)blockEntity.f_58857_;
        int spawnRange = 100;
        int minimumSpawnRange = 50;
        Random rng = new Random();
        for (int i = 0; i < amount; ++i) {
            int x = minimumSpawnRange + rng.nextInt(spawnRange) - spawnRange / 2;
            int z = minimumSpawnRange + rng.nextInt(spawnRange) - spawnRange / 2;
            int y = level.m_151558_();
            BlockPos spawnPosition = new BlockPos(blockEntity.m_58899_().m_123341_() + x, y, blockEntity.m_58899_().m_123343_() + z);
            SculkPhantomEntity.spawnPhantom((Level)level, spawnPosition, true);
        }
    }

    public static void announceToAllPlayers(ServerLevel level, Component message) {
        level.m_6907_().forEach(player -> player.m_5661_(message, false));
    }

    public static void tryInitializeHorde(Level level, BlockPos blockPos, BlockState blockState, SculkAncientNodeBlockEntity blockEntity) {
        if (!SculkHorde.savedData.isHordeUnactivated()) {
            return;
        }
        int MAX_SPAWNED_SPORE_SPEWERS = 10;
        if (SculkHorde.savedData.getSculkAccumulatedMass() <= 0) {
            SculkHorde.savedData.addSculkAccumulatedMass(1000);
            SculkHorde.statisticsData.addTotalMassFromNodes(1000);
        }
        SculkHorde.savedData.setHordeState(ModSavedData.HordeState.ACTIVE);
        SculkAncientNodeBlockEntity.announceToAllPlayers((ServerLevel)level, (Component)Component.m_237113_((String)"The Sculk Horde has been awakened!"));
        ArrayList<BlockPos> possibleSpawnPositions = blockEntity.getSpawnPositionsInCube((ServerLevel)level, blockPos, MAX_SPAWNED_SPORE_SPEWERS);
        BlockPos[] finalizedSpawnPositions = new BlockPos[MAX_SPAWNED_SPORE_SPEWERS];
        for (int iterations = 0; iterations < possibleSpawnPositions.size(); ++iterations) {
            finalizedSpawnPositions[iterations] = possibleSpawnPositions.get(iterations);
        }
        if (possibleSpawnPositions.isEmpty()) {
            finalizedSpawnPositions[0] = blockPos.m_7494_();
        }
        for (BlockPos pos : finalizedSpawnPositions) {
            if (pos == null) continue;
            SculkSporeSpewerEntity sporeSpewerEntity = new SculkSporeSpewerEntity(level);
            sporeSpewerEntity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            level.m_7967_((Entity)sporeSpewerEntity);
        }
        level.m_6907_().forEach(player -> level.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.HORDE_START_SOUND.get(), SoundSource.AMBIENT, 1.0f, 1.0f));
        SculkAncientNodeBlockEntity.spawnSculkPhantomsAtTopOfWorld(blockEntity, 10);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("listener", 10)) {
            VibrationListener.m_223781_((VibrationListener.VibrationListenerConfig)this).parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128469_("listener"))).resultOrPartial(arg_0 -> ((Logger)SculkHorde.LOGGER).error(arg_0)).ifPresent(data -> {
                this.listener = data;
            });
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        VibrationListener.m_223781_((VibrationListener.VibrationListenerConfig)this).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.listener).resultOrPartial(arg_0 -> ((Logger)SculkHorde.LOGGER).error(arg_0)).ifPresent(p_222871_ -> nbt.m_128365_("listener", p_222871_));
    }

    public VibrationListener getListener() {
        return this.listener;
    }

    public TagKey<GameEvent> m_213929_() {
        return GameEventTags.f_215854_;
    }

    public boolean m_213641_(ServerLevel level, GameEventListener listener, BlockPos blockPos, GameEvent gameEvent, GameEvent.Context context) {
        return true;
    }

    public void m_213991_(ServerLevel level, GameEventListener listener, BlockPos sourcePosition, GameEvent gameEvent, @Nullable Entity entity, @Nullable Entity entity1, float power) {
        if (SculkAncientNodeBlockEntity.areAnyPlayersInRange(level, this.m_58899_(), 20)) {
            SculkAncientNodeBlockEntity.tryInitializeHorde((Level)level, this.m_58899_(), this.m_58900_(), this);
        }
    }

    public void m_214037_() {
        this.m_6596_();
    }
}

