/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.blockentity;

import com.github.sculkhorde.common.block.SculkNodeBlock;
import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.SculkBeeHarvesterEntity;
import com.github.sculkhorde.common.entity.infection.SculkNodeInfectionHandler;
import com.github.sculkhorde.common.structures.procedural.SculkNodeProceduralStructure;
import com.github.sculkhorde.core.ModBlockEntities;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.ChunkLoading.BlockEntityChunkLoaderHelper;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SculkNodeBlockEntity
extends BlockEntity {
    private long tickedAt = System.nanoTime();
    private SculkNodeProceduralStructure nodeProceduralStructure;
    private final long repairIntervalInMinutes = 60L;
    private long lastTimeSinceRepair = -1L;
    public static final int tickIntervalSeconds = 1;
    private SculkNodeInfectionHandler infectionHandler;
    private final long heartBeatDelayMillis = TimeUnit.SECONDS.toMillis(10L);
    private long lastHeartBeat = System.currentTimeMillis();
    private long lastPopulationUpdate = 0L;
    private final long populationUpdateIntervalMillis = TickUnits.convertMinutesToTicks(3);
    public final int MAX_POPULATION = 100;
    Collection<ISculkSmartEntity> sculkEntitiesBelongingToThisNode = new ArrayList<ISculkSmartEntity>();

    public SculkNodeBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SCULK_NODE_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public boolean isActive() {
        return (Boolean)this.m_58900_().m_61143_((Property)SculkNodeBlock.ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SculkNodeBlock.ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
    }

    public void updateListOfSculkEntitiesBelongingToThisNode() {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_46467_() - this.lastPopulationUpdate < this.populationUpdateIntervalMillis) {
            return;
        }
        this.lastPopulationUpdate = this.f_58857_.m_46467_();
        this.sculkEntitiesBelongingToThisNode.clear();
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        Iterable listOfEntities = serverLevel.m_142646_().m_142273_();
        for (Entity entity : listOfEntities) {
            if (!(entity instanceof LivingEntity) || !EntityAlgorithms.isSculkLivingEntity.test((LivingEntity)entity) || entity instanceof SculkBeeHarvesterEntity) continue;
            BlockPos thisNodePosition = this.m_58899_();
            BlockPos theClosestNodetoEntity = ((ISculkSmartEntity)entity).getClosestNodePosition();
            boolean isClosestNodeThisNode = theClosestNodetoEntity.equals((Object)thisNodePosition);
            if (!isClosestNodeThisNode || !entity.m_6084_()) continue;
            this.sculkEntitiesBelongingToThisNode.add((ISculkSmartEntity)entity);
            if (!SculkHorde.isDebugMode() || !this.isPopulationAtMax()) continue;
            SculkHorde.LOGGER.info("Sculk Node has reached maximum population.");
        }
    }

    public boolean isPopulationAtMax() {
        this.tryCalculateSculkEntityPopulationForThisNode();
        return this.sculkEntitiesBelongingToThisNode.size() > 100;
    }

    public void tryCalculateSculkEntityPopulationForThisNode() {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_46467_() - this.lastPopulationUpdate < this.populationUpdateIntervalMillis) {
            return;
        }
        this.lastPopulationUpdate = this.f_58857_.m_46467_();
        this.updateListOfSculkEntitiesBelongingToThisNode();
    }

    private static void addDarknessEffectToNearbyPlayers(Level level, BlockPos blockPos, int distance) {
        level.m_6907_().forEach(player -> {
            if (player.m_20183_().m_123314_((Vec3i)blockPos, (double)distance) && !player.m_7500_() && !player.m_20147_() && !player.m_5833_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, TickUnits.convertMinutesToTicks(1), 1));
            }
        });
    }

    private void initializeInfectionHandler() {
        if (this.infectionHandler == null) {
            this.infectionHandler = new SculkNodeInfectionHandler(this, this.m_58899_());
            this.infectionHandler.spawnOnSurface = false;
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SculkNodeBlockEntity blockEntity) {
        if (level.f_46443_) {
            if (System.currentTimeMillis() - blockEntity.lastHeartBeat > blockEntity.heartBeatDelayMillis) {
                blockEntity.lastHeartBeat = System.currentTimeMillis();
                level.m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_215762_, SoundSource.BLOCKS, 5.0f, 1.0f, false);
            }
            return;
        }
        if (blockEntity.infectionHandler == null) {
            blockEntity.initializeInfectionHandler();
        }
        if (blockEntity.infectionHandler.canBeActivated() && blockEntity.isActive()) {
            blockEntity.infectionHandler.activate();
        }
        if (!blockEntity.isActive()) {
            blockEntity.infectionHandler.deactivate();
        }
        blockEntity.infectionHandler.tick();
        long timeElapsed = TimeUnit.SECONDS.convert(System.nanoTime() - blockEntity.tickedAt, TimeUnit.NANOSECONDS);
        if (timeElapsed < 1L) {
            return;
        }
        blockEntity.tickedAt = System.nanoTime();
        SculkNodeBlockEntity.addDarknessEffectToNearbyPlayers(level, blockPos, 50);
        if (blockEntity.isActive()) {
            BlockEntityChunkLoaderHelper.getChunkLoaderHelper().createChunkLoadRequestSquare((ServerLevel)level, blockPos, (Integer)ModConfig.SERVER.sculk_node_chunkload_radius.get(), 1, TickUnits.convertMinutesToTicks(30));
        } else {
            BlockEntityChunkLoaderHelper.getChunkLoaderHelper().removeRequestsWithOwner(blockPos, (ServerLevel)level);
        }
        long repairTimeElapsed = TimeUnit.MINUTES.convert(System.nanoTime() - blockEntity.lastTimeSinceRepair, TimeUnit.NANOSECONDS);
        if (blockEntity.nodeProceduralStructure == null) {
            blockEntity.nodeProceduralStructure = new SculkNodeProceduralStructure((ServerLevel)level, blockPos);
            blockEntity.nodeProceduralStructure.generatePlan();
        }
        if (blockEntity.nodeProceduralStructure.isCurrentlyBuilding()) {
            blockEntity.nodeProceduralStructure.buildTick();
            blockEntity.lastTimeSinceRepair = System.nanoTime();
        } else if ((repairTimeElapsed >= blockEntity.repairIntervalInMinutes || blockEntity.lastTimeSinceRepair == -1L) && blockEntity.nodeProceduralStructure.canStartToBuild()) {
            blockEntity.nodeProceduralStructure.startBuildProcedure();
        }
    }
}

