/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.effect;

import com.github.sculkhorde.common.block.SculkMassBlock;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.ModMobEffects;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.MobEffectEvent;

public class SculkInfectionEffect
extends MobEffect {
    public static int spawnInterval = 20;
    public static int liquidColor = 338997;
    public static MobEffectCategory effectType = MobEffectCategory.HARMFUL;
    public long COOLDOWN;
    public long cooldownTicksRemaining;

    protected SculkInfectionEffect(MobEffectCategory effectType, int liquidColor) {
        super(effectType, liquidColor);
        this.cooldownTicksRemaining = this.COOLDOWN = (long)TickUnits.convertSecondsToTicks(1);
    }

    public SculkInfectionEffect() {
        this(effectType, liquidColor);
    }

    public static void onPotionExpire(MobEffectEvent.Expired event) {
        LivingEntity entity = event.getEntity();
        if (entity == null || EntityAlgorithms.isSculkLivingEntity.test(entity) || !entity.f_19853_.m_46739_(entity.m_20183_())) {
            return;
        }
        int infectionDamage = 4;
        Level entityLevel = entity.f_19853_;
        BlockPos entityPosition = entity.m_20183_();
        float entityHealth = entity.m_21233_();
        ((EntityType)ModEntities.SCULK_MITE.get()).m_20600_((ServerLevel)event.getEntity().f_19853_, null, null, null, entityPosition, MobSpawnType.SPAWNER, false, false);
        SculkMassBlock sculkMass = (SculkMassBlock)((Object)ModBlocks.SCULK_MASS.get());
        sculkMass.spawn(entityLevel, entityPosition, entityHealth);
        entity.m_6469_(DamageSource.f_19319_, (float)infectionDamage);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        super.m_6742_(entity, amplifier);
        if (entity.f_19853_.m_5776_()) {
            return;
        }
        if (EntityAlgorithms.isSculkLivingEntity.test(entity)) {
            entity.m_21195_((MobEffect)ModMobEffects.SCULK_INFECTION.get());
        }
    }

    public boolean m_6584_(int ticksLeft, int amplifier) {
        if (this.cooldownTicksRemaining > 0L) {
            --this.cooldownTicksRemaining;
            return false;
        }
        this.cooldownTicksRemaining = this.COOLDOWN;
        return true;
    }

    public List<ItemStack> getCurativeItems() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        return ret;
    }
}

