/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.boss.sculk_enderman;

import com.github.sculkhorde.common.entity.boss.SpecialEffectEntity;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkEndermanEntity;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.List;
import java.util.function.Predicate;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.constant.DefaultAnimations;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EnderBubbleAttackEntity
extends SpecialEffectEntity
implements GeoEntity {
    public static int LIFE_TIME = TickUnits.convertSecondsToTicks(10);
    public int currentLifeTicks = 0;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public EnderBubbleAttackEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public EnderBubbleAttackEntity(Level level) {
        super((EntityType)ModEntities.ENDER_BUBBLE_ATTACK.get(), level);
    }

    public EnderBubbleAttackEntity(EntityType<?> entityType, Level level, LivingEntity sourceEntity) {
        super(entityType, level);
    }

    public EnderBubbleAttackEntity enableDeleteAfterTime(int ticks) {
        LIFE_TIME = ticks;
        return this;
    }

    private void pullInEntities(double range) {
        if (this.f_19853_.m_5776_()) {
            return;
        }
        Predicate<LivingEntity> predicate = entity -> {
            if (entity == null) {
                return false;
            }
            return !(entity instanceof SculkEndermanEntity);
        };
        List<LivingEntity> pullInHitList = EntityAlgorithms.getLivingEntitiesInBoundingBox((ServerLevel)this.f_19853_, this.m_20191_().m_82377_(range, range, range), predicate);
        for (LivingEntity entity2 : pullInHitList) {
            double forceAmount = 0.02;
            double xDirection = this.m_20185_() - entity2.m_20185_();
            double yDirection = this.m_20186_() - entity2.m_20186_();
            double zDirection = this.m_20189_() - entity2.m_20189_();
            entity2.m_5997_(xDirection * forceAmount, yDirection * forceAmount, zDirection * forceAmount);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.currentLifeTicks;
        if (this.currentLifeTicks >= LIFE_TIME && LIFE_TIME != -1) {
            this.m_146870_();
        }
        this.pullInEntities(10.0);
        List<LivingEntity> damageHitList = this.getEntitiesNearbyCube(LivingEntity.class, 3.0);
        for (LivingEntity entity : damageHitList) {
            if (this.getOwner() != null && this.getOwner().equals((Object)entity)) continue;
            if (this.getOwner() != null) {
                entity.m_6469_(DamageSource.m_19367_((Entity)entity, (Entity)this.getOwner()), 5.0f);
                continue;
            }
            entity.m_6469_(DamageSource.m_19367_((Entity)entity, (Entity)this), 5.0f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericIdleController((GeoAnimatable)this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

