/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.boss.sculk_enderman;

import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkEndermanEntity;
import com.github.sculkhorde.util.TickUnits;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.DragonFireball;

public class RainDragonBallAttackGoal
extends Goal {
    private final Mob mob;
    protected int maxAttackDuration = 0;
    protected int elapsedAttackDuration = 0;
    protected final int executionCooldown;
    protected int ticksElapsed = this.executionCooldown = TickUnits.convertMinutesToTicks(8);
    private int attackIntervalTicks = TickUnits.convertSecondsToTicks(2.0f);
    private int attackkIntervalCooldown = 0;

    public RainDragonBallAttackGoal(PathfinderMob mob, int durationInTicks) {
        this.mob = mob;
        this.maxAttackDuration = durationInTicks;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_183429_() {
        return true;
    }

    private SculkEndermanEntity getSculkEnderman() {
        return (SculkEndermanEntity)this.mob;
    }

    public boolean m_8036_() {
        ++this.ticksElapsed;
        if (this.getSculkEnderman().isSpecialAttackOnCooldown() || this.mob.m_5448_() == null) {
            return false;
        }
        if (this.ticksElapsed < this.executionCooldown) {
            return false;
        }
        if (!this.mob.m_19950_((Entity)this.mob.m_5448_(), 10.0) || !this.mob.m_5448_().m_20096_()) {
            return false;
        }
        return !(this.mob.m_21223_() > this.mob.m_21233_() / 2.0f);
    }

    public boolean m_8045_() {
        return this.elapsedAttackDuration < this.maxAttackDuration;
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21573_().m_26573_();
        this.getSculkEnderman().teleportAwayFromEntity((Entity)this.mob.m_5448_());
    }

    public void m_8037_() {
        super.m_8037_();
        ++this.elapsedAttackDuration;
        this.spawnFallingDragonBallInRandomPosition(5);
        this.spawnFallingDragonBallInRandomPosition(5);
        this.spawnFallingDragonBallInRandomPosition(5);
        this.spawnFallingDragonBallInRandomPosition(5);
        this.getSculkEnderman().stayInSpecificRangeOfTarget(32, 40);
    }

    public void m_8041_() {
        super.m_8041_();
        this.getSculkEnderman().resetSpecialAttackCooldown();
        this.elapsedAttackDuration = 0;
        this.ticksElapsed = 0;
        this.getSculkEnderman().canTeleport = true;
    }

    public void spawnFallingDragonBallInRandomPosition(int range) {
        --this.attackkIntervalCooldown;
        if (this.attackkIntervalCooldown > 0) {
            return;
        }
        if (this.mob.m_5448_() == null) {
            return;
        }
        double xSpawn = this.mob.m_5448_().m_20185_() + ((double)this.mob.m_5448_().m_217043_().m_188503_(range) - (double)range / 2.0);
        double ySpawn = this.mob.m_5448_().f_19853_.m_151558_();
        double zSpawn = this.mob.m_5448_().m_20189_() + ((double)this.mob.m_5448_().m_217043_().m_188503_(range) - (double)range / 2.0);
        double xDirection = 0.0;
        double yDirection = -3.0;
        double zDirection = 0.0;
        DragonFireball dragonfireball = new DragonFireball(this.mob.f_19853_, (LivingEntity)this.mob, xDirection, yDirection, zDirection);
        dragonfireball.m_7678_(xSpawn, ySpawn, zSpawn, 0.0f, 0.0f);
        this.mob.f_19853_.m_7967_((Entity)dragonfireball);
        this.attackkIntervalCooldown = this.attackIntervalTicks;
    }
}

