/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.boss.sculk_enderman;

import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkEndermanEntity;
import com.github.sculkhorde.util.TickUnits;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class RangedSonicBoomAttackGoal
extends Goal {
    private final Mob mob;
    protected int maxAttackDuration = 0;
    protected int elapsedAttackDuration = 0;
    protected final int executionCooldown;
    protected int ticksElapsed = this.executionCooldown = TickUnits.convertSecondsToTicks(5);

    public RangedSonicBoomAttackGoal(PathfinderMob mob, int durationInTicks) {
        this.mob = mob;
        this.maxAttackDuration = durationInTicks;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_183429_() {
        return true;
    }

    private SculkEndermanEntity getSculkEnderman() {
        return (SculkEndermanEntity)this.mob;
    }

    public boolean m_8036_() {
        ++this.ticksElapsed;
        if (this.getSculkEnderman().isSpecialAttackOnCooldown() || this.mob.m_5448_() == null) {
            return false;
        }
        return this.ticksElapsed >= this.executionCooldown;
    }

    public boolean m_8045_() {
        return this.elapsedAttackDuration < this.maxAttackDuration;
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21573_().m_26573_();
        this.getSculkEnderman().teleportAwayFromEntity((Entity)this.mob.m_5448_());
        this.getSculkEnderman().stayInSpecificRangeOfTarget(16, 32);
        this.getSculkEnderman().triggerAnim("attack_controller", "fireball_shoot_animation");
        this.mob.m_5496_(SoundEvents.f_215772_, 3.0f, 1.0f);
    }

    public void m_8037_() {
        super.m_8037_();
        ++this.elapsedAttackDuration;
        if (this.elapsedAttackDuration == 10) {
            this.performRangedAttack(this.mob.m_5448_());
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.getSculkEnderman().resetSpecialAttackCooldown();
        this.elapsedAttackDuration = 0;
        this.ticksElapsed = 0;
        this.getSculkEnderman().canTeleport = true;
    }

    public void performRangedAttack(LivingEntity targetEntity) {
        if (targetEntity == null) {
            return;
        }
        this.mob.m_21563_().m_24964_(targetEntity.m_20182_());
        Vec3 vec3 = this.mob.m_146892_();
        Vec3 vec31 = targetEntity.m_146892_().m_82546_(vec3);
        Vec3 vec32 = vec31.m_82541_();
        for (int i = 1; i < Mth.m_14107_((double)vec31.m_82553_()) + 7; ++i) {
            Vec3 vec33 = vec3.m_82549_(vec32.m_82490_((double)i));
            ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_235902_, vec33.f_82479_, vec33.f_82480_, vec33.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
        this.mob.m_5496_(SoundEvents.f_215771_, 3.0f, 1.0f);
        float damage = targetEntity.m_21233_() > 50.0f && (float)targetEntity.m_21230_() > 5.0f ? targetEntity.m_21233_() / 4.0f + 10.0f : 10.0f;
        targetEntity.m_6469_(DamageSource.m_19373_((LivingEntity)this.mob), damage);
        double d1 = 0.5 * (1.0 - targetEntity.m_21133_(Attributes.f_22278_));
        double d0 = 2.5 * (1.0 - targetEntity.m_21133_(Attributes.f_22278_));
        targetEntity.m_5997_(vec32.m_7096_() * d0, vec32.m_7098_() * d1, vec32.m_7094_() * d0);
    }
}

