/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.boss.sculk_enderman;

import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkEndermanEntity;
import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkSpineSpikeAttackEntity;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.phys.Vec3;

public class SculkSpineSpikeRadialAttack
extends MeleeAttackGoal {
    protected int elapsedAttackDuration = 0;
    protected final int executionCooldown;
    protected int ticksElapsed = this.executionCooldown = TickUnits.convertSecondsToTicks(20);
    protected Vec3 origin;
    protected int DELAY_BEFORE_ATTACK;
    protected int delayRemaining = this.DELAY_BEFORE_ATTACK = 30;
    private Predicate<BlockPos> isValidSpawn = pos -> {
        if (this.f_25540_.f_19853_.m_8055_(pos).m_60795_() || this.f_25540_.f_19853_.m_8055_(pos).m_60819_().m_76170_()) {
            return false;
        }
        if (!this.f_25540_.f_19853_.m_8055_(pos.m_7494_()).m_60767_().m_76336_() || this.f_25540_.f_19853_.m_8055_(pos.m_7494_()).m_60819_().m_76170_()) {
            return false;
        }
        return this.f_25540_.f_19853_.m_8055_(pos.m_7494_().m_7494_()).m_60767_().m_76336_() && !this.f_25540_.f_19853_.m_8055_(pos.m_7494_().m_7494_()).m_60819_().m_76170_();
    };

    public SculkSpineSpikeRadialAttack(PathfinderMob mob) {
        super(mob, 0.0, true);
    }

    private SculkEndermanEntity getSculkEnderman() {
        return (SculkEndermanEntity)this.f_25540_;
    }

    public boolean m_8036_() {
        ++this.ticksElapsed;
        if (this.getSculkEnderman().isSpecialAttackOnCooldown() || this.f_25540_.m_5448_() == null) {
            return false;
        }
        if (!this.f_25540_.m_19950_((Entity)this.f_25540_.m_5448_(), 12.0) || !this.f_25540_.m_5448_().m_20096_()) {
            return false;
        }
        return this.ticksElapsed >= this.executionCooldown;
    }

    public boolean m_8045_() {
        return this.elapsedAttackDuration <= 30;
    }

    public void m_8056_() {
        super.m_8056_();
        this.getSculkEnderman().canTeleport = false;
        this.getSculkEnderman().m_21573_().m_26573_();
        this.getSculkEnderman().triggerAnim("attack_controller", "spike_radial_animation");
        this.getSculkEnderman().triggerAnim("twitch_controller", "spike_radial_twitch_animation");
        this.origin = new Vec3(this.f_25540_.m_20185_(), this.f_25540_.m_20186_() + (double)this.f_25540_.m_20192_(), this.f_25540_.m_20189_());
        this.f_25540_.m_21573_().m_26573_();
        this.getSculkEnderman().teleportAwayFromEntity((Entity)this.f_25540_.m_5448_());
    }

    public int getSpawnHeight(BlockPos startPos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_());
        int iterationsMax = 7;
        for (int iterationsElapsed = 0; iterationsElapsed < iterationsMax; ++iterationsElapsed) {
            if (!this.f_25540_.f_19853_.m_8055_((BlockPos)mutablePos).m_60767_().m_76336_()) continue;
            mutablePos.m_122184_(0, -1, 0);
        }
        return mutablePos.m_123342_() + 1;
    }

    public void spawnSpikesOnCircumference(int radius, int amount) {
        Vec3 origin = new Vec3(this.f_25540_.m_20185_(), this.f_25540_.m_20186_() + (double)this.f_25540_.m_20192_(), this.f_25540_.m_20189_());
        ArrayList<SculkSpineSpikeAttackEntity> entities = new ArrayList<SculkSpineSpikeAttackEntity>();
        ArrayList<Vec3> possibleSpawns = BlockAlgorithms.getPointsOnCircumferenceVec3(origin, radius, amount);
        for (int i = 0; i < possibleSpawns.size(); ++i) {
            Vec3 spawnPos = possibleSpawns.get(i);
            SculkSpineSpikeAttackEntity entity = (SculkSpineSpikeAttackEntity)((EntityType)ModEntities.SCULK_SPINE_SPIKE_ATTACK.get()).m_20615_(this.f_25540_.f_19853_);
            assert (entity != null);
            double spawnHeight = this.getSpawnHeight(new BlockPos(spawnPos));
            Vec3 possibleSpawnPosition = new Vec3(spawnPos.m_7096_(), spawnHeight, spawnPos.m_7094_());
            if (this.f_25540_.f_19853_.m_8055_(new BlockPos(possibleSpawnPosition).m_7495_()).m_60767_().m_76336_()) continue;
            entity.m_6034_(possibleSpawnPosition.m_7096_(), possibleSpawnPosition.m_7098_(), possibleSpawnPosition.m_7094_());
            entities.add(entity);
            entity.setOwner((LivingEntity)this.f_25540_);
        }
        for (SculkSpineSpikeAttackEntity entity : entities) {
            this.f_25540_.f_19853_.m_7967_((Entity)entity);
        }
    }

    public void m_8037_() {
        super.m_8037_();
        this.delayRemaining = Math.max(0, this.delayRemaining - 1);
        if (this.delayRemaining != 0) {
            return;
        }
        if (this.elapsedAttackDuration == 0) {
            this.spawnSpikesOnCircumference(1, 8);
        }
        if (this.elapsedAttackDuration == 5) {
            this.spawnSpikesOnCircumference(4, 16);
        } else if (this.elapsedAttackDuration == 10) {
            this.spawnSpikesOnCircumference(5, 10);
        } else if (this.elapsedAttackDuration == 15) {
            this.spawnSpikesOnCircumference(6, 18);
        } else if (this.elapsedAttackDuration == 20) {
            this.spawnSpikesOnCircumference(8, 24);
        } else if (this.elapsedAttackDuration == 25) {
            this.spawnSpikesOnCircumference(10, 40);
        } else if (this.elapsedAttackDuration == 30) {
            this.spawnSpikesOnCircumference(12, 48);
        }
        ++this.elapsedAttackDuration;
    }

    public void m_8041_() {
        super.m_8041_();
        this.getSculkEnderman().resetSpecialAttackCooldown();
        this.elapsedAttackDuration = 0;
        this.ticksElapsed = 0;
        this.getSculkEnderman().canTeleport = true;
        this.delayRemaining = this.DELAY_BEFORE_ATTACK;
    }

    public boolean m_183429_() {
        return true;
    }
}

