/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public abstract class CursorEntity
extends Entity {
    protected State state = State.IDLE;
    protected int MAX_TRANSFORMATIONS = 100;
    protected int currentTransformations = 0;
    protected int MAX_RANGE = 20;
    protected long MAX_LIFETIME_MILLIS = TimeUnit.SECONDS.toMillis(300L);
    protected long creationTickTime = System.currentTimeMillis();
    protected long lastTickTime = 0L;
    protected int searchIterationsPerTick = 20;
    protected long tickIntervalMilliseconds = 1000L;
    protected BlockPos origin = BlockPos.f_121853_;
    protected BlockPos target = BlockPos.f_121853_;
    Queue<BlockPos> queue = new LinkedList<BlockPos>();
    public boolean isSuccessful = false;
    protected HashMap<Long, Boolean> visitedPositons = new HashMap();

    public CursorEntity(Level worldIn) {
        super((EntityType)ModEntities.CURSOR_INFECTOR.get(), worldIn);
    }

    public CursorEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
        this.creationTickTime = System.currentTimeMillis();
    }

    public void setMaxTransformations(int MAX_INFECTIONS) {
        this.MAX_TRANSFORMATIONS = MAX_INFECTIONS;
    }

    public void setMaxRange(int MAX_RANGE) {
        this.MAX_RANGE = MAX_RANGE;
    }

    public void setMaxLifeTimeMillis(long MAX_LIFETIME) {
        this.MAX_LIFETIME_MILLIS = MAX_LIFETIME;
    }

    public void setSearchIterationsPerTick(int iterations) {
        this.searchIterationsPerTick = iterations;
    }

    public void setTickIntervalMilliseconds(long milliseconds) {
        this.tickIntervalMilliseconds = milliseconds;
    }

    public void setState(State state2) {
        this.state = state2;
    }

    protected boolean isObstructed(BlockState state2, BlockPos pos) {
        if (SculkHorde.savedData.getSculkAccumulatedMass() <= 0) {
            return false;
        }
        if (!state2.m_60804_((BlockGetter)this.f_19853_, pos)) {
            return true;
        }
        if (BlockAlgorithms.getBlockDistance(this.origin, pos) > (float)this.MAX_RANGE) {
            return true;
        }
        if (state2.m_60795_()) {
            return true;
        }
        return this.visitedPositons.containsKey(pos.m_121878_());
    }

    protected boolean isTarget(BlockState state2, BlockPos pos) {
        return state2.equals(Blocks.f_50090_.m_49966_());
    }

    protected void transformBlock(BlockPos pos) {
        this.f_19853_.m_46597_(pos, Blocks.f_50090_.m_49966_());
    }

    protected void spawnParticleEffects() {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123767_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.1, 0.0);
    }

    protected boolean searchTick() {
        for (int i = 0; i < Math.max(this.searchIterationsPerTick, 1); ++i) {
            if (this.queue.isEmpty()) {
                this.isSuccessful = false;
                this.target = BlockPos.f_121853_;
                return true;
            }
            BlockPos currentBlock = this.queue.poll();
            if (this.isTarget(this.f_19853_.m_8055_(currentBlock), currentBlock)) {
                this.isSuccessful = true;
                this.target = currentBlock;
                return true;
            }
            ArrayList<BlockPos> possiblePaths = BlockAlgorithms.getNeighborsCube(currentBlock, false);
            Collections.shuffle(possiblePaths);
            for (BlockPos neighbor : possiblePaths) {
                if (this.visitedPositons.containsKey(neighbor.m_121878_()) || this.isObstructed(this.f_19853_.m_8055_(neighbor), neighbor)) continue;
                this.queue.add(neighbor);
                this.visitedPositons.put(neighbor.m_121878_(), true);
            }
        }
        return false;
    }

    public void m_8119_() {
        long currentLifeTimeMilliseconds;
        super.m_8119_();
        float timeElapsedMilliSeconds = System.currentTimeMillis() - this.lastTickTime;
        double tickIntervalMillisecondsAfterMultiplier = (double)this.tickIntervalMilliseconds - (double)this.tickIntervalMilliseconds * (Double)ModConfig.SERVER.infestation_speed_multiplier.get();
        if ((double)timeElapsedMilliSeconds < Math.max(tickIntervalMillisecondsAfterMultiplier, 1.0)) {
            return;
        }
        this.lastTickTime = System.currentTimeMillis();
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.spawnParticleEffects();
            }
            return;
        }
        if (this.origin == BlockPos.f_121853_) {
            this.origin = this.m_20183_();
        }
        if ((currentLifeTimeMilliseconds = System.currentTimeMillis() - this.creationTickTime) >= this.MAX_LIFETIME_MILLIS) {
            this.setState(State.FINISHED);
        } else if (this.currentTransformations >= this.MAX_TRANSFORMATIONS) {
            this.setState(State.FINISHED);
        }
        if (this.state == State.IDLE) {
            this.queue.add(this.m_20183_());
            this.setState(State.SEARCHING);
        } else if (this.state == State.SEARCHING) {
            if (!this.searchTick()) {
                return;
            }
            if (this.target.equals((Object)BlockPos.f_121853_)) {
                this.state = State.FINISHED;
                this.setState(this.state);
            } else {
                this.state = State.EXPLORING;
                this.setState(this.state);
                this.visitedPositons.clear();
            }
        } else if (this.state == State.EXPLORING) {
            ArrayList<BlockPos> neighbors = BlockAlgorithms.getNeighborsCube(this.m_20183_(), false);
            ArrayList<BlockPos> unobstructedNeighbors = new ArrayList<BlockPos>();
            for (BlockPos blockPos : neighbors) {
                if (this.isObstructed(this.f_19853_.m_8055_(blockPos), blockPos)) continue;
                unobstructedNeighbors.add(blockPos);
            }
            if (neighbors.size() == 0) {
                return;
            }
            BlockPos closest = neighbors.get(0);
            for (BlockPos pos : neighbors) {
                if (!(BlockAlgorithms.getBlockDistance(pos, this.target) < BlockAlgorithms.getBlockDistance(closest, this.target))) continue;
                closest = pos;
            }
            this.m_6034_((double)closest.m_123341_() + 0.5, closest.m_123342_(), (double)closest.m_123343_() + 0.5);
            if (this.m_20183_().equals((Object)this.target)) {
                boolean isNotObstructed;
                this.target = BlockPos.f_121853_;
                BlockState blockState = this.f_19853_.m_8055_(this.m_20183_());
                boolean isTarget = this.isTarget(blockState, this.m_20183_());
                boolean bl = isNotObstructed = !this.isObstructed(blockState, this.m_20183_());
                if (isTarget && isNotObstructed) {
                    this.transformBlock(this.m_20183_());
                    ++this.currentTransformations;
                }
                this.setState(State.SEARCHING);
                this.visitedPositons.clear();
                this.queue.clear();
                this.queue.add(this.m_20183_());
            }
            this.visitedPositons.put(closest.m_121878_(), true);
        } else if (this.state == State.FINISHED) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    protected void m_8097_() {
    }

    public void setTarget(BlockPos target) {
        this.target = target;
    }

    protected static enum State {
        IDLE,
        SEARCHING,
        EXPLORING,
        FINISHED;

    }
}

