/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.entity.infection.CursorEntity;
import com.github.sculkhorde.common.entity.infection.CursorInfectorEntity;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.network.NetworkHooks;

public class CursorSurfacePurifierEntity
extends CursorEntity {
    public static Predicate<BlockState> shouldBeRemovedFromAboveBlock = b -> {
        if (b.m_60713_((Block)ModBlocks.GRASS.get())) {
            return true;
        }
        if (b.m_60713_((Block)ModBlocks.GRASS_SHORT.get())) {
            return true;
        }
        if (b.m_60713_((Block)ModBlocks.SMALL_SHROOM.get())) {
            return true;
        }
        if (b.m_60713_((Block)ModBlocks.SCULK_SHROOM_CULTURE.get())) {
            return true;
        }
        if (b.m_60713_((Block)ModBlocks.SPIKE.get())) {
            return true;
        }
        if (b.m_60713_((Block)ModBlocks.SCULK_SUMMONER_BLOCK.get())) {
            return true;
        }
        if (b.m_60713_(Blocks.f_220857_)) {
            return true;
        }
        if (b.m_60713_(Blocks.f_220858_)) {
            return true;
        }
        if (b.m_60713_(Blocks.f_220856_)) {
            return true;
        }
        if (b.m_60713_(Blocks.f_152500_)) {
            return true;
        }
        return b.m_60713_((Block)ModBlocks.TENDRILS.get());
    };

    public CursorSurfacePurifierEntity(Level worldIn) {
        super((EntityType)ModEntities.CURSOR_SURFACE_PURIFIER.get(), worldIn);
    }

    public CursorSurfacePurifierEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    @Override
    protected boolean isTarget(BlockState state2, BlockPos pos) {
        return SculkHorde.blockInfestationTable.isCurable(state2);
    }

    @Override
    protected void transformBlock(BlockPos pos) {
        block2: {
            SculkHorde.blockInfestationTable.cureBlock((ServerLevel)this.f_19853_, pos);
            if (shouldBeRemovedFromAboveBlock.test(this.f_19853_.m_8055_(pos.m_7494_()))) {
                this.f_19853_.m_46597_(pos.m_7494_(), Blocks.f_50016_.m_49966_());
            }
            boolean canCuredBlockSustatinPlant = this.f_19853_.m_8055_(pos).canSustainPlant((BlockGetter)this.f_19853_, pos, Direction.UP, (IPlantable)Blocks.f_50112_);
            Random rand = new Random();
            if (rand.nextBoolean() && canCuredBlockSustatinPlant && this.f_19853_.m_8055_(pos.m_7494_()).m_60795_()) {
                this.f_19853_.m_46597_(pos.m_7494_(), Blocks.f_50034_.m_49966_());
            }
            Predicate<CursorInfectorEntity> isCursor = Objects::nonNull;
            List Infectors = this.f_19853_.m_6443_(CursorInfectorEntity.class, this.m_20191_().m_82400_(5.0), isCursor);
            Iterator iterator = Infectors.iterator();
            if (!iterator.hasNext()) break block2;
            CursorInfectorEntity infector = (CursorInfectorEntity)((Object)iterator.next());
            infector.m_146870_();
            this.m_146870_();
        }
    }

    @Override
    protected void spawnParticleEffects() {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.5), this.m_20187_(), this.m_20262_(1.5), 0.0, 0.0, 0.0);
    }

    @Override
    protected boolean isObstructed(BlockState state2, BlockPos pos) {
        if (!state2.m_60804_((BlockGetter)this.f_19853_, pos)) {
            return true;
        }
        if (BlockAlgorithms.getBlockDistance(this.origin, pos) > (float)this.MAX_RANGE) {
            return true;
        }
        if (state2.m_60795_()) {
            return true;
        }
        if (this.visitedPositons.containsKey(pos.m_121878_())) {
            return true;
        }
        return !BlockAlgorithms.isExposedToAir((ServerLevel)this.f_19853_, pos);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

