/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.entity.infection.CursorProberEntity;
import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.SculkHorde;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class InfectionTree {
    private TreeNode root;
    private boolean Active = false;
    private final Direction direction;
    private CursorProberEntity cursorProbe;
    private CursorSurfaceInfectorEntity cursorInfection;
    private final ServerLevel world;
    private state currentState = state.IDLE;
    private BlockPos potentialNodePosition = null;
    private int failedProbeAttempts = 0;
    private final int MAX_FAILED_PROBE_ATTEMPTS = 2;
    private int currentProbeRange = 10;
    private final int MAX_PROBE_RANGE = 5000;
    private final int MIN_PROBE_RANGE = 10;
    private final int PROBE_RANGE_INCREMENT = 50;
    private final int MAX_INFECTOR_RANGE = 100;
    private final int MIN_INFECTOR_RANGE = 10;
    private final int MAX_INFECTOR_RANGE_INCREMENT = 10;
    private BlockPos infectedTargetPosition = null;
    private int failedInfectionAttempts = 0;
    private final int MAX_FAILED_INFECTION_ATTEMPTS = 10;

    public InfectionTree(ServerLevel world, Direction direction, BlockPos rootPos) {
        this.root = new TreeNode(rootPos);
        this.direction = direction;
        this.world = world;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void activate() {
        this.Active = true;
    }

    public void deactivate() {
        this.Active = false;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode root) {
        this.root = root;
    }

    public void setOrigin(BlockPos origin) {
        this.root.blockPos = origin;
    }

    public void createProbeCursor(int maxDistance) {
        this.cursorProbe = new CursorProberEntity((Level)this.world);
        this.cursorProbe.setMaxRange(maxDistance);
        this.cursorProbe.setPreferedDirection(this.direction);
        this.cursorProbe.m_6034_(this.root.blockPos.m_123341_(), this.root.blockPos.m_123342_(), this.root.blockPos.m_123343_());
        this.cursorProbe.setMaxTransformations(1);
        this.world.m_7967_((Entity)this.cursorProbe);
    }

    public void createInfectionCursor(int maxInfections) {
        this.cursorInfection = new CursorSurfaceInfectorEntity((Level)this.world);
        this.cursorInfection.m_6034_(this.infectedTargetPosition.m_123341_(), this.infectedTargetPosition.m_123342_(), this.infectedTargetPosition.m_123343_());
        this.cursorInfection.setMaxRange(maxInfections);
        this.cursorInfection.setTickIntervalMilliseconds(10L);
        this.world.m_7967_((Entity)this.cursorInfection);
    }

    public void tick() {
        if (this.root.blockPos == BlockPos.f_121853_ || !this.isActive()) {
            return;
        }
        if (SculkHorde.savedData == null) {
            return;
        }
        if (SculkHorde.savedData.getSculkAccumulatedMass() <= 0) {
            return;
        }
        if (this.failedProbeAttempts >= 2) {
            this.currentState = state.COMPLETE;
        }
        if (this.currentProbeRange > 5000) {
            this.currentProbeRange = 10;
        }
        if (this.currentState == state.IDLE) {
            this.currentState = state.PROBING;
        } else if (this.currentState == state.PROBING) {
            if (this.cursorProbe == null) {
                this.createProbeCursor(this.currentProbeRange);
                return;
            }
            if (this.cursorProbe.m_6084_()) {
                return;
            }
            if (this.cursorProbe.currentTransformations > 0) {
                this.potentialNodePosition = this.cursorProbe.m_20183_();
                this.failedProbeAttempts = 0;
                this.cursorProbe = null;
                this.currentState = state.INFECTION;
            } else {
                this.cursorProbe = null;
                ++this.failedProbeAttempts;
                this.potentialNodePosition = BlockPos.f_121853_;
            }
        } else if (this.currentState == state.INFECTION) {
            this.infectedTargetPosition = this.potentialNodePosition;
            if (this.cursorInfection == null) {
                this.createInfectionCursor(100);
                return;
            }
            if (this.cursorInfection.m_6084_()) {
                return;
            }
            if (this.cursorInfection.currentTransformations > 0) {
                this.failedInfectionAttempts = 0;
                this.cursorInfection = null;
            } else {
                ++this.failedInfectionAttempts;
                this.cursorInfection = null;
            }
            if (this.failedInfectionAttempts >= 10) {
                this.failedInfectionAttempts = 0;
                this.currentState = state.PROBING;
            }
        } else if (this.currentState == state.COMPLETE) {
            if (this.failedProbeAttempts >= 2) {
                this.currentProbeRange += 50;
                this.failedProbeAttempts = 0;
                this.currentState = state.IDLE;
            }
            if (this.failedInfectionAttempts >= 10) {
                this.currentState = state.IDLE;
                this.failedInfectionAttempts = 0;
            }
        }
    }

    private static enum state {
        IDLE,
        PROBING,
        INFECTION,
        COMPLETE;

    }

    public class TreeNode {
        private BlockPos blockPos;
        private TreeNode left;
        private TreeNode right;

        public TreeNode(BlockPos blockPos) {
            this.blockPos = blockPos;
        }

        public Object getBlockPos() {
            return this.blockPos;
        }

        public void setBlockPos(BlockPos blockPos) {
            this.blockPos = blockPos;
        }

        public TreeNode getLeft() {
            return this.left;
        }

        public void setLeft(TreeNode left) {
            this.left = left;
        }

        public TreeNode getRight() {
            return this.right;
        }

        public void setRight(TreeNode right) {
            this.right = right;
        }
    }
}

