/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.item;

import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkSpineSpikeAttackEntity;
import com.github.sculkhorde.core.ModCreativeModeTab;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.extensions.IForgeItem;
import org.jetbrains.annotations.NotNull;

public class SculkSweeperSword
extends SwordItem
implements IForgeItem {
    public SculkSweeperSword() {
        this((Tier)Tiers.DIAMOND, 4, -3.0f, new Item.Properties().m_41497_(Rarity.EPIC).setNoRepair().m_41503_(10).m_41491_(ModCreativeModeTab.SCULK_HORDE_TAB));
    }

    public SculkSweeperSword(Tier tier, int baseDamage, float baseAttackSpeed, Item.Properties prop) {
        super(tier, baseDamage, baseAttackSpeed, prop);
    }

    private void doSpikeAttack(LivingEntity ownerEntity, LivingEntity targetEntity, ItemStack itemStack) {
        AABB spikeHitbox = new AABB(targetEntity.m_20183_());
        spikeHitbox = spikeHitbox.m_82400_(20.0);
        for (LivingEntity possibleSpikeTargets : targetEntity.f_19853_.m_45976_(LivingEntity.class, spikeHitbox)) {
            boolean isSculkLivingEntity;
            if (possibleSpikeTargets == ownerEntity || !(isSculkLivingEntity = EntityAlgorithms.isSculkLivingEntity.test(possibleSpikeTargets))) continue;
            SculkSpineSpikeAttackEntity sculkSpineSpikeAttackEntity = new SculkSpineSpikeAttackEntity(ownerEntity, possibleSpikeTargets.m_20185_(), possibleSpikeTargets.m_20186_(), possibleSpikeTargets.m_20189_());
            targetEntity.f_19853_.m_7967_((Entity)sculkSpineSpikeAttackEntity);
            possibleSpikeTargets.m_7292_(new MobEffectInstance(MobEffects.f_19620_, TickUnits.convertSecondsToTicks(5), 1));
        }
        itemStack.m_41721_(itemStack.m_41776_());
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity targetEntity, LivingEntity ownerEntity) {
        boolean isSculkLivingEntity = EntityAlgorithms.isSculkLivingEntity.test(targetEntity);
        if (isSculkLivingEntity) {
            itemStack.m_41721_(Math.max(0, itemStack.m_41773_() - 1));
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_41768_()) {
            this.doSpikeAttack((LivingEntity)player, (LivingEntity)player, itemstack);
            level.m_5594_(player, player.m_20183_(), SoundEvents.f_11865_, player.m_5720_(), 1.0f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        return target.m_20191_().m_82377_(3.0, 0.25, 3.0);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.sculkhorde.sculk_sweeper_sword"));
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 1.0f;
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44962_) {
            return false;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }
}

