/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.structures.procedural;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class Line3D {
    private Vec3 start;
    private Vec3 end;
    private Vec3 direction;

    public Line3D(Vec3 start, Vec3 end) {
        this.start = start;
        this.end = end;
        this.direction = end.m_82546_(start);
    }

    public Line3D(BlockPos start, BlockPos end) {
        this(new Vec3((double)start.m_123341_(), (double)start.m_123342_(), (double)start.m_123343_()), new Vec3((double)end.m_123341_(), (double)end.m_123342_(), (double)end.m_123343_()));
    }

    public double getLength() {
        return this.direction.m_82553_();
    }

    public void iterateOverLine(double stepSize, Consumer<Vec3> consumer) {
        double length = this.getLength();
        for (double offset = 0.0; offset < length; offset += stepSize) {
            Vec3 point = this.start.m_82549_(this.direction.m_82541_().m_82490_(offset));
            consumer.accept(point);
        }
    }

    public ArrayList<BlockPos> getBlockPositionsOnLineWithSphere(double radius) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        this.iterateOverLine(1.0, point -> {
            int x = Mth.m_14107_((double)point.f_82479_);
            int y = Mth.m_14107_((double)point.f_82480_);
            int z = Mth.m_14107_((double)point.f_82481_);
            for (int i = -Mth.m_14107_((double)radius); i <= Mth.m_14107_((double)radius); ++i) {
                for (int j = -Mth.m_14107_((double)radius); j <= Mth.m_14107_((double)radius); ++j) {
                    for (int k = -Mth.m_14107_((double)radius); k <= Mth.m_14107_((double)radius); ++k) {
                        double distanceSq = i * i + j * j + k * k;
                        if (!(distanceSq <= radius * radius)) continue;
                        blockPosList.add(new BlockPos(x + i, y + j, z + k));
                    }
                }
            }
        });
        return blockPosList;
    }
}

