/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.structures.procedural;

import com.github.sculkhorde.common.block.SculkBeeNestCellBlock;
import com.github.sculkhorde.common.structures.procedural.PlannedBlock;
import com.github.sculkhorde.common.structures.procedural.ProceduralStructure;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SculkBeeNestProceduralStructure
extends ProceduralStructure {
    public SculkBeeNestProceduralStructure(ServerLevel worldIn, BlockPos originIn) {
        super(worldIn, originIn);
    }

    @Override
    public void generatePlan() {
        this.plannedBlockQueue.clear();
        for (ProceduralStructure entry : this.childStructuresQueue) {
            entry.generatePlan();
        }
        for (int offset = 1; offset <= 4; ++offset) {
            this.plannedBlockQueue.add(new PlannedBlock(this.world, ((SculkBeeNestCellBlock)((Object)ModBlocks.SCULK_BEE_NEST_CELL_BLOCK.get())).m_49966_(), this.origin.m_6625_(offset)));
        }
        BlockPos branchOrigin = new BlockPos(this.origin.m_123341_(), this.origin.m_123342_() - 2, this.origin.m_123343_());
        this.plannedBlockQueue.addAll(this.generateBranchesPlan(branchOrigin));
    }

    private ArrayList<PlannedBlock> generateBranchesPlan(BlockPos origin) {
        BlockPos branch2Pos;
        BlockPos branch1Pos;
        int offset;
        ArrayList<PlannedBlock> branches = new ArrayList<PlannedBlock>();
        int branchLength = (int)BlockAlgorithms.getSudoRNGFromPosition(origin, 5, 8);
        int chanceToOffsetBranchSideways = 35;
        int branchSidewaysOffset = 0;
        for (offset = 1; offset <= branchLength; ++offset) {
            branch1Pos = new BlockPos(origin.m_123341_() + offset, origin.m_123342_(), origin.m_123343_() + branchSidewaysOffset);
            branch2Pos = new BlockPos(origin.m_123341_() - offset, origin.m_123342_(), origin.m_123343_() - branchSidewaysOffset);
            if (BlockAlgorithms.getSudoRNGFromPosition(branch1Pos, 0, 100) <= (float)chanceToOffsetBranchSideways) {
                ++branchSidewaysOffset;
            }
            branches.add(new SculkNestCellPlannedBlock(this.world, branch1Pos));
            branches.add(new SculkNestCellPlannedBlock(this.world, branch2Pos));
        }
        branchSidewaysOffset = 0;
        branchLength -= 2;
        for (offset = 1; offset <= branchLength; ++offset) {
            branch1Pos = new BlockPos(origin.m_123341_() + branchSidewaysOffset, origin.m_123342_() - 1, origin.m_123343_() + offset);
            branch2Pos = new BlockPos(origin.m_123341_() - branchSidewaysOffset, origin.m_123342_() - 1, origin.m_123343_() - offset);
            if (BlockAlgorithms.getSudoRNGFromPosition(branch1Pos, 0, 100) <= (float)chanceToOffsetBranchSideways) {
                ++branchSidewaysOffset;
            }
            branches.add(new SculkNestCellPlannedBlock(this.world, branch1Pos));
            branches.add(new SculkNestCellPlannedBlock(this.world, branch2Pos));
        }
        return branches;
    }

    public void makeRandomBlockMature() {
        for (PlannedBlock block : this.plannedBlockQueue) {
            if (!block.isPlaced() || (Integer)this.world.m_8055_(block.getPosition()).m_61143_((Property)SculkBeeNestCellBlock.MATURE) != 0) continue;
            ((SculkBeeNestCellBlock)((Object)ModBlocks.SCULK_BEE_NEST_CELL_BLOCK.get())).setMature((Level)this.world, this.world.m_8055_(block.getPosition()), block.getPosition());
            return;
        }
    }

    private class SculkNestCellPlannedBlock
    extends PlannedBlock {
        public SculkNestCellPlannedBlock(ServerLevel worldIn, BlockState plannedBlockIn, BlockPos targetPosIn) {
            super(worldIn, plannedBlockIn, targetPosIn);
        }

        public SculkNestCellPlannedBlock(ServerLevel worldIn, BlockPos targetPosIn) {
            super(worldIn, ((SculkBeeNestCellBlock)((Object)ModBlocks.SCULK_BEE_NEST_CELL_BLOCK.get())).m_49966_(), targetPosIn);
        }

        @Override
        public boolean canBePlaced() {
            return this.VALID_BLOCKS_TO_REPLACE.test(this.world.m_8055_(this.targetPos)) && !BlockAlgorithms.isExposedToAir(this.world, this.targetPos);
        }
    }
}

