/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core;

import com.github.sculkhorde.common.block.SculkBeeNestBlock;
import com.github.sculkhorde.common.blockentity.SculkNodeBlockEntity;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.core.gravemind.RaidData;
import com.github.sculkhorde.core.gravemind.RaidHandler;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.ChunkLoading.BlockEntityChunkLoaderHelper;
import com.github.sculkhorde.util.ChunkLoading.EntityChunkLoaderHelper;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.StatisticsData;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ModSavedData
extends SavedData {
    private static final String debugModeIdentifier = "debugMode";
    public final ServerLevel level;
    HordeState hordeState = HordeState.UNACTIVATED;
    private final ArrayList<NodeEntry> nodeEntries = new ArrayList();
    private final ArrayList<BeeNestEntry> beeNestEntries = new ArrayList();
    private final Map<String, HostileEntry> hostileEntries = new HashMap<String, HostileEntry>();
    private final ArrayList<PriorityBlockEntry> priorityBlockEntries = new ArrayList();
    private final ArrayList<DeathAreaEntry> deathAreaEntries = new ArrayList();
    private final ArrayList<AreaofInterestEntry> areasOfInterestEntries = new ArrayList();
    private final ArrayList<NoRaidZoneEntry> noRaidZoneEntries = new ArrayList();
    private int sculkAccumulatedMass = 0;
    private static final String sculkAccumulatedMassIdentifier = "sculkAccumulatedMass";
    private int noNodeSpawningTicksElapsed = Gravemind.TICKS_BETWEEN_NODE_SPAWNS;
    private static final String ticksSinceSculkNodeDestructionIdentifier = "ticksSinceSculkNodeDestruction";
    private int ticksSinceLastRaid = TickUnits.convertHoursToTicks(8);
    private static final String ticksSinceLastRaidIdentifier = "ticksSinceLastRaid";

    public boolean isHordeUnactivated() {
        return this.hordeState == HordeState.UNACTIVATED;
    }

    public boolean isHordeActive() {
        return this.hordeState == HordeState.ACTIVE;
    }

    public boolean isHordeDefeated() {
        return this.hordeState == HordeState.DEFEATED;
    }

    public HordeState getHordeState() {
        return this.hordeState;
    }

    public void setHordeState(HordeState hordeState) {
        this.hordeState = hordeState;
        this.m_77762_();
    }

    public ModSavedData() {
        this.level = ServerLifecycleHooks.getCurrentServer().m_129783_();
    }

    @NotNull
    private static ModSavedData getGravemindMemory() {
        return SculkHorde.savedData;
    }

    public static ModSavedData load(CompoundTag nbt) {
        CompoundTag gravemindData = nbt.m_128469_("gravemindData");
        SculkHorde.savedData = new ModSavedData();
        SculkHorde.savedData.getNodeEntries().clear();
        SculkHorde.savedData.getBeeNestEntries().clear();
        SculkHorde.savedData.getHostileEntries().clear();
        SculkHorde.savedData.getPriorityBlockEntries().clear();
        SculkHorde.savedData.getDeathAreaEntries().clear();
        SculkHorde.savedData.getAreasOfInterestEntries().clear();
        SculkHorde.savedData.setHordeState(HordeState.values()[nbt.m_128451_("hordeState")]);
        SculkHorde.savedData.setSculkAccumulatedMass(nbt.m_128451_(sculkAccumulatedMassIdentifier));
        SculkHorde.savedData.setNoNodeSpawningTicksElapsed(nbt.m_128451_(ticksSinceSculkNodeDestructionIdentifier));
        SculkHorde.savedData.setTicksSinceLastRaid(nbt.m_128451_(ticksSinceLastRaidIdentifier));
        SculkHorde.setDebugMode(nbt.m_128471_(debugModeIdentifier));
        int i = 0;
        while (gravemindData.m_128441_("node_entry" + i)) {
            SculkHorde.savedData.getNodeEntries().add(NodeEntry.serialize(gravemindData.m_128469_("node_entry" + i)));
            ++i;
        }
        i = 0;
        while (gravemindData.m_128441_("bee_nest_entry" + i)) {
            SculkHorde.savedData.getBeeNestEntries().add(BeeNestEntry.serialize(gravemindData.m_128469_("bee_nest_entry" + i)));
            ++i;
        }
        i = 0;
        while (gravemindData.m_128441_("hostile_entry" + i)) {
            HostileEntry hostileEntry = HostileEntry.serialize(gravemindData.m_128469_("hostile_entry" + i));
            SculkHorde.savedData.getHostileEntries().putIfAbsent(hostileEntry.identifier, hostileEntry);
            ++i;
        }
        i = 0;
        while (gravemindData.m_128441_("priority_block_entry" + i)) {
            SculkHorde.savedData.getPriorityBlockEntries().add(PriorityBlockEntry.serialize(gravemindData.m_128469_("priority_block_entry" + i)));
            ++i;
        }
        i = 0;
        while (gravemindData.m_128441_("death_area_entry" + i)) {
            SculkHorde.savedData.getDeathAreaEntries().add(DeathAreaEntry.serialize(gravemindData.m_128469_("death_area_entry" + i)));
            ++i;
        }
        i = 0;
        while (gravemindData.m_128441_("area_of_interest_entry" + i)) {
            SculkHorde.savedData.getAreasOfInterestEntries().add(AreaofInterestEntry.serialize(gravemindData.m_128469_("area_of_interest_entry" + i)));
            ++i;
        }
        i = 0;
        while (gravemindData.m_128441_("no_raid_zone_entry" + i)) {
            SculkHorde.savedData.getNoRaidZoneEntries().add(NoRaidZoneEntry.serialize(gravemindData.m_128469_("no_raid_zone_entry" + i)));
            ++i;
        }
        if (RaidHandler.raidData == null) {
            RaidHandler.raidData = new RaidData();
        }
        if (SculkHorde.statisticsData == null) {
            SculkHorde.statisticsData = new StatisticsData();
        }
        StatisticsData.load(nbt);
        RaidData.load(nbt);
        BlockEntityChunkLoaderHelper.load(nbt);
        EntityChunkLoaderHelper.load(nbt);
        return ModSavedData.getGravemindMemory();
    }

    public ArrayList<NoRaidZoneEntry> getNoRaidZoneEntries() {
        return this.noRaidZoneEntries;
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag gravemindData = new CompoundTag();
        nbt.m_128405_("hordeState", this.hordeState.ordinal());
        nbt.m_128405_(sculkAccumulatedMassIdentifier, this.sculkAccumulatedMass);
        nbt.m_128405_(ticksSinceSculkNodeDestructionIdentifier, this.noNodeSpawningTicksElapsed);
        nbt.m_128405_(ticksSinceLastRaidIdentifier, this.ticksSinceLastRaid);
        nbt.m_128379_(debugModeIdentifier, SculkHorde.isDebugMode());
        ListIterator<Object> iterator = this.getNodeEntries().listIterator();
        while (iterator.hasNext()) {
            gravemindData.m_128365_("node_entry" + iterator.nextIndex(), (Tag)((NodeEntry)iterator.next()).deserialize());
        }
        iterator = this.getBeeNestEntries().listIterator();
        while (iterator.hasNext()) {
            gravemindData.m_128365_("bee_nest_entry" + iterator.nextIndex(), (Tag)((BeeNestEntry)iterator.next()).deserialize());
        }
        int hostileIndex = 0;
        for (Map.Entry<String, HostileEntry> entry : this.getHostileEntries().entrySet()) {
            gravemindData.m_128365_("hostile_entry" + hostileIndex, (Tag)entry.getValue().deserialize());
            ++hostileIndex;
        }
        ListIterator<Object> iterator2 = this.getPriorityBlockEntries().listIterator();
        while (iterator2.hasNext()) {
            gravemindData.m_128365_("priority_block_entry" + iterator2.nextIndex(), (Tag)((PriorityBlockEntry)iterator2.next()).deserialize());
        }
        iterator2 = this.getDeathAreaEntries().listIterator();
        while (iterator2.hasNext()) {
            gravemindData.m_128365_("death_area_entry" + iterator2.nextIndex(), (Tag)((DeathAreaEntry)iterator2.next()).deserialize());
        }
        iterator2 = this.getAreasOfInterestEntries().listIterator();
        while (iterator2.hasNext()) {
            gravemindData.m_128365_("area_of_interest_entry" + iterator2.nextIndex(), (Tag)((AreaofInterestEntry)iterator2.next()).deserialize());
        }
        iterator2 = this.getNoRaidZoneEntries().listIterator();
        while (iterator2.hasNext()) {
            gravemindData.m_128365_("no_raid_zone_entry" + iterator2.nextIndex(), (Tag)((NoRaidZoneEntry)iterator2.next()).deserialize());
        }
        nbt.m_128365_("gravemindData", (Tag)gravemindData);
        RaidData.save(nbt);
        StatisticsData.save(nbt);
        BlockEntityChunkLoaderHelper.save(nbt);
        EntityChunkLoaderHelper.save(nbt);
        return nbt;
    }

    public boolean isRaidCooldownOver() {
        return this.getTicksSinceLastRaid() >= TickUnits.convertMinutesToTicks((Integer)ModConfig.SERVER.sculk_raid_global_cooldown_between_raids_minutes.get());
    }

    public int getTicksSinceLastRaid() {
        this.m_77762_();
        return this.ticksSinceLastRaid;
    }

    public void setTicksSinceLastRaid(int ticksSinceLastRaid) {
        this.ticksSinceLastRaid = ticksSinceLastRaid;
        this.m_77762_();
    }

    public void incrementTicksSinceLastRaid() {
        ++this.ticksSinceLastRaid;
        this.m_77762_();
    }

    public boolean isNodeSpawnCooldownOver() {
        long ticksNeeded;
        long ticksElapsed = this.getTicksElapsedForNodeSpawningCooldown();
        boolean result = ticksElapsed >= (ticksNeeded = (long)Gravemind.TICKS_BETWEEN_NODE_SPAWNS);
        return result;
    }

    public int getTicksElapsedForNodeSpawningCooldown() {
        this.m_77762_();
        return this.noNodeSpawningTicksElapsed;
    }

    public void setNoNodeSpawningTicksElapsed(int noNodeSpawningTicksElapsed) {
        this.noNodeSpawningTicksElapsed = noNodeSpawningTicksElapsed;
        this.m_77762_();
    }

    public void incrementNoNodeSpawningTicksElapsed() {
        ++this.noNodeSpawningTicksElapsed;
        this.m_77762_();
    }

    public void resetNoNodeSpawningTicksElapsed() {
        this.noNodeSpawningTicksElapsed = 0;
        this.m_77762_();
    }

    public int getSculkAccumulatedMass() {
        this.m_77762_();
        return this.sculkAccumulatedMass;
    }

    public int addSculkAccumulatedMass(int amount) {
        this.m_77762_();
        this.sculkAccumulatedMass += amount;
        return this.sculkAccumulatedMass;
    }

    public int subtractSculkAccumulatedMass(int amount) {
        this.m_77762_();
        this.sculkAccumulatedMass -= amount;
        return this.sculkAccumulatedMass;
    }

    public int setSculkAccumulatedMass(int amount) {
        this.m_77762_();
        this.sculkAccumulatedMass = amount;
        return this.sculkAccumulatedMass;
    }

    public ArrayList<NodeEntry> getNodeEntries() {
        return this.nodeEntries;
    }

    public ArrayList<BeeNestEntry> getBeeNestEntries() {
        return this.beeNestEntries;
    }

    public Map<String, HostileEntry> getHostileEntries() {
        return this.hostileEntries;
    }

    public ArrayList<PriorityBlockEntry> getPriorityBlockEntries() {
        return this.priorityBlockEntries;
    }

    public ArrayList<DeathAreaEntry> getDeathAreaEntries() {
        return this.deathAreaEntries;
    }

    public ArrayList<AreaofInterestEntry> getAreasOfInterestEntries() {
        return this.areasOfInterestEntries;
    }

    public void addNodeToMemory(ServerLevel level, BlockPos positionIn) {
        if (!this.isNodePositionInMemory(positionIn) && this.getNodeEntries() != null) {
            this.getNodeEntries().add(new NodeEntry(level, positionIn));
            this.m_77762_();
        }
    }

    public void addBeeNestToMemory(ServerLevel level, BlockPos positionIn) {
        if (!this.isBeeNestPositionInMemory(positionIn) && this.getBeeNestEntries() != null) {
            this.getBeeNestEntries().add(new BeeNestEntry(level, positionIn));
            this.m_77762_();
        }
    }

    public void addHostileToMemory(LivingEntity entityIn) {
        if (entityIn == null || EntityAlgorithms.isSculkLivingEntity.test(entityIn) || entityIn instanceof Creeper) {
            return;
        }
        String identifier = entityIn.m_6095_().toString();
        if (!identifier.isEmpty()) {
            this.getHostileEntries().putIfAbsent(identifier, new HostileEntry(identifier));
            this.m_77762_();
        }
    }

    public void addPriorityBlockToMemory(BlockPos positionIn) {
        int priority;
        if (this.getPriorityBlockEntries() == null) {
            return;
        }
        for (PriorityBlockEntry entry : this.getPriorityBlockEntries()) {
            if (entry.position != positionIn) continue;
            return;
        }
        if (this.level.m_8055_(positionIn).m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_HIGH_PRIORITY)) {
            priority = 2;
        } else if (this.level.m_8055_(positionIn).m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_MEDIUM_PRIORITY)) {
            priority = 1;
        } else if (this.level.m_8055_(positionIn).m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_LOW_PRIORITY)) {
            priority = 0;
        } else {
            SculkHorde.LOGGER.warn("Attempted to add a block to the priority list that was not a priority block");
            return;
        }
        this.getPriorityBlockEntries().add(new PriorityBlockEntry(positionIn, priority));
        this.m_77762_();
    }

    public void addDeathAreaToMemory(ServerLevel dimension, BlockPos positionIn) {
        if (this.getDeathAreaEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to add a death area to memory but the list was null");
            return;
        }
        for (int i = 0; i < this.getDeathAreaEntries().size(); ++i) {
            if (this.getDeathAreaEntries().get((int)i).position != positionIn) continue;
            return;
        }
        SculkHorde.LOGGER.info("Adding Death Area in " + dimension.m_46472_() + " at " + positionIn + " to memory");
        this.getDeathAreaEntries().add(new DeathAreaEntry(dimension, positionIn));
        this.m_77762_();
    }

    public Optional<AreaofInterestEntry> addAreaOfInterestToMemory(ServerLevel dimension, BlockPos positionIn) {
        if (this.getAreasOfInterestEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to add an area of interest to memory but the list was null");
            return Optional.empty();
        }
        for (int i = 0; i < this.getAreasOfInterestEntries().size(); ++i) {
            if (this.getAreasOfInterestEntries().get((int)i).position != positionIn && !this.getAreasOfInterestEntries().get((int)i).position.m_123314_((Vec3i)positionIn, 100.0)) continue;
            return Optional.empty();
        }
        SculkHorde.LOGGER.info("Adding Area of Interest at " + dimension.m_46472_() + " at " + positionIn + " to memory");
        AreaofInterestEntry entry = new AreaofInterestEntry(dimension, positionIn);
        this.getAreasOfInterestEntries().add(entry);
        this.m_77762_();
        return Optional.of(entry);
    }

    public void addNoRaidZoneToMemory(ServerLevel dimension, BlockPos positionIn) {
        if (this.getNoRaidZoneEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to add a no raid zone to memory but the list was null");
            return;
        }
        for (int i = 0; i < this.getNoRaidZoneEntries().size(); ++i) {
            boolean areInSameDimension = BlockAlgorithms.areTheseDimensionsEqual(this.getNoRaidZoneEntries().get((int)i).dimension, (ResourceKey<Level>)dimension.m_46472_());
            boolean arePositionsEqual = this.getNoRaidZoneEntries().get((int)i).position.equals((Object)positionIn);
            boolean isCloserThan100BlocksFromPosition = this.getNoRaidZoneEntries().get((int)i).position.m_123314_((Vec3i)positionIn, 100.0);
            if ((!areInSameDimension || !arePositionsEqual) && (!areInSameDimension || !isCloserThan100BlocksFromPosition)) continue;
            if (isCloserThan100BlocksFromPosition) {
                SculkHorde.LOGGER.debug("Attempted to add a no raid zone to memory but it was too close to another no raid zone");
            } else if (arePositionsEqual) {
                SculkHorde.LOGGER.debug("Attempted to add a no raid zone to memory but it already existed");
            }
            return;
        }
        SculkHorde.LOGGER.info("Adding No Raid Zone at " + positionIn + " in " + dimension.m_46472_() + " to memory");
        this.getNoRaidZoneEntries().add(new NoRaidZoneEntry(dimension, positionIn, 1000, this.level.m_46467_(), (long)TickUnits.convertMinutesToTicks((Integer)ModConfig.SERVER.sculk_raid_no_raid_zone_duration_minutes.get())));
        this.m_77762_();
    }

    private Optional<DeathAreaEntry> getDeathAreaWithinRange(BlockPos positionIn, int range) {
        if (this.getDeathAreaEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to get a death area from memory but the list was null");
            return Optional.empty();
        }
        for (int i = 0; i < this.getDeathAreaEntries().size(); ++i) {
            if (!this.getDeathAreaEntries().get((int)i).position.m_123314_((Vec3i)positionIn, (double)range)) continue;
            return Optional.of(this.getDeathAreaEntries().get(i));
        }
        return Optional.empty();
    }

    public Optional<DeathAreaEntry> getDeathAreaWithHighestDeaths() {
        if (this.getDeathAreaEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to get a death area from memory but the list was null");
            return Optional.empty();
        }
        int highestDeathCount = 0;
        DeathAreaEntry highestDeathArea = null;
        for (int i = 0; i < this.getDeathAreaEntries().size(); ++i) {
            if (this.getDeathAreaEntries().get((int)i).deathCount <= highestDeathCount) continue;
            highestDeathCount = this.getDeathAreaEntries().get((int)i).deathCount;
            highestDeathArea = this.getDeathAreaEntries().get(i);
        }
        if (highestDeathArea == null) {
            return Optional.empty();
        }
        return Optional.of(highestDeathArea);
    }

    public Optional<AreaofInterestEntry> getAreaOfInterestEntryNotInNoRaidZone() {
        if (this.getAreasOfInterestEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to get an area of interest from memory but the list was null");
            return null;
        }
        for (int i = 0; i < this.getAreasOfInterestEntries().size(); ++i) {
            if (this.getAreasOfInterestEntries().get(i).isInNoRaidZone()) continue;
            return Optional.of(this.getAreasOfInterestEntries().get(i));
        }
        return Optional.empty();
    }

    public void validateNodeEntries() {
        long startTime = System.nanoTime();
        for (int index = 0; index < this.nodeEntries.size(); ++index) {
            if (this.getNodeEntries().get(index).isEntryValid()) continue;
            this.resetNoNodeSpawningTicksElapsed();
            this.getNodeEntries().remove(index);
            --index;
            this.m_77762_();
        }
        long endTime = System.nanoTime();
        if (SculkHorde.isDebugMode()) {
            System.out.println("Node Validation Took " + TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS) + " milliseconds");
        }
    }

    public void validateBeeNestEntries() {
        long startTime = System.nanoTime();
        for (int index = 0; index < this.getBeeNestEntries().size(); ++index) {
            this.getBeeNestEntries().get(index).setParentNodeToClosest();
            if (this.getBeeNestEntries().get(index).isEntryValid()) continue;
            this.getBeeNestEntries().remove(index);
            --index;
            this.m_77762_();
        }
        long endTime = System.nanoTime();
        if (SculkHorde.isDebugMode()) {
            System.out.println("Bee Nest Validation Took " + TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS) + " milliseconds");
        }
    }

    public void validateAreasOfInterest() {
        long startTime = System.currentTimeMillis();
        for (int index = 0; index < this.getAreasOfInterestEntries().size(); ++index) {
            if (this.getAreasOfInterestEntries().get(index).isInNoRaidZone()) continue;
            SculkHorde.LOGGER.info("Area of Interest at " + this.getAreasOfInterestEntries().get((int)index).position + " is on no raid zone. Removing from memory.");
            this.getAreasOfInterestEntries().remove(index);
            --index;
            this.m_77762_();
        }
        long endTime = System.currentTimeMillis();
        if (SculkHorde.isDebugMode()) {
            SculkHorde.LOGGER.info("Area Of Interest Validation Took " + (endTime - startTime) + " milliseconds");
        }
    }

    public void validateNoRaidZoneEntries() {
        long startTime = System.currentTimeMillis();
        for (int index = 0; index < this.getNoRaidZoneEntries().size(); ++index) {
            if (!this.getNoRaidZoneEntries().get(index).isExpired(this.level.m_46467_())) continue;
            SculkHorde.LOGGER.info("No Raid Zone Entry at " + this.getNoRaidZoneEntries().get((int)index).position + " has expired. Removing from memory.");
            this.getNoRaidZoneEntries().remove(index);
            --index;
            this.m_77762_();
        }
        long endTime = System.currentTimeMillis();
        if (SculkHorde.isDebugMode()) {
            SculkHorde.LOGGER.info("No Raid Zone Validation Took " + (endTime - startTime) + " milliseconds");
        }
    }

    public boolean isBeeNestPositionInMemory(BlockPos position) {
        for (BeeNestEntry entry : this.getBeeNestEntries()) {
            if (entry.position != position) continue;
            return true;
        }
        return false;
    }

    public boolean isNodePositionInMemory(BlockPos position) {
        for (NodeEntry entry : this.getNodeEntries()) {
            if (!entry.position.equals((Object)position)) continue;
            return true;
        }
        return false;
    }

    public NodeEntry getClosestNodeEntry(ServerLevel dimension, BlockPos pos) {
        NodeEntry closestNode = null;
        double closestDistance = Double.MAX_VALUE;
        for (NodeEntry node : this.getNodeEntries()) {
            if (!(pos.m_123331_((Vec3i)node.position) < closestDistance)) continue;
            closestNode = node;
            closestDistance = pos.m_123331_((Vec3i)node.position);
        }
        return closestNode;
    }

    public void removeNodeFromMemory(BlockPos positionIn) {
        if (this.getNodeEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to remove an area of interest from memory but the list was null");
            return;
        }
        for (int i = 0; i < this.getNodeEntries().size(); ++i) {
            if (!this.getNodeEntries().get((int)i).position.equals((Object)positionIn)) continue;
            this.getNodeEntries().remove(i);
            this.m_77762_();
            this.resetNoNodeSpawningTicksElapsed();
            return;
        }
        this.m_77762_();
    }

    public void removeDeathAreaFromMemory(BlockPos positionIn) {
        if (this.getDeathAreaEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to remove a death area from memory but the list was null");
            return;
        }
        for (int i = 0; i < this.getDeathAreaEntries().size(); ++i) {
            if (this.getDeathAreaEntries().get((int)i).position != positionIn) continue;
            this.getDeathAreaEntries().remove(i);
            this.m_77762_();
            return;
        }
        this.m_77762_();
    }

    public void removeAreaOfInterestFromMemory(BlockPos positionIn) {
        if (this.getAreasOfInterestEntries() == null) {
            SculkHorde.LOGGER.warn("Attempted to remove an area of interest from memory but the list was null");
            return;
        }
        for (int i = 0; i < this.getAreasOfInterestEntries().size(); ++i) {
            if (this.getAreasOfInterestEntries().get((int)i).position != positionIn) continue;
            this.getAreasOfInterestEntries().remove(i);
            this.m_77762_();
            return;
        }
        this.m_77762_();
    }

    public void reportDeath(ServerLevel level, BlockPos deathPosition) {
        Optional<DeathAreaEntry> deathArea = this.getDeathAreaWithinRange(deathPosition, 100);
        if (deathArea.isPresent()) {
            deathArea.get().iterateDeathCount();
            this.m_77762_();
            return;
        }
        this.addDeathAreaToMemory(level, deathPosition);
    }

    public static enum HordeState {
        UNACTIVATED,
        ACTIVE,
        DEFEATED;

    }

    public static class NodeEntry {
        private final BlockPos position;
        private long lastTimeWasActive;
        private long activationTimeStamp;
        private boolean IsActive;
        private ResourceKey<Level> dimension;

        public NodeEntry(ServerLevel level, BlockPos positionIn) {
            this.position = positionIn;
            this.lastTimeWasActive = SculkHorde.savedData.level.m_46467_();
            this.dimension = level.m_46472_();
        }

        public NodeEntry(ResourceKey<Level> dimensionResource, BlockPos positionIn) {
            this.position = positionIn;
            this.lastTimeWasActive = SculkHorde.savedData.level.m_46467_();
            this.dimension = dimensionResource;
        }

        public ServerLevel getDimension() {
            return SculkHorde.savedData.level.m_7654_().m_129880_(this.dimension);
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public boolean isActive() {
            return this.IsActive;
        }

        public void setActive(boolean activeIn) {
            if (this.getDimension() == null) {
                SculkHorde.LOGGER.error("Failed To Set Node Active. Dimension was null.");
                return;
            }
            if (this.getDimension().m_7702_(this.position) == null) {
                SculkHorde.LOGGER.error("Failed To Set Node Active. Block Entity was null.");
                return;
            }
            if (!(this.getDimension().m_7702_(this.position) instanceof SculkNodeBlockEntity)) {
                SculkHorde.LOGGER.error("Failed To Set Node Active. Block Entity was not instance of Sculk Node Block Entity.");
                return;
            }
            this.IsActive = activeIn;
            SculkNodeBlockEntity sculkNodeBlockEntity = (SculkNodeBlockEntity)this.getDimension().m_7702_(this.position);
            sculkNodeBlockEntity.setActive(activeIn);
        }

        public long getLastTimeWasActive() {
            return this.lastTimeWasActive;
        }

        public void setLastTimeWasActive(long lastTimeWasActiveIn) {
            this.lastTimeWasActive = lastTimeWasActiveIn;
        }

        public void setActivationTimeStamp(long activationTimeStampIn) {
            this.activationTimeStamp = activationTimeStampIn;
        }

        public long getActivationTimeStamp() {
            return this.activationTimeStamp;
        }

        public boolean isEntryValid() {
            if (this.getDimension() == null) {
                return false;
            }
            return this.getDimension().m_8055_(this.position).m_60734_().equals(ModBlocks.SCULK_NODE_BLOCK.get());
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("position", this.position.m_121878_());
            nbt.m_128356_("lastTimeWasActive", this.lastTimeWasActive);
            nbt.m_128356_("activationTimeStamp", this.activationTimeStamp);
            nbt.m_128379_("IsActive", this.IsActive);
            nbt.m_128359_("dimension", this.dimension.m_135782_().toString());
            return nbt;
        }

        public static NodeEntry serialize(CompoundTag nbt) {
            ResourceKey dimensionResourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dimension")));
            NodeEntry entry = new NodeEntry((ResourceKey<Level>)dimensionResourceKey, BlockPos.m_122022_((long)nbt.m_128454_("position")));
            entry.setLastTimeWasActive(nbt.m_128454_("lastTimeWasActive"));
            entry.setActivationTimeStamp(nbt.m_128454_("activationTimeStamp"));
            entry.setActive(nbt.m_128471_("IsActive"));
            return entry;
        }
    }

    public static class BeeNestEntry {
        private final BlockPos position;
        private BlockPos parentNodePosition;
        private ResourceKey<Level> dimension;

        public BeeNestEntry(ServerLevel dimension, BlockPos positionIn) {
            this.dimension = dimension.m_46472_();
            this.position = positionIn;
        }

        public BeeNestEntry(ServerLevel dimension, BlockPos positionIn, BlockPos parentPositionIn) {
            this.position = positionIn;
            this.parentNodePosition = parentPositionIn;
            this.dimension = dimension.m_46472_();
        }

        public BeeNestEntry(ResourceKey<Level> dimension, BlockPos positionIn, BlockPos parentPositionIn) {
            this.position = positionIn;
            this.parentNodePosition = parentPositionIn;
            this.dimension = dimension;
        }

        public ServerLevel getDimension() {
            return SculkHorde.savedData.level.m_7654_().m_129880_(this.dimension);
        }

        public boolean isEntryValid() {
            ServerLevel dimension = this.getDimension();
            if (dimension == null) {
                SculkHorde.LOGGER.error("Failed To Validate Bee Nest Entry. Dimension was null.");
                return false;
            }
            if (dimension.m_7702_(this.position) == null) {
                SculkHorde.LOGGER.error("Failed To Validate Bee Nest Entry. Block Entity was null.");
                return false;
            }
            return dimension.m_8055_(this.position).m_60734_().equals(ModBlocks.SCULK_BEE_NEST_BLOCK.get());
        }

        public boolean isOccupantsExistingDisabled() {
            if (this.getDimension() == null) {
                return true;
            }
            return SculkBeeNestBlock.isNestClosed(this.getDimension().m_8055_(this.position));
        }

        public void disableOccupantsExiting() {
            if (this.getDimension() == null) {
                return;
            }
            SculkBeeNestBlock.setNestClosed(this.getDimension(), this.getDimension().m_8055_(this.position), this.position);
        }

        public void enableOccupantsExiting() {
            if (this.getDimension() == null) {
                return;
            }
            SculkBeeNestBlock.setNestOpen(this.getDimension(), this.getDimension().m_8055_(this.position), this.position);
        }

        public Optional<NodeEntry> getClosestNode(BlockPos pos) {
            Optional<NodeEntry> closestEntry = Optional.empty();
            for (NodeEntry entry : ModSavedData.getGravemindMemory().getNodeEntries()) {
                if (!entry.dimension.equals(this.dimension)) continue;
                if (closestEntry.isEmpty()) {
                    closestEntry = Optional.of(entry);
                    continue;
                }
                if (!(BlockAlgorithms.getBlockDistance(pos, entry.position) < BlockAlgorithms.getBlockDistance(pos, closestEntry.get().position))) continue;
                closestEntry = Optional.of(entry);
            }
            return closestEntry;
        }

        public void setParentNodeToClosest() {
            if (ModSavedData.getGravemindMemory().getNodeEntries() != null && !ModSavedData.getGravemindMemory().getNodeEntries().isEmpty()) {
                Optional<Object> closestEntry = Optional.empty();
                for (NodeEntry entry : ModSavedData.getGravemindMemory().getNodeEntries()) {
                    if (!entry.dimension.equals(this.dimension)) continue;
                    if (Optional.of(entry).isEmpty()) {
                        SculkHorde.LOGGER.error("Failed To Set Parent Node To Closest. Node Entry was null.");
                        continue;
                    }
                    if (closestEntry.isEmpty()) {
                        closestEntry = Optional.of(entry);
                        continue;
                    }
                    if (!closestEntry.isPresent() || !(BlockAlgorithms.getBlockDistance(this.position, entry.position) < BlockAlgorithms.getBlockDistance(this.position, ((NodeEntry)closestEntry.get()).position))) continue;
                    closestEntry = Optional.of(entry);
                }
                if (closestEntry.isPresent() && ((NodeEntry)closestEntry.get()).getPosition() != null) {
                    this.parentNodePosition = ((NodeEntry)closestEntry.get()).getPosition();
                }
            }
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("position", this.position.m_121878_());
            if (this.dimension != null) {
                nbt.m_128359_("dimension", this.dimension.m_135782_().toString());
            }
            if (this.parentNodePosition != null) {
                nbt.m_128356_("parentNodePosition", this.parentNodePosition.m_121878_());
            }
            return nbt;
        }

        public static BeeNestEntry serialize(CompoundTag nbt) {
            ResourceKey dimensionResourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dimension")));
            return new BeeNestEntry((ResourceKey<Level>)dimensionResourceKey, BlockPos.m_122022_((long)nbt.m_128454_("position")), BlockPos.m_122022_((long)nbt.m_128454_("parentNodePosition")));
        }
    }

    private static class HostileEntry {
        private final String identifier;

        public HostileEntry(String identifierIn) {
            this.identifier = identifierIn;
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("identifier", this.identifier);
            return nbt;
        }

        public static HostileEntry serialize(CompoundTag nbt) {
            return new HostileEntry(nbt.m_128461_("identifier"));
        }
    }

    public static class PriorityBlockEntry {
        private final BlockPos position;
        private final int priority;

        public PriorityBlockEntry(BlockPos positionIn, int priorityIn) {
            this.position = positionIn;
            this.priority = priorityIn;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isEntryValid(ServerLevel level) {
            BlockState blockState = level.m_8055_(this.position);
            if (blockState.m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_HIGH_PRIORITY) && this.priority == 2) {
                return true;
            }
            if (blockState.m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_MEDIUM_PRIORITY) && this.priority == 1) {
                return true;
            }
            return blockState.m_204336_(ModBlocks.BlockTags.SCULK_RAID_TARGET_LOW_PRIORITY) && this.priority == 0;
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("position", this.position.m_121878_());
            nbt.m_128356_("priority", (long)this.priority);
            return nbt;
        }

        public static PriorityBlockEntry serialize(CompoundTag nbt) {
            return new PriorityBlockEntry(BlockPos.m_122022_((long)nbt.m_128454_("position")), nbt.m_128451_("priority"));
        }
    }

    public static class DeathAreaEntry {
        private final BlockPos position;
        private int deathCount;
        private ResourceKey<Level> dimension;

        public DeathAreaEntry(ServerLevel dimension, BlockPos positionIn) {
            this.position = positionIn;
            this.deathCount = 1;
            this.dimension = dimension.m_46472_();
        }

        public DeathAreaEntry(ResourceKey<Level> dimension, BlockPos positionIn, int deathCountIn) {
            this.position = positionIn;
            this.deathCount = deathCountIn;
            this.dimension = dimension;
        }

        public ServerLevel getDimension() {
            return SculkHorde.savedData.level.m_7654_().m_129880_(this.dimension);
        }

        public void setDeathCount(int deathCountIn) {
            this.deathCount = deathCountIn;
        }

        public int getDeathCount() {
            return this.deathCount;
        }

        public void iterateDeathCount() {
            ++this.deathCount;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public boolean isValid() {
            boolean isDimensionValid = this.getDimension() != null;
            boolean isPositionValid = this.getPosition() != null;
            return isDimensionValid && isPositionValid;
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("position", this.position.m_121878_());
            nbt.m_128405_("deathCount", this.deathCount);
            if (this.dimension != null) {
                nbt.m_128359_("dimension", this.dimension.m_135782_().toString());
            }
            return nbt;
        }

        public static DeathAreaEntry serialize(CompoundTag nbt) {
            ResourceKey dimensionResourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dimension")));
            return new DeathAreaEntry((ResourceKey<Level>)dimensionResourceKey, BlockPos.m_122022_((long)nbt.m_128454_("position")), nbt.m_128451_("deathCount"));
        }
    }

    public static class AreaofInterestEntry {
        private final BlockPos position;
        private final ResourceKey<Level> dimension;
        private long ticksSinceLastRaid;

        public AreaofInterestEntry(ServerLevel dimension, BlockPos positionIn) {
            this.dimension = dimension.m_46472_();
            this.position = positionIn;
        }

        public AreaofInterestEntry(ResourceKey<Level> dimension, BlockPos positionIn, long ticksSinceLastRaidIn) {
            this.dimension = dimension;
            this.position = positionIn;
            this.ticksSinceLastRaid = ticksSinceLastRaidIn;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public ServerLevel getDimension() {
            return SculkHorde.savedData.level.m_7654_().m_129880_(this.dimension);
        }

        public boolean isInNoRaidZone() {
            for (NoRaidZoneEntry entry : SculkHorde.savedData.getNoRaidZoneEntries()) {
                if (!entry.isBlockPosInRadius(entry.getDimension(), this.getPosition())) continue;
                return true;
            }
            return false;
        }

        public boolean isEntryValid() {
            boolean isDimensionValid = this.getDimension() != null;
            boolean isPositionValid = this.getPosition() != null;
            return isDimensionValid && isPositionValid;
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("position", this.position.m_121878_());
            nbt.m_128356_(ModSavedData.ticksSinceLastRaidIdentifier, this.ticksSinceLastRaid);
            nbt.m_128359_("dimension", this.dimension.m_135782_().toString());
            return nbt;
        }

        public static AreaofInterestEntry serialize(CompoundTag nbt) {
            ResourceKey dimensionResourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dimension")));
            return new AreaofInterestEntry((ResourceKey<Level>)dimensionResourceKey, BlockPos.m_122022_((long)nbt.m_128454_("position")), nbt.m_128454_(ModSavedData.ticksSinceLastRaidIdentifier));
        }
    }

    public static class NoRaidZoneEntry {
        private final BlockPos position;
        private final int radius;
        private final long timeOfCreation;
        private long durationInTicksUntilExpiration;
        private final ResourceKey<Level> dimension;

        public NoRaidZoneEntry(ServerLevel dimension, BlockPos positionIn, int radiusIn, long gameTimeStampIn, long durationUntilExpirationIn) {
            this.dimension = dimension.m_46472_();
            this.position = positionIn;
            this.radius = radiusIn;
            this.timeOfCreation = gameTimeStampIn;
            this.durationInTicksUntilExpiration = durationUntilExpirationIn;
        }

        public NoRaidZoneEntry(ResourceKey<Level> dimension, BlockPos positionIn, int radiusIn, long gameTimeStampIn, long durationUntilExpirationIn) {
            this.dimension = dimension;
            this.position = positionIn;
            this.radius = radiusIn;
            this.timeOfCreation = gameTimeStampIn;
            this.durationInTicksUntilExpiration = durationUntilExpirationIn;
        }

        public ServerLevel getDimension() {
            return SculkHorde.savedData.level.m_7654_().m_129880_(this.dimension);
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public int getRadius() {
            return this.radius;
        }

        public long getTimeOfCreation() {
            return this.timeOfCreation;
        }

        public long getDurationInTicksUntilExpiration() {
            return this.durationInTicksUntilExpiration;
        }

        public boolean isExpired(long currentTimeStamp) {
            long defaultTicksUntilExpiration = TickUnits.convertMinutesToTicks((Integer)ModConfig.SERVER.sculk_raid_no_raid_zone_duration_minutes.get());
            long ticksUntilThisNoRaidZoneExpires = this.getDurationInTicksUntilExpiration();
            if (ticksUntilThisNoRaidZoneExpires > defaultTicksUntilExpiration) {
                this.durationInTicksUntilExpiration = defaultTicksUntilExpiration;
            }
            return currentTimeStamp - this.getTimeOfCreation() > this.getDurationInTicksUntilExpiration();
        }

        public boolean isBlockPosInRadius(ServerLevel level, BlockPos blockPosIn) {
            return this.position.m_123314_((Vec3i)blockPosIn, (double)this.radius) && BlockAlgorithms.areTheseDimensionsEqual(level, this.getDimension());
        }

        public CompoundTag deserialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("position", this.position.m_121878_());
            nbt.m_128405_("radius", this.radius);
            nbt.m_128356_("gameTimeStamp", this.timeOfCreation);
            nbt.m_128356_("durationUntilExpiration", this.durationInTicksUntilExpiration);
            nbt.m_128359_("dimension", this.dimension.m_135782_().toString());
            return nbt;
        }

        public static NoRaidZoneEntry serialize(CompoundTag nbt) {
            ResourceKey dimensionResourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dimension")));
            return new NoRaidZoneEntry((ResourceKey<Level>)dimensionResourceKey, BlockPos.m_122022_((long)nbt.m_128454_("position")), nbt.m_128451_("radius"), nbt.m_128454_("gameTimeStamp"), nbt.m_128454_("durationUntilExpiration"));
        }
    }
}

