/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind.entity_factory;

import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactory;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;

public class EntityFactoryEntry {
    private int orderCost = 0;
    private EntityType entity = null;
    private int limit = Integer.MAX_VALUE;
    public EntityFactory.StrategicValues strategicValue = EntityFactory.StrategicValues.Melee;
    public Gravemind.evolution_states minEvolutionRequired = Gravemind.evolution_states.Undeveloped;

    public EntityFactoryEntry(EntityType entity, int orderCost, EntityFactory.StrategicValues value, Gravemind.evolution_states minEvolution) {
        this.entity = entity;
        this.orderCost = orderCost;
        this.strategicValue = value;
        this.minEvolutionRequired = minEvolution;
    }

    public int getCost() {
        return this.orderCost;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    @Nullable
    public EntityType getEntity() {
        return this.entity;
    }

    public EntityFactory.StrategicValues getCategory() {
        return this.strategicValue;
    }

    public boolean isEntryAppropriateMinimalCheck() {
        if (this.getCost() > SculkHorde.savedData.getSculkAccumulatedMass()) {
            return false;
        }
        return SculkHorde.gravemind.isEvolutionStateEqualOrLessThanCurrent(this.minEvolutionRequired);
    }

    public boolean isEntryAppropriate(ReinforcementRequest context) {
        if (context == null) {
            return false;
        }
        if (context.budget != -1 && context.budget < this.orderCost) {
            return false;
        }
        if (!context.approvedMobTypes.contains((Object)this.getCategory()) && !context.approvedMobTypes.isEmpty()) {
            return false;
        }
        if (!SculkHorde.gravemind.isEvolutionStateEqualOrLessThanCurrent(this.minEvolutionRequired)) {
            return false;
        }
        return context.sender != ReinforcementRequest.senderType.SculkMass || this.getEntity() != ModEntities.SCULK_SPORE_SPEWER.get();
    }

    public Mob spawnEntity(ServerLevel level, BlockPos pos) {
        SculkHorde.savedData.subtractSculkAccumulatedMass(this.getCost());
        SculkHorde.statisticsData.incrementTotalUnitsSpawned();
        return (Mob)this.getEntity().m_20600_(level, (CompoundTag)null, (Component)null, (Player)null, pos, MobSpawnType.EVENT, false, false);
    }
}

