/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util.ChunkLoading;

import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.ChunkLoading.BlockEntityChunkLoadRequest;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class BlockEntityChunkLoaderHelper {
    private ArrayList<BlockEntityChunkLoadRequest> blockChunkLoadRequests = new ArrayList();
    private int tickCooldownRemaining = 0;
    private final int TICKS_BETWEEN_PROCESSING = TickUnits.convertSecondsToTicks(10);

    public ArrayList<BlockEntityChunkLoadRequest> getBlockChunkLoadRequests() {
        return this.blockChunkLoadRequests;
    }

    private boolean isTickCooldownFinished() {
        return this.tickCooldownRemaining <= 0;
    }

    private void resetTickCooldown() {
        this.tickCooldownRemaining = this.TICKS_BETWEEN_PROCESSING;
    }

    public static void load(CompoundTag tag) {
        if (BlockEntityChunkLoaderHelper.getChunkLoaderHelper() == null) {
            SculkHorde.LOGGER.error("BlockEntityChunkLoaderHelper is null. Cannot Load");
            return;
        }
        BlockEntityChunkLoaderHelper.getChunkLoaderHelper().blockChunkLoadRequests.clear();
        ListTag blockChunkLoadRequestsTag = tag.m_128437_("blockChunkLoadRequests", 10);
        for (int i = 0; i < blockChunkLoadRequestsTag.size(); ++i) {
            CompoundTag requestTag = blockChunkLoadRequestsTag.m_128728_(i);
            BlockEntityChunkLoadRequest request = BlockEntityChunkLoadRequest.serialize(requestTag);
            BlockEntityChunkLoaderHelper.getChunkLoaderHelper().blockChunkLoadRequests.add(request);
        }
    }

    public static CompoundTag save(CompoundTag tag) {
        if (BlockEntityChunkLoaderHelper.getChunkLoaderHelper() == null) {
            SculkHorde.LOGGER.error("BlockEntityChunkLoaderHelper is null. Cannot Save.");
            return tag;
        }
        ListTag blockChunkLoadRequestsTag = new ListTag();
        for (BlockEntityChunkLoadRequest request : BlockEntityChunkLoaderHelper.getChunkLoaderHelper().blockChunkLoadRequests) {
            blockChunkLoadRequestsTag.add((Object)request.deserialize());
        }
        tag.m_128365_("blockChunkLoadRequests", (Tag)blockChunkLoadRequestsTag);
        return tag;
    }

    public static BlockEntityChunkLoaderHelper getChunkLoaderHelper() {
        return SculkHorde.blockEntityChunkLoaderHelper;
    }

    public void processBlockChunkLoadRequests() {
        if (!this.isTickCooldownFinished()) {
            --this.tickCooldownRemaining;
            return;
        }
        this.resetTickCooldown();
        for (int i = 0; i < this.blockChunkLoadRequests.size(); ++i) {
            BlockEntityChunkLoadRequest request = this.blockChunkLoadRequests.get(i);
            request.decrementTicksUntilExpiration(this.TICKS_BETWEEN_PROCESSING);
            if (request.getDimension() == null) {
                if (SculkHorde.isDebugMode()) {
                    SculkHorde.LOGGER.error("BlockEntityChunkLoader | Dimension is null, Removing");
                }
                this.blockChunkLoadRequests.remove(i);
                --i;
                continue;
            }
            if (request.isExpired()) {
                if (SculkHorde.isDebugMode()) {
                    SculkHorde.LOGGER.info("BlockEntityChunkLoader | Chunk EXPIRED, Unloading and Removing");
                }
                this.unloadAndRemoveChunksWithOwner(request.getOwner(), request.getDimension());
            }
            this.loadChunksWithOwner(request.getOwner(), request.getDimension());
        }
    }

    public static void forceLoadChunk(ServerLevel world, int chunkX, int chunkZ) {
        if (world == null) {
            SculkHorde.LOGGER.error("World is null. Cannot Force Load Chunk");
            return;
        }
        world.m_8602_(chunkX, chunkZ, true);
    }

    public static void unloadChunk(ServerLevel world, BlockPos owner, int chunkX, int chunkZ) {
        if (world == null) {
            SculkHorde.LOGGER.error("World is null. Cannot Force Unload Chunk");
            return;
        }
        SculkHorde.LOGGER.debug("Successfully Unloaded Chunk");
        world.m_8602_(chunkX, chunkZ, false);
    }

    public void unloadAndRemoveChunksWithOwner(BlockPos owner, ServerLevel level) {
        for (int i = 0; i < this.blockChunkLoadRequests.size(); ++i) {
            BlockEntityChunkLoadRequest request = this.blockChunkLoadRequests.get(i);
            if (!request.isOwner(owner)) continue;
            for (ChunkPos chunkPos : request.getChunkPositionsToLoad()) {
                BlockEntityChunkLoaderHelper.unloadChunk(level, owner, chunkPos.f_45578_, chunkPos.f_45579_);
            }
            this.blockChunkLoadRequests.remove(i);
            --i;
        }
    }

    public void loadChunksWithOwner(BlockPos owner, ServerLevel level) {
        for (int i = 0; i < this.blockChunkLoadRequests.size(); ++i) {
            BlockEntityChunkLoadRequest request = this.blockChunkLoadRequests.get(i);
            if (!request.isOwner(owner)) continue;
            for (ChunkPos chunkPos : request.getChunkPositionsToLoad()) {
                BlockEntityChunkLoaderHelper.forceLoadChunk(level, chunkPos.f_45578_, chunkPos.f_45579_);
            }
        }
    }

    public void removeRequestsWithOwner(BlockPos owner, ServerLevel level) {
        ArrayList<BlockEntityChunkLoadRequest> requestsToRemove = new ArrayList<BlockEntityChunkLoadRequest>();
        for (BlockEntityChunkLoadRequest request : this.blockChunkLoadRequests) {
            if (!request.isOwner(owner)) continue;
            requestsToRemove.add(request);
        }
        this.blockChunkLoadRequests.removeAll(requestsToRemove);
    }

    public boolean doesChunkLoadRequestAlreadyExist(String requestID) {
        for (BlockEntityChunkLoadRequest request : this.blockChunkLoadRequests) {
            if (!request.isRequestID(requestID)) continue;
            return true;
        }
        return false;
    }

    private String generateRequestIDFromBlockPos(BlockPos owner) {
        ChunkPos centerChunkPos = new ChunkPos(owner);
        return String.valueOf(centerChunkPos.f_45578_) + String.valueOf(centerChunkPos.f_45579_);
    }

    public void createChunkLoadRequestSquare(ServerLevel level, BlockPos owner, int length, int priority, long ticksUnitExpiration) {
        if (length % 2 == 0) {
            ++length;
        }
        String requestID = this.generateRequestIDFromBlockPos(owner);
        int halfLength = length / 2;
        ChunkPos entityChunkPos = new ChunkPos(owner);
        ChunkPos[] chunkPositionsToLoad = new ChunkPos[length * length];
        int index = 0;
        for (int dx = -halfLength; dx <= halfLength; ++dx) {
            for (int dz = -halfLength; dz <= halfLength; ++dz) {
                chunkPositionsToLoad[index++] = new ChunkPos(entityChunkPos.f_45578_ + dx, entityChunkPos.f_45579_ + dz);
            }
        }
        this.createChunkLoadRequest(level, owner, chunkPositionsToLoad, priority, requestID, ticksUnitExpiration);
    }

    private void createChunkLoadRequest(ServerLevel level, BlockPos owner, ChunkPos[] chunkPositionsToLoad, int priority, String requestID, long ticksUntilExpiration) {
        if (!this.doesChunkLoadRequestAlreadyExist(requestID) && ((Boolean)ModConfig.SERVER.chunk_loading_enabled.get()).booleanValue()) {
            BlockEntityChunkLoadRequest request = new BlockEntityChunkLoadRequest((ResourceKey<Level>)level.m_46472_(), owner, chunkPositionsToLoad, priority, requestID, ticksUntilExpiration);
            this.blockChunkLoadRequests.add(request);
            this.loadChunksWithOwner(request.getOwner(), request.getDimension());
        }
    }
}

