/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util.ChunkLoading;

import com.github.sculkhorde.core.SculkHorde;
import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public abstract class ChunkLoadRequest {
    ChunkPos[] chunkPositionsToLoad;
    int priority;
    String requestID;
    ResourceKey<Level> dimension;
    long ticksUntilExpiration = 0L;

    public ChunkLoadRequest(ResourceKey<Level> dimension, ChunkPos[] chunkPositionsToLoad, int priority, String requestID, long ticksUntilExpiration) {
        this.chunkPositionsToLoad = chunkPositionsToLoad;
        this.priority = priority;
        this.requestID = requestID;
        this.ticksUntilExpiration = ticksUntilExpiration;
    }

    public ChunkPos[] getChunkPositionsToLoad() {
        return this.chunkPositionsToLoad;
    }

    public int getPriority() {
        return this.priority;
    }

    public ServerLevel getDimension() {
        return SculkHorde.savedData.level.m_7654_().m_129880_(this.dimension);
    }

    public String getRequestID() {
        return this.requestID;
    }

    public boolean isRequestID(String requestID) {
        return Objects.equals(this.requestID, requestID);
    }

    public abstract Object getOwner();

    public abstract boolean isOwner(Object var1);

    public boolean isExpired() {
        return this.ticksUntilExpiration <= 0L;
    }

    public void decrementTicksUntilExpiration(int amountToDecrement) {
        this.ticksUntilExpiration -= (long)amountToDecrement;
    }

    public long getTicksUntilExpiration() {
        return this.ticksUntilExpiration;
    }

    public boolean isHigherPriorityThan(ChunkLoadRequest other) {
        return this.priority < other.priority;
    }

    public boolean doesContainChunk(ChunkPos chunkPos) {
        for (ChunkPos pos : this.chunkPositionsToLoad) {
            if (!pos.equals((Object)chunkPos)) continue;
            return true;
        }
        return false;
    }

    public void removeChunk(ChunkPos chunkPos) {
        if (!this.doesContainChunk(chunkPos)) {
            return;
        }
        ChunkPos[] newChunkPositionsToLoad = new ChunkPos[this.chunkPositionsToLoad.length - 1];
        int index = 0;
        for (ChunkPos pos : this.chunkPositionsToLoad) {
            if (pos.equals((Object)chunkPos)) continue;
            newChunkPositionsToLoad[index] = pos;
            ++index;
        }
        this.chunkPositionsToLoad = newChunkPositionsToLoad;
    }

    public void addChunk(ChunkPos chunkPos) {
        if (this.doesContainChunk(chunkPos)) {
            return;
        }
        ChunkPos[] newChunkPositionsToLoad = new ChunkPos[this.chunkPositionsToLoad.length + 1];
        int index = 0;
        ChunkPos[] chunkPosArray = this.chunkPositionsToLoad;
        int n = chunkPosArray.length;
        for (int i = 0; i < n; ++i) {
            ChunkPos pos;
            newChunkPositionsToLoad[index] = pos = chunkPosArray[i];
            ++index;
        }
        newChunkPositionsToLoad[index] = chunkPos;
        this.chunkPositionsToLoad = newChunkPositionsToLoad;
    }

    public void setChunkPositionsToLoad(ChunkPos[] chunkPositionsToLoad) {
        this.chunkPositionsToLoad = chunkPositionsToLoad;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

