/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.util.DataUtils;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.ai.HordeTrackPlayerGoal;
import net.smileycorp.hordes.common.hordeevent.capability.HordeSavedData;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeEvent;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeSpawn;
import net.smileycorp.hordes.common.hordeevent.data.HordeTableLoader;
import net.smileycorp.hordes.common.hordeevent.data.scripts.HordeScriptLoader;

@Mod.EventBusSubscriber(modid="hordes")
public class HordeEventHandler {
    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Mob) {
            event.addCapability(Constants.loc("HordeSpawn"), (ICapabilityProvider)new IHordeSpawn.Provider());
        }
        if (entity instanceof Player && !(entity instanceof FakePlayer)) {
            event.addCapability(Constants.loc("HordeEvent"), (ICapabilityProvider)new IHordeEvent.Provider());
        }
    }

    @SubscribeEvent
    public void addResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)HordeTableLoader.INSTANCE);
        event.addListener((PreparableReloadListener)HordeScriptLoader.INSTANCE);
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server;
        ServerLevel level;
        if (event.phase == TickEvent.Phase.START & (Boolean)CommonConfigHandler.hordesCommandOnly.get() == false && (level = (server = ServerLifecycleHooks.getCurrentServer()).m_129783_()).m_46469_().m_46207_(GameRules.f_46140_) | (Boolean)CommonConfigHandler.pauseEventServer.get() == false) {
            HordeSavedData data;
            int day = (int)Math.floor(level.m_46468_() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue());
            if (day >= (data = HordeSavedData.getData(level)).getNextDay()) {
                data.setNextDay(level.f_46441_.m_188503_((Integer)CommonConfigHandler.hordeSpawnVariation.get() + 1) + (Integer)CommonConfigHandler.hordeSpawnDays.get() + data.getNextDay());
            }
            data.save();
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && player != null && !(player instanceof FakePlayer)) {
            LazyOptional optional;
            Level level = player.f_19853_;
            if (!level.f_46443_ && (level.m_46469_().m_46207_(GameRules.f_46140_) || !((Boolean)CommonConfigHandler.pauseEventServer.get()).booleanValue()) && (optional = player.getCapability(Hordes.HORDE_EVENT, null)).isPresent()) {
                IHordeEvent horde = (IHordeEvent)optional.resolve().get();
                int day = (int)Math.floor(level.m_46468_() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue());
                int time = Math.round(level.m_46468_() % (long)((Integer)CommonConfigHandler.dayLength.get()).intValue());
                if (horde != null && !horde.isActive(player) && time >= (Integer)CommonConfigHandler.hordeStartTime.get() && day >= horde.getNextDay() && (day > 0 || ((Boolean)CommonConfigHandler.spawnFirstDay.get()).booleanValue())) {
                    horde.tryStartEvent(player, (Integer)CommonConfigHandler.hordeSpawnDuration.get(), false);
                }
                if (horde.isActive(player)) {
                    horde.update(player);
                }
            }
        }
    }

    @SubscribeEvent
    public void tryDespawn(LivingSpawnEvent.AllowDespawn event) {
        LazyOptional optionalp;
        ServerPlayer player;
        String uuid;
        IHordeSpawn cap;
        Mob entity = event.getEntity();
        if (entity.f_19853_.f_46443_) {
            return;
        }
        LazyOptional optional = entity.getCapability(Hordes.HORDESPAWN, null);
        if (optional.isPresent() && (cap = (IHordeSpawn)optional.resolve().get()).isHordeSpawned() && DataUtils.isValidUUID((String)(uuid = cap.getPlayerUUID())) && (player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(UUID.fromString(uuid))) != null && (optionalp = player.getCapability(Hordes.HORDE_EVENT, null)).isPresent() && ((IHordeEvent)optionalp.resolve().get()).isActive(player)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof Mob) {
            LazyOptional optionalp;
            ServerPlayer player;
            String uuid;
            IHordeSpawn cap;
            Mob entity = (Mob)event.getEntity();
            if (entity.f_19853_.f_46443_) {
                return;
            }
            LazyOptional optional = entity.getCapability(Hordes.HORDESPAWN, null);
            if (optional.isPresent() && (cap = (IHordeSpawn)optional.resolve().get()).isHordeSpawned() && DataUtils.isValidUUID((String)(uuid = cap.getPlayerUUID())) && (player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(UUID.fromString(uuid))) != null && (optionalp = player.getCapability(Hordes.HORDE_EVENT, null)).isPresent()) {
                ((IHordeEvent)optionalp.resolve().get()).removeEntity(entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void update(LivingEvent.LivingTickEvent event) {
        ServerPlayer player;
        String uuid;
        IHordeSpawn cap;
        Mob entity;
        LazyOptional optional;
        Level level = event.getEntity().f_19853_;
        if (!level.f_46443_ && event.getEntity() instanceof Mob && level.m_46472_() == Level.f_46428_ && event.getEntity().f_19797_ % 5 == 0 && (optional = (entity = (Mob)event.getEntity()).getCapability(Hordes.HORDESPAWN, null)).isPresent() && (cap = (IHordeSpawn)optional.resolve().get()).isHordeSpawned() & !cap.isSynced() && DataUtils.isValidUUID((String)(uuid = cap.getPlayerUUID())) && (player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(UUID.fromString(uuid))) != null) {
            entity.f_21346_.m_25386_().forEach(goal -> goal.m_8041_());
            if (entity instanceof PathfinderMob) {
                entity.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)entity, new Class[0]));
            }
            entity.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(entity, Player.class, true));
            LazyOptional optionalp = player.getCapability(Hordes.HORDE_EVENT, null);
            if (optionalp.isPresent()) {
                ((IHordeEvent)optionalp.resolve().get()).registerEntity(entity);
                entity.f_21345_.m_25352_(6, (Goal)new HordeTrackPlayerGoal(entity, (Entity)player));
            }
            cap.setSynced();
        }
    }

    @SubscribeEvent
    public void playerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server;
        if (((Boolean)CommonConfigHandler.pauseEventServer.get()).booleanValue() && (server = ServerLifecycleHooks.getCurrentServer()).m_7416_() == 0) {
            server.m_129785_().forEach(level -> {
                if (level.m_46469_().m_46207_(GameRules.f_46140_)) {
                    ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46140_)).m_46246_(false, server);
                }
            });
        }
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (((Boolean)CommonConfigHandler.pauseEventServer.get()).booleanValue()) {
            server.m_129785_().forEach(level -> {
                if (!level.m_46469_().m_46207_(GameRules.f_46140_)) {
                    ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46140_)).m_46246_(true, server);
                }
            });
        }
    }

    @SubscribeEvent
    public void trySleep(PlayerSleepInBedEvent event) {
        IHordeEvent horde;
        LazyOptional optional;
        Player player = event.getEntity();
        Level level = player.f_19853_;
        if (!((Boolean)CommonConfigHandler.canSleepDuringHorde.get()).booleanValue() && !level.f_46443_ && (optional = player.getCapability(Hordes.HORDE_EVENT, null)).isPresent() && ((horde = (IHordeEvent)optional.resolve().get()).isHordeDay(player) && level.m_6042_().f_63862_() & !level.m_46461_() || horde.isActive(player))) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
            player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("message.hordes.TrySleep")), true);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void playerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        Player original = event.getOriginal();
        if (player != null && original != null & (!(player instanceof FakePlayer) && !(original instanceof FakePlayer))) {
            LazyOptional optionalp = player.getCapability(Hordes.HORDE_EVENT, null);
            LazyOptional optionalo = original.getCapability(Hordes.HORDE_EVENT, null);
            if (optionalp.isPresent() && optionalo.isPresent()) {
                IHordeEvent horde = (IHordeEvent)optionalp.resolve().get();
                horde.readFromNBT(((IHordeEvent)optionalo.resolve().get()).writeToNBT(new CompoundTag()));
                horde.setPlayer(player);
            }
        }
    }
}

