/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class HordeSpawnEntry {
    private final ResourceLocation name;
    @Deprecated
    protected final EntityType<?> type;
    protected final int weight;
    protected final int minDay;
    protected final int maxDay;
    protected CompoundTag nbt = null;

    public HordeSpawnEntry(EntityType<?> type) {
        this(type, 0, 0, 0);
    }

    HordeSpawnEntry(EntityType<?> type, int weight, int minDay, int maxDay) {
        this.name = ForgeRegistries.ENTITY_TYPES.getKey(type);
        this.type = type;
        this.weight = weight;
        this.minDay = minDay;
        this.maxDay = maxDay;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getMinDay() {
        return this.minDay;
    }

    public int getMaxDay() {
        return this.maxDay;
    }

    @Deprecated
    public EntityType<?> getEntity() {
        return this.type;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public CompoundTag getNBT() {
        return this.nbt == null ? new CompoundTag() : this.nbt;
    }

    public void setNBT(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public String toString() {
        String str = "HordeSpawnEntry[type=" + this.type + ",weight=" + this.weight + ",minDay=" + this.minDay + ",maxDay=" + this.maxDay + "]";
        return this.nbt == null ? str : str + "{" + this.nbt.toString() + "}";
    }
}

