/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeEvent;
import net.smileycorp.hordes.common.hordeevent.data.HordeTableLoader;

public class CommandStartHordeEvent {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"startHordeEvent").requires(commandSource -> commandSource.m_6761_(1))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"length", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandStartHordeEvent.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"length")))).then(Commands.m_82129_((String)"table", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(HordeTableLoader::getSuggestions).executes(ctx -> CommandStartHordeEvent.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"length"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"table")))))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"length", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandStartHordeEvent.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"length"), EntityArgument.m_91477_((CommandContext)ctx, (String)"player")))).then(Commands.m_82129_((String)"table", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(HordeTableLoader::getSuggestions).executes(ctx -> CommandStartHordeEvent.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"length"), EntityArgument.m_91477_((CommandContext)ctx, (String)"player"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"table"))))));
        dispatcher.register(command);
    }

    public static int execute(CommandContext<CommandSourceStack> ctx, int length) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (source.m_81373_() instanceof Player) {
            return CommandStartHordeEvent.execute(ctx, length, Lists.newArrayList((Object[])new ServerPlayer[]{source.m_81375_()}));
        }
        return 0;
    }

    public static int execute(CommandContext<CommandSourceStack> ctx, int length, Collection<ServerPlayer> players) throws CommandSyntaxException {
        for (Player player : players) {
            LazyOptional optional = player.getCapability(Hordes.HORDE_EVENT, null);
            try {
                if (!optional.isPresent()) continue;
                ((IHordeEvent)optional.resolve().get()).tryStartEvent(player, length, true);
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to run startHordeEvent command", e);
            }
        }
        return 1;
    }

    public static int execute(CommandContext<CommandSourceStack> ctx, int length, ResourceLocation table) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (source.m_81373_() instanceof Player) {
            return CommandStartHordeEvent.execute(ctx, length, Lists.newArrayList((Object[])new ServerPlayer[]{source.m_81375_()}), table);
        }
        return 0;
    }

    public static int execute(CommandContext<CommandSourceStack> ctx, int length, Collection<ServerPlayer> players, ResourceLocation table) throws CommandSyntaxException {
        for (Player player : players) {
            LazyOptional optional = player.getCapability(Hordes.HORDE_EVENT, null);
            try {
                if (!optional.isPresent()) continue;
                IHordeEvent event = (IHordeEvent)optional.resolve().get();
                event.setSpawntable(HordeTableLoader.INSTANCE.getTable(table));
                event.tryStartEvent(player, length, true);
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to run startHordeEvent command", e);
            }
        }
        return 1;
    }
}

