/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.data;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.smileycorp.hordes.common.HordesLogger;
import org.apache.commons.io.FileUtils;

public class DefaultDataGenerator {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Path CONFIG_FOLDER = FMLPaths.CONFIGDIR.get().resolve("hordes");

    public static boolean tryGenerateDataFiles() {
        if (CONFIG_FOLDER.toFile().exists()) {
            return false;
        }
        DefaultDataGenerator.generateHordeTableFile();
        DefaultDataGenerator.generateInfectionEntitiesFile();
        DefaultDataGenerator.generateInfectionCuresFile();
        DefaultDataGenerator.generateMcmetaFile();
        DefaultDataGenerator.copyFile("assets/hordes/sounds.json");
        DefaultDataGenerator.copyFile("assets/hordes/sounds/horde_spawn.ogg");
        DefaultDataGenerator.copyFile("assets/hordes/lang/en_us.json");
        DefaultDataGenerator.copyFile("data/hordes/horde_scripts/default.json");
        DefaultDataGenerator.copyFile("data/hordes/tables/skeletons.json");
        DefaultDataGenerator.copyFile("data/hordes/tables/mixed_mobs.json");
        DefaultDataGenerator.copyFile("data/hordes/tables/illagers.json");
        return true;
    }

    private static void generateMcmetaFile() {
        try {
            File file = CONFIG_FOLDER.resolve("pack.mcmeta").toFile();
            file.createNewFile();
            JsonObject json = new JsonObject();
            JsonObject pack = new JsonObject();
            pack.addProperty("description", "The Hordes config datapack");
            pack.addProperty("pack_format", (Number)8);
            json.add("pack", (JsonElement)pack);
            FileWriter writer = new FileWriter(file);
            writer.write(GSON.toJson((JsonElement)json));
            writer.close();
            HordesLogger.logInfo("Generated pack.mcmeta");
        }
        catch (Exception e) {
            HordesLogger.logError("Failed to generate pack.mcmeta", e);
        }
    }

    private static void generateHordeTableFile() {
        try {
            List hordeEntries = null;
            ArrayList oldHordeEntries = Lists.newArrayList((Object[])new String[]{"minecraft:zombie-35-0-20", "minecraft:zombie_villager-1-0-20", "minecraft:husk-40-30-0", "minecraft:drowned{HandItems:[{id:trident,Count:1}]}-1-40-0", "minecraft:zombie_horse-3-30-0"});
            File file = CONFIG_FOLDER.resolve("data/hordes/tables/default.json").toFile();
            file.getParentFile().mkdirs();
            file.createNewFile();
            try {
                ModConfig config = (ModConfig)ConfigTracker.INSTANCE.fileMap().get("hordes-common.toml");
                CommentedFileConfig configData = (CommentedFileConfig)config.getHandler().reader(FMLPaths.CONFIGDIR.get()).apply(config);
                hordeEntries = (List)configData.get((List)Lists.newArrayList((Object[])new String[]{"Horde Event", "spawnList"}));
            }
            catch (Exception e) {
                DefaultDataGenerator.copyFile("data/hordes/tables/default.json");
                HordesLogger.logError("Error reading hordes-common.toml, generating fallback spawnlist", e);
                return;
            }
            if (oldHordeEntries.equals(hordeEntries)) {
                DefaultDataGenerator.copyFile("data/hordes/tables/default.json");
                HordesLogger.logInfo("hordes-common.toml spawnlist matches last update defaults, generating new spawnlist");
            }
            if (hordeEntries == null || hordeEntries.isEmpty()) {
                DefaultDataGenerator.copyFile("data/hordes/tables/default.json");
                HordesLogger.logInfo("hordes-common.toml spawnlist is empty, generating fallback spawnlist");
                return;
            }
            JsonArray json = new JsonArray();
            for (String entry : hordeEntries) {
                json.add(entry);
            }
            FileWriter writer = new FileWriter(file);
            writer.write(GSON.toJson((JsonElement)json));
            writer.close();
            HordesLogger.logInfo("Generated default horde table file from old config values.");
        }
        catch (Exception e) {
            HordesLogger.logError("Failed to generate horde table file", e);
        }
    }

    private static void generateInfectionEntitiesFile() {
        try {
            List infectionEntities = null;
            ArrayList oldInfectionEntries = Lists.newArrayList((Object[])new String[]{"minecraft:zombie", "minecraft:zombie_villager", "minecraft:husk", "minecraft:drowned", "minecraft:zombie_horse", "hordes:zombie_player", "hordes:drowned_player"});
            File file = CONFIG_FOLDER.resolve("data/hordes/tags/entity_types/infection_entities.json").toFile();
            file.getParentFile().mkdirs();
            file.createNewFile();
            try {
                ModConfig config = (ModConfig)ConfigTracker.INSTANCE.fileMap().get("hordes-common.toml");
                CommentedFileConfig configData = (CommentedFileConfig)config.getHandler().reader(FMLPaths.CONFIGDIR.get()).apply(config);
                infectionEntities = (List)configData.get((List)Lists.newArrayList((Object[])new String[]{"Infection", "infectionEntities"}));
            }
            catch (Exception e) {
                DefaultDataGenerator.copyFile("data/hordes/tags/entity_types/infection_entities.json");
                HordesLogger.logError("Error reading hordes-common.toml, generating fallback infection entities tag", e);
                return;
            }
            if (oldInfectionEntries.equals(infectionEntities)) {
                DefaultDataGenerator.copyFile("data/hordes/tags/entity_types/infection_entities.json");
                HordesLogger.logInfo("hordes-common.toml spawnlist matches last update defaults, generating new infection entities tag");
            }
            if (infectionEntities == null || infectionEntities.isEmpty()) {
                DefaultDataGenerator.copyFile("data/hordes/tags/entity_types/infection_entities.json");
                HordesLogger.logInfo("hordes-common.toml spawnlist is empty, generating fallback infection entities tag");
                return;
            }
            JsonObject json = new JsonObject();
            json.addProperty("replace", Boolean.valueOf(false));
            JsonArray values = new JsonArray();
            for (String entry : infectionEntities) {
                values.add(entry);
            }
            json.add("values", (JsonElement)values);
            FileWriter writer = new FileWriter(file);
            writer.write(GSON.toJson((JsonElement)json));
            writer.close();
            HordesLogger.logInfo("Generated infection entity tag file from old config values.");
        }
        catch (Exception e) {
            HordesLogger.logError("Failed to generate infection entity file", e);
        }
    }

    private static void generateInfectionCuresFile() {
        try {
            List cureEntries = null;
            File file = CONFIG_FOLDER.resolve("data/hordes/tags/items/infection_cures.json").toFile();
            file.getParentFile().mkdirs();
            file.createNewFile();
            try {
                ModConfig config = (ModConfig)ConfigTracker.INSTANCE.fileMap().get("hordes-common.toml");
                CommentedFileConfig configData = (CommentedFileConfig)config.getHandler().reader(FMLPaths.CONFIGDIR.get()).apply(config);
                cureEntries = (List)configData.get((List)Lists.newArrayList((Object[])new String[]{"Infection", "cureItemList"}));
            }
            catch (Exception e) {
                DefaultDataGenerator.copyFile("data/hordes/tags/items/infection_cures.json");
                HordesLogger.logError("Error reading hordes-common.toml, generating fallback cure item tag", e);
                return;
            }
            if (cureEntries == null || cureEntries.isEmpty()) {
                DefaultDataGenerator.copyFile("data/hordes/tags/items/infection_cures.json");
                HordesLogger.logInfo("hordes-common.toml spawnlist is empty, generating fallback cure item tag");
                return;
            }
            JsonObject json = new JsonObject();
            json.addProperty("replace", Boolean.valueOf(false));
            JsonArray values = new JsonArray();
            for (String entry : cureEntries) {
                if (entry.contains("{")) {
                    entry = entry.substring(entry.indexOf("{"));
                }
                values.add(entry);
            }
            json.add("values", (JsonElement)values);
            FileWriter writer = new FileWriter(file);
            writer.write(GSON.toJson((JsonElement)json));
            writer.close();
            HordesLogger.logInfo("Generated cure tag from old config values.");
        }
        catch (Exception e) {
            HordesLogger.logError("Failed to generate cure item tag file", e);
        }
    }

    private static void copyFile(String path) {
        try {
            ModFile mod = FMLLoader.getLoadingModList().getModFileById("hordes").getFile();
            File directory = CONFIG_FOLDER.toFile();
            File output = new File(directory, path);
            File dir = output.getParentFile();
            if (dir != null) {
                dir.mkdirs();
            }
            FileUtils.copyInputStreamToFile((InputStream)Files.newInputStream(mod.findResource(new String[]{"config_defaults/" + path}), StandardOpenOption.READ), (File)new File(directory, path));
            HordesLogger.logInfo("Copied file " + path);
        }
        catch (Exception e) {
            HordesLogger.logError("Failed to copy file " + path, e);
        }
    }
}

