/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.data.scripts;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.common.hordeevent.data.scripts.HordeScript;

public class HordeScriptLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static HordeScriptLoader INSTANCE = new HordeScriptLoader();
    private final Map<ResourceLocation, HordeScript> SCRIPTS = Maps.newHashMap();

    public HordeScriptLoader() {
        super(GSON, "horde_scripts");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiller) {
        this.SCRIPTS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                this.SCRIPTS.put(entry.getKey(), HordeScript.deserialize(entry.getKey(), entry.getValue()));
                HordesLogger.logInfo("loaded horde script " + entry.getKey());
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to parse script " + entry.getKey(), e);
            }
        }
    }

    public Collection<HordeScript> getScripts() {
        return this.SCRIPTS.values();
    }

    public Collection<HordeScript> getScripts(HordePlayerEvent event) {
        ArrayList list = Lists.newArrayList();
        for (HordeScript script : this.getScripts()) {
            if (script.getType() != ((Object)((Object)event)).getClass()) continue;
            list.add(script);
        }
        return list;
    }
}

