/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.data.scripts;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.atlas.api.data.LogicalOperation;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.hordeevent.data.conditions.BiomeCondition;
import net.smileycorp.hordes.common.hordeevent.data.conditions.ComparisonCondition;
import net.smileycorp.hordes.common.hordeevent.data.conditions.Condition;
import net.smileycorp.hordes.common.hordeevent.data.conditions.DayCondition;
import net.smileycorp.hordes.common.hordeevent.data.conditions.LogicalCondition;
import net.smileycorp.hordes.common.hordeevent.data.conditions.RandomCondition;
import net.smileycorp.hordes.common.hordeevent.data.values.LevelNBTGetter;
import net.smileycorp.hordes.common.hordeevent.data.values.PlayerNBTGetter;
import net.smileycorp.hordes.common.hordeevent.data.values.PlayerPosGetter;
import net.smileycorp.hordes.common.hordeevent.data.values.ValueGetter;

public class HordeScriptRegistry {
    private static Map<ResourceLocation, BiFunction<String, DataType, ValueGetter>> VALUE_GETTERS = Maps.newHashMap();
    private static Map<ResourceLocation, Function<JsonElement, Condition>> CONDITION_DESERIALIZERS = Maps.newHashMap();

    public static void init() {
        HordeScriptRegistry.registerValueGetters();
        HordeScriptRegistry.registerDeserializers();
        HordeScriptRegistry.registerFunctions();
    }

    private static void registerValueGetters() {
        HordeScriptRegistry.registerValueGetter(Constants.loc("level_nbt"), LevelNBTGetter::new);
        HordeScriptRegistry.registerValueGetter(Constants.loc("player_nbt"), PlayerNBTGetter::new);
        HordeScriptRegistry.registerValueGetter(Constants.loc("player_pos"), PlayerPosGetter::new);
    }

    public static void registerDeserializers() {
        for (LogicalOperation operation : LogicalOperation.values()) {
            HordeScriptRegistry.registerConditionDeserializer(Constants.loc(operation.getName()), e -> LogicalCondition.deserialize(operation, e));
        }
        HordeScriptRegistry.registerConditionDeserializer(Constants.loc("comparison"), ComparisonCondition::deserialize);
        HordeScriptRegistry.registerConditionDeserializer(Constants.loc("random"), RandomCondition::deserialize);
        HordeScriptRegistry.registerConditionDeserializer(Constants.loc("biome"), BiomeCondition::deserialize);
        HordeScriptRegistry.registerConditionDeserializer(Constants.loc("day"), DayCondition::deserialize);
    }

    public static void registerFunctions() {
    }

    public static ValueGetter readValue(DataType type, JsonObject json) {
        if (json.has("name") && json.has("value")) {
            try {
                return VALUE_GETTERS.get(new ResourceLocation(json.get("name").getAsString())).apply(json.get("value").getAsString(), type);
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to read value " + json, e);
            }
        }
        return null;
    }

    public static Condition readCondition(JsonObject json) {
        if (json.has("name") && json.has("value")) {
            try {
                return CONDITION_DESERIALIZERS.get(new ResourceLocation(json.get("name").getAsString())).apply(json.get("value"));
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to read condition " + json, e);
            }
        }
        return null;
    }

    public static void registerValueGetter(ResourceLocation name, BiFunction<String, DataType, ValueGetter> getter) {
        VALUE_GETTERS.put(name, getter);
    }

    public static void registerConditionDeserializer(ResourceLocation name, Function<JsonElement, Condition> serializer) {
        CONDITION_DESERIALIZERS.put(name, serializer);
    }
}

