/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.infection;

import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.smileycorp.atlas.api.util.DirectionUtils;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.event.InfectionDeathEvent;
import net.smileycorp.hordes.common.infection.HordesInfection;
import net.smileycorp.hordes.common.infection.InfectionRegister;
import net.smileycorp.hordes.common.infection.capability.IInfection;
import net.smileycorp.hordes.common.infection.network.CureEntityMessage;
import net.smileycorp.hordes.common.infection.network.InfectMessage;
import net.smileycorp.hordes.common.infection.network.InfectionPacketHandler;

@Mod.EventBusSubscriber(modid="atlaslib")
public class InfectionEventHandler {
    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player && !(entity instanceof FakePlayer) || entity instanceof Villager || InfectionRegister.canBeInfected(entity)) {
            event.addCapability(Constants.loc("InfectionCounter"), (ICapabilityProvider)new IInfection.Provider());
        }
    }

    @SubscribeEvent
    public void onEntityAdded(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity != null && !entity.f_19853_.f_46443_ && ((Boolean)CommonConfigHandler.infectionEntitiesAggroConversions.get()).booleanValue() && InfectionRegister.canCauseInfection(entity) && entity instanceof Mob) {
            ((Mob)entity).f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)entity, LivingEntity.class, 10, true, false, InfectionRegister::canBeInfected));
        }
    }

    @SubscribeEvent
    public void onItemStackConsume(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntity();
        ItemStack stack = event.getItem();
        if (entity.m_21023_((MobEffect)HordesInfection.INFECTED.get()) && InfectionRegister.isCure(stack)) {
            LazyOptional optional = entity.getCapability(Hordes.INFECTION);
            if (optional.isPresent()) {
                ((IInfection)optional.resolve().get()).increaseInfection();
            }
            entity.m_21195_((MobEffect)HordesInfection.INFECTED.get());
            InfectionPacketHandler.NETWORK_INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> entity.f_19853_.m_46745_(entity.m_20097_())), (Object)new CureEntityMessage(entity));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(PlayerInteractEvent.RightClickItem event) {
        LivingEntity entity;
        ItemStack stack = event.getItemStack();
        HitResult ray = DirectionUtils.getEntityRayTrace((Level)event.getLevel(), (Entity)event.getEntity(), (float)5.0f);
        if (ray instanceof EntityHitResult && ((EntityHitResult)ray).m_82443_() instanceof LivingEntity && (entity = (LivingEntity)((EntityHitResult)ray).m_82443_()).m_21023_((MobEffect)HordesInfection.INFECTED.get()) && InfectionRegister.isCure(stack)) {
            entity.m_21195_((MobEffect)HordesInfection.INFECTED.get());
            LazyOptional optional = entity.getCapability(Hordes.INFECTION);
            if (optional.isPresent()) {
                ((IInfection)optional.resolve().get()).increaseInfection();
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
        }
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        Entity attacker = event.getSource().m_7640_();
        Level level = entity.f_19853_;
        RandomSource rand = level.f_46441_;
        if (!level.f_46443_ && InfectionRegister.canCauseInfection(attacker) && !entity.m_21023_((MobEffect)HordesInfection.INFECTED.get())) {
            if (entity instanceof Player && ((Boolean)CommonConfigHandler.infectPlayers.get()).booleanValue()) {
                int c = rand.m_188503_(100);
                if (c <= (Integer)CommonConfigHandler.playerInfectChance.get()) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)HordesInfection.INFECTED.get(), InfectionRegister.getInfectionTime(entity), 0));
                    InfectionPacketHandler.NETWORK_INSTANCE.sendTo((Object)new InfectMessage(), ((ServerPlayer)entity).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            } else if (entity instanceof Villager && ((Boolean)CommonConfigHandler.infectVillagers.get()).booleanValue()) {
                int c = rand.m_188503_(100);
                if (c <= (Integer)CommonConfigHandler.villagerInfectChance.get()) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)HordesInfection.INFECTED.get(), InfectionRegister.getInfectionTime(entity), 0));
                }
            } else if (InfectionRegister.canBeInfected((Entity)entity)) {
                InfectionRegister.tryToInfect(entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        Level level = entity.f_19853_;
        if (!level.f_46443_ && (source == HordesInfection.INFECTION_DAMAGE || entity.m_21023_((MobEffect)HordesInfection.INFECTED.get()))) {
            InfectionDeathEvent newevent = new InfectionDeathEvent(entity, event.getSource());
            MinecraftForge.EVENT_BUS.post((Event)newevent);
            if (newevent.getResult() == Event.Result.DENY) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onInfectDeath(InfectionDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (entity instanceof Villager && level instanceof ServerLevel) {
            Villager villager = (Villager)entity;
            ZombieVillager zombie = (ZombieVillager)villager.m_21406_(EntityType.f_20530_, false);
            if (zombie != null) {
                zombie.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(zombie.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), null);
                zombie.m_34375_(villager.m_7141_());
                zombie.m_34391_((Tag)villager.m_35517_().m_26179_((DynamicOps)NbtOps.f_128958_).getValue());
                zombie.m_34411_(villager.m_6616_().m_45388_());
                zombie.m_34373_(villager.m_7809_());
                ForgeEventFactory.onLivingConvert((LivingEntity)villager, (LivingEntity)zombie);
            }
            event.setResult(Event.Result.DENY);
        } else if (InfectionRegister.canBeInfected((Entity)entity)) {
            InfectionRegister.convertEntity((Mob)entity);
            event.setResult(Event.Result.DENY);
        }
    }
}

