/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.infection.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.IntTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.smileycorp.hordes.common.Hordes;

public interface IInfection {
    public int getInfectionCount();

    public void increaseInfection();

    public void loadInfectionCount(IntTag var1);

    public IntTag saveInfectionCount();

    public static class Provider
    implements ICapabilitySerializable<IntTag> {
        protected IInfection impl = new Infection();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
            return cap == Hordes.INFECTION ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }

        public IntTag serializeNBT() {
            return this.impl.saveInfectionCount();
        }

        public void deserializeNBT(IntTag nbt) {
            this.impl.loadInfectionCount(nbt);
        }
    }

    public static class Infection
    implements IInfection {
        protected int count = 0;

        @Override
        public int getInfectionCount() {
            return this.count;
        }

        @Override
        public void increaseInfection() {
            ++this.count;
        }

        @Override
        public void loadInfectionCount(IntTag tag) {
            this.count = tag.m_7047_();
        }

        @Override
        public IntTag saveInfectionCount() {
            return IntTag.m_128679_((int)this.count);
        }
    }
}

