/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.infection.network;

import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.smileycorp.atlas.api.network.SimpleMessageDecoder;
import net.smileycorp.atlas.api.network.SimpleMessageEncoder;
import net.smileycorp.hordes.client.ClientHandler;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.infection.network.CureEntityMessage;
import net.smileycorp.hordes.common.infection.network.InfectMessage;

public class InfectionPacketHandler {
    public static SimpleChannel NETWORK_INSTANCE;

    public static void initPackets() {
        NETWORK_INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)Constants.loc("Infection"), () -> "1", "1"::equals, "1"::equals);
        NETWORK_INSTANCE.registerMessage(1, InfectMessage.class, (BiConsumer)new SimpleMessageEncoder(), (Function)new SimpleMessageDecoder(InfectMessage.class), (T, K) -> InfectionPacketHandler.processInfectMessage(T, (NetworkEvent.Context)K.get()));
        NETWORK_INSTANCE.registerMessage(2, CureEntityMessage.class, (BiConsumer)new SimpleMessageEncoder(), (Function)new SimpleMessageDecoder(CureEntityMessage.class), (T, K) -> InfectionPacketHandler.processCureEntityMessage(T, (NetworkEvent.Context)K.get()));
    }

    private static void processInfectMessage(InfectMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientHandler.onInfect()));
        ctx.setPacketHandled(true);
    }

    private static void processCureEntityMessage(CureEntityMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientHandler.processCureEntity(message)));
        ctx.setPacketHandled(true);
    }
}

