/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.util.DataUtils;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.ai.FleeEntityGoal;
import net.smileycorp.hordes.common.ai.HordeTrackPlayerGoal;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeEvent;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeSpawn;
import net.smileycorp.hordes.common.infection.HordesInfection;
import net.smileycorp.hordes.common.infection.InfectionRegister;
import net.smileycorp.hordes.common.infection.network.CureEntityMessage;
import net.smileycorp.hordes.common.infection.network.InfectionPacketHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MixinMob
extends LivingEntity {
    @Shadow
    public GoalSelector f_21345_;
    @Shadow
    public GoalSelector f_21346_;

    public MixinMob(Level level) {
        super(null, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"checkAndHandleImportantInteractions(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, cancellable=true)
    public void checkAndHandleImportantInteractions(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> callback) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_21023_((MobEffect)HordesInfection.INFECTED.get()) && InfectionRegister.isCure(stack)) {
            this.m_21195_((MobEffect)HordesInfection.INFECTED.get());
            if (!player.f_19853_.f_46443_) {
                InfectionPacketHandler.NETWORK_INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> player.f_19853_.m_46745_(this.m_20097_())), (Object)new CureEntityMessage((LivingEntity)((Mob)this)));
            }
            if (!player.m_7500_()) {
                ItemStack container = stack.m_41720_().getCraftingRemainingItem(stack);
                if (stack.m_41763_() && player instanceof ServerPlayer) {
                    stack.m_220157_(1, player.f_19853_.f_46441_, (ServerPlayer)player);
                } else {
                    stack.m_41774_(1);
                }
                if (stack.m_41619_() && !container.m_41619_()) {
                    player.m_21008_(hand, container);
                }
            }
            callback.setReturnValue((Object)InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_));
            callback.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isSunBurnTick()Z"}, cancellable=true)
    public void isSunBurnTick(CallbackInfoReturnable<Boolean> callback) {
        if (this instanceof AbstractSkeleton & (Boolean)CommonConfigHandler.skeletonsBurn.get() == false) {
            callback.setReturnValue((Object)false);
            callback.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"shouldDespawnInPeaceful()Z"}, cancellable=true)
    public void shouldDespawnInPeaceful(CallbackInfoReturnable<Boolean> callback) {
        if (this instanceof ZombieHorse && ((Boolean)CommonConfigHandler.aggressiveZombieHorses.get()).booleanValue()) {
            callback.setReturnValue((Object)true);
            callback.cancel();
        }
    }

    @ModifyVariable(method={"convertTo"}, at=@At(value="STORE", ordinal=0))
    private Mob convertTo(Mob converted) {
        String uuid;
        LazyOptional beforeOptional = this.getCapability(Hordes.HORDESPAWN);
        LazyOptional afterOptional = converted.getCapability(Hordes.HORDESPAWN);
        if (beforeOptional.isPresent() && afterOptional.isPresent() && ((IHordeSpawn)beforeOptional.resolve().get()).isHordeSpawned() && DataUtils.isValidUUID((String)(uuid = ((IHordeSpawn)beforeOptional.resolve().get()).getPlayerUUID()))) {
            LazyOptional optionalp;
            ((IHordeSpawn)afterOptional.resolve().get()).setPlayerUUID(uuid);
            ((IHordeSpawn)beforeOptional.resolve().get()).setPlayerUUID("");
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(UUID.fromString(uuid));
            if (player != null && (optionalp = player.getCapability(Hordes.HORDE_EVENT, null)).isPresent()) {
                ((IHordeEvent)optionalp.resolve().get()).registerEntity(converted);
                ((IHordeEvent)optionalp.resolve().get()).removeEntity((Mob)this);
            }
        }
        return converted;
    }

    @Inject(at={@At(value="TAIL")}, method={"convertTo(Lnet/minecraft/world/entity/EntityType;Z)Lnet/minecraft/world/entity/Mob;"}, cancellable=true)
    public void convertTo(EntityType<?> type, boolean keepEquipment, CallbackInfoReturnable<Mob> callback) {
        ServerPlayer player;
        String uuid;
        Mob converted = (Mob)callback.getReturnValue();
        LazyOptional optional = converted.getCapability(Hordes.HORDESPAWN);
        if (optional.isPresent() && ((IHordeSpawn)optional.resolve().get()).isHordeSpawned() && DataUtils.isValidUUID((String)(uuid = ((IHordeSpawn)optional.resolve().get()).getPlayerUUID())) && (player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(UUID.fromString(uuid))) != null) {
            converted.f_21345_.m_25352_(6, (Goal)new HordeTrackPlayerGoal(converted, (Entity)player));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"registerGoals()V"}, cancellable=true)
    public void registerGoals(CallbackInfo callback) {
        if (((Boolean)CommonConfigHandler.piglinsHuntZombies.get()).booleanValue() && this instanceof Piglin) {
            this.f_21345_.m_25352_(1, (Goal)new FleeEntityGoal((Mob)this, 1.5, 5.0, InfectionRegister::canCauseInfection));
        }
    }
}

