/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography;

import journeymap.client.JourneymapClient;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.cartography.render.BiomeRenderer;
import journeymap.client.cartography.render.CaveRenderer;
import journeymap.client.cartography.render.EndCaveRenderer;
import journeymap.client.cartography.render.EndSurfaceRenderer;
import journeymap.client.cartography.render.NetherRenderer;
import journeymap.client.cartography.render.SurfaceRenderer;
import journeymap.client.cartography.render.TopoRenderer;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.model.RegionImageSet;
import journeymap.client.texture.ComparableNativeImage;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionData;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.Level;

public class ChunkRenderController {
    private final SurfaceRenderer overWorldSurfaceRenderer = new SurfaceRenderer();
    private final BaseRenderer netherRenderer;
    private final SurfaceRenderer endSurfaceRenderer;
    private final BaseRenderer endCaveRenderer;
    private final BaseRenderer topoRenderer;
    private final BaseRenderer overWorldCaveRenderer = new CaveRenderer(this.overWorldSurfaceRenderer);
    private final BaseRenderer biomeRenderer;

    public ChunkRenderController() {
        this.netherRenderer = new NetherRenderer();
        this.endSurfaceRenderer = new EndSurfaceRenderer();
        this.endCaveRenderer = new EndCaveRenderer(this.endSurfaceRenderer);
        this.topoRenderer = new TopoRenderer();
        this.biomeRenderer = new BiomeRenderer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseRenderer getRenderer(RegionCoord rCoord, MapType mapType, ChunkMD chunkMd) {
        try {
            RegionImageSet regionImageSet = RegionImageCache.INSTANCE.getRegionImageSet(rCoord);
            if (!mapType.isUnderground()) return this.overWorldSurfaceRenderer;
            try (ComparableNativeImage image = regionImageSet.getChunkImage(chunkMd, mapType);){
                if (image == null) return null;
                if (Level.f_46429_.equals(rCoord.dimension)) {
                    BaseRenderer baseRenderer = this.netherRenderer;
                    return baseRenderer;
                }
                if (Level.f_46430_.equals(rCoord.dimension)) {
                    BaseRenderer baseRenderer = this.endCaveRenderer;
                    return baseRenderer;
                }
                BaseRenderer baseRenderer = this.overWorldCaveRenderer;
                return baseRenderer;
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in ChunkRenderController: " + LogFormatter.toPartialString(t));
        }
        return null;
    }

    public boolean renderChunk(RegionCoord rCoord, MapType mapType, ChunkMD chunkMd, RegionData regionData) {
        boolean renderOkay;
        block42: {
            Minecraft mc = Minecraft.m_91087_();
            if (!JourneymapClient.getInstance().isMapping().booleanValue() || chunkMd.getChunk().m_62953_().m_46472_() != mc.f_91074_.f_19853_.m_46472_() || mc.f_91074_.f_19853_ != mc.f_91073_) {
                return false;
            }
            renderOkay = false;
            try {
                RegionImageSet regionImageSet = RegionImageCache.INSTANCE.getRegionImageSet(rCoord);
                if (mapType.isUnderground()) {
                    try (ComparableNativeImage chunkSliceImage = regionImageSet.getChunkImage(chunkMd, mapType);){
                        if (chunkSliceImage != null && (renderOkay = Level.f_46429_.equals(rCoord.dimension) ? this.netherRenderer.render(chunkSliceImage, regionData, chunkMd, mapType.vSlice) : (Level.f_46430_.equals(rCoord.dimension) ? this.endCaveRenderer.render(chunkSliceImage, regionData, chunkMd, mapType.vSlice) : this.overWorldCaveRenderer.render(chunkSliceImage, regionData, chunkMd, mapType.vSlice)))) {
                            regionImageSet.setChunkImage(chunkMd, mapType, chunkSliceImage);
                        }
                        break block42;
                    }
                }
                if (Level.f_46429_.equals(rCoord.dimension)) break block42;
                if (mapType.isTopo()) {
                    try (ComparableNativeImage imageTopo = regionImageSet.getChunkImage(chunkMd, MapType.topo(rCoord.dimension));){
                        renderOkay = this.topoRenderer.render(imageTopo, regionData, chunkMd, null);
                        if (renderOkay) {
                            regionImageSet.setChunkImage(chunkMd, MapType.topo(rCoord.dimension), imageTopo);
                        }
                        break block42;
                    }
                }
                if (mapType.isBiome()) {
                    try (ComparableNativeImage imageBiome = regionImageSet.getChunkImage(chunkMd, MapType.biome(rCoord.dimension));){
                        renderOkay = this.biomeRenderer.render(imageBiome, regionData, chunkMd, null);
                        if (renderOkay) {
                            regionImageSet.setChunkImage(chunkMd, MapType.biome(rCoord.dimension), imageBiome);
                        }
                        break block42;
                    }
                }
                try (ComparableNativeImage imageDay = regionImageSet.getChunkImage(chunkMd, MapType.day(rCoord.dimension));
                     ComparableNativeImage imageNight = regionImageSet.getChunkImage(chunkMd, MapType.night(rCoord.dimension));){
                    renderOkay = this.overWorldSurfaceRenderer.render(imageDay, imageNight, regionData, chunkMd);
                    if (renderOkay) {
                        regionImageSet.setChunkImage(chunkMd, MapType.day(rCoord.dimension), imageDay);
                        regionImageSet.setChunkImage(chunkMd, MapType.night(rCoord.dimension), imageNight);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Journeymap.getLogger().log(org.apache.logging.log4j.Level.WARN, LogFormatter.toString(e));
                return false;
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Unexpected error in ChunkRenderController: " + LogFormatter.toString(t));
            }
        }
        if (!renderOkay && Journeymap.getLogger().isDebugEnabled()) {
            Journeymap.getLogger().debug(String.format("Chunk %s render failed for %s", chunkMd.getCoord(), mapType));
        }
        return renderOkay;
    }
}

