/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.EnumSet;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.GridSpec;
import journeymap.client.model.GridSpecs;
import journeymap.client.model.MapType;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.SimpleTextureImpl;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.CheckBox;
import journeymap.client.ui.component.IntSliderButton;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.PropertyDropdownButton;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeToggle;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.EnumField;
import journeymap.common.properties.config.IntegerField;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class GridEditor
extends JmUI {
    private final Texture colorPickTexture;
    private final int tileSize = 128;
    private final int sampleTextureSize = 128;
    private GridSpecs gridSpecs;
    private PropertyDropdownButton<GridSpec.Style> buttonStyle;
    private IntSliderButton buttonOpacity;
    private CheckBox checkDay;
    private CheckBox checkNight;
    private CheckBox checkUnderground;
    private ThemeToggle buttonDay;
    private ThemeToggle buttonNight;
    private ThemeToggle buttonUnderground;
    private Integer activeColor;
    private MapType activeMapType;
    private Button buttonReset;
    private Button buttonCancel;
    private Button buttonClose;
    private Rectangle2D.Double colorPickRect;
    private ButtonList topButtons;
    private ButtonList leftButtons;
    private ButtonList leftChecks;
    private ButtonList bottomButtons;
    private ResourceLocation colorPicResource = Constants.birthdayMessage() == null ? TextureCache.ColorPicker : TextureCache.ColorPicker2;

    public GridEditor(JmUI returnDisplay) {
        super(Constants.getString("jm.common.grid_editor"), returnDisplay);
        this.colorPickTexture = TextureCache.getTexture(this.colorPicResource);
        this.colorPickRect = new Rectangle2D.Double(0.0, 0.0, this.colorPickTexture.getWidth(), this.colorPickTexture.getHeight());
        this.gridSpecs = JourneymapClient.getInstance().getCoreProperties().gridSpecs.clone();
        this.activeMapType = MapType.day((ResourceKey<Level>)Level.f_46428_);
        this.activeColor = this.gridSpecs.getSpec(this.activeMapType).getColor();
        this.getMinecraft().f_91068_.m_90926_(true);
    }

    @Override
    public void m_7856_() {
        try {
            this.setRenderBottomBar(true);
            if (this.getRenderables().isEmpty()) {
                GridSpec spec = this.gridSpecs.getSpec(this.activeMapType);
                this.buttonStyle = new PropertyDropdownButton<GridSpec.Style>(EnumSet.allOf(GridSpec.Style.class), Constants.getString("jm.common.grid_style"), new EnumField<GridSpec.Style>(Category.Hidden, "", spec.style), b -> this.updateGridSpecs());
                this.m_142416_((GuiEventListener)this.buttonStyle);
                this.buttonStyle.setDefaultStyle(false);
                this.buttonStyle.setDrawBackground(false);
                this.buttonOpacity = new IntSliderButton(new IntegerField(Category.Hidden, "", 0, 100, (int)Math.ceil(spec.alpha * 100.0f)), Constants.getString("jm.common.grid_opacity") + " : ", "", true);
                this.m_142416_((GuiEventListener)this.buttonOpacity);
                this.buttonOpacity.setDefaultStyle(false);
                this.buttonOpacity.setDrawBackground(false);
                this.topButtons = new ButtonList(this.buttonStyle, this.buttonOpacity);
                this.topButtons.equalizeWidths(this.getFontRenderer());
                this.checkDay = new CheckBox("", this.activeMapType == MapType.day((ResourceKey<Level>)Level.f_46428_), b -> this.updatePreview(MapType.day((ResourceKey<Level>)Level.f_46428_)));
                this.m_142416_((GuiEventListener)this.checkDay);
                this.checkNight = new CheckBox("", this.activeMapType == MapType.night((ResourceKey<Level>)Level.f_46428_), b -> this.updatePreview(MapType.night((ResourceKey<Level>)Level.f_46428_)));
                this.m_142416_((GuiEventListener)this.checkNight);
                this.checkUnderground = new CheckBox("", this.activeMapType.isUnderground(), b -> this.updatePreview(MapType.underground(0, (ResourceKey<Level>)Level.f_46428_)));
                this.m_142416_((GuiEventListener)this.checkUnderground);
                this.leftChecks = new ButtonList(this.checkDay, this.checkNight, this.checkUnderground);
                Theme theme = ThemeLoader.getCurrentTheme();
                this.buttonDay = new ThemeToggle(theme, "jm.fullscreen.map_day", "day", b -> this.updatePreview(MapType.day((ResourceKey<Level>)Level.f_46428_)));
                this.m_142416_((GuiEventListener)this.buttonDay);
                this.buttonNight = new ThemeToggle(theme, "jm.fullscreen.map_night", "night", b -> this.updatePreview(MapType.night((ResourceKey<Level>)Level.f_46428_)));
                this.m_142416_((GuiEventListener)this.buttonNight);
                this.buttonUnderground = new ThemeToggle(theme, "jm.fullscreen.map_caves", "caves", b -> this.updatePreview(MapType.underground(0, (ResourceKey<Level>)Level.f_46428_)));
                this.m_142416_((GuiEventListener)this.buttonUnderground);
                this.leftButtons = new ButtonList(this.buttonDay, this.buttonNight, this.buttonUnderground);
                this.buttonReset = new Button(Constants.getString("jm.waypoint.reset"), b -> this.resetGridSpecs());
                this.m_142416_((GuiEventListener)this.buttonReset);
                this.buttonReset.setDefaultStyle(false);
                this.buttonCancel = new Button(Constants.getString("jm.waypoint.cancel"), b -> {
                    this.resetGridSpecs();
                    this.closeAndReturn();
                });
                this.buttonCancel.setDefaultStyle(false);
                this.m_142416_((GuiEventListener)this.buttonCancel);
                this.buttonClose = new Button(Constants.getString("jm.waypoint.save"), b -> this.saveAndClose());
                this.buttonClose.setDefaultStyle(false);
                this.m_142416_((GuiEventListener)this.buttonClose);
                this.bottomButtons = new ButtonList(this.buttonReset, this.buttonCancel, this.buttonClose);
                this.bottomButtons.equalizeWidths(this.getFontRenderer());
                this.getRenderables().addAll(this.topButtons);
                this.getRenderables().addAll(this.leftChecks);
                this.getRenderables().addAll(this.leftButtons);
                this.getRenderables().addAll(this.bottomButtons);
                this.updatePreview(this.activeMapType);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    protected void layoutButtons(PoseStack poseStack) {
        try {
            this.m_7856_();
            int hgap = 6;
            int vgap = 6;
            int startY = Math.max(40, (this.f_96544_ - 230) / 2);
            int centerX = this.f_96543_ / 2;
            int cpSize = this.topButtons.getHeight(6);
            int topRowWidth = 6 + cpSize + ((Button)this.topButtons.get(0)).m_5711_();
            int topRowLeft = centerX - topRowWidth / 2;
            this.topButtons.layoutVertical(topRowLeft + 6 + cpSize, startY, true, 6);
            this.drawColorPicker(poseStack, topRowLeft, this.topButtons.getTopY(), cpSize);
            int tileX = centerX - 64;
            int tileY = this.topButtons.getBottomY() + 12;
            this.drawMapTile(poseStack, tileX, tileY);
            this.leftButtons.layoutVertical(tileX - ((Button)this.leftButtons.get(0)).m_5711_() - 6, tileY + 6, true, 6);
            this.leftChecks.setHeights(((Button)this.leftButtons.get(0)).m_93694_());
            this.leftChecks.setWidths(15);
            this.leftChecks.layoutVertical(this.leftButtons.getLeftX() - this.checkDay.m_5711_(), this.leftButtons.getTopY(), true, 6);
            int bottomY = Math.min(tileY + 128 + 12, this.f_96544_ - 10 - this.buttonClose.m_93694_());
            this.bottomButtons.equalizeWidths(this.getFontRenderer(), 6, ((Button)this.topButtons.get(0)).getRightX() - topRowLeft);
            this.bottomButtons.layoutCenteredHorizontal(centerX, bottomY, true, 6);
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.layoutButtons: " + LogFormatter.toString(t));
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float par3) {
        try {
            this.m_96558_(poseStack, 0);
            this.renderBottomBar(poseStack);
            this.layoutButtons(poseStack);
            for (int k = 0; k < this.getRenderables().size(); ++k) {
                net.minecraft.client.gui.components.Button guibutton = (net.minecraft.client.gui.components.Button)this.getRenderables().get(k);
                guibutton.m_6305_(poseStack, x, y, 0.0f);
            }
            this.drawTitle(poseStack);
            this.drawLogo(poseStack);
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.render: " + LogFormatter.toString(t));
        }
    }

    protected void drawColorPicker(PoseStack poseStack, int x, int y, float size) {
        int sizeI = (int)size;
        GridEditor.m_93172_((PoseStack)poseStack, (int)(x - 1), (int)(y - 1), (int)(x + sizeI + 1), (int)(y + sizeI + 1), (int)-6250336);
        float scale = size / (float)this.colorPickTexture.getWidth();
        if (this.colorPickRect.width != (double)size) {
            ((SimpleTextureImpl)this.colorPickTexture).resize(scale);
        }
        this.colorPickRect.setRect(x, y, size, size);
        DrawUtil.drawImage(poseStack, this.colorPickTexture, x, y, false, scale, 0.0);
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        int colorX = activeSpec.getColorX();
        int colorY = activeSpec.getColorY();
        if (colorX > 0 && colorY > 0) {
            DrawUtil.drawRectangle(poseStack, (colorX += x) - 2, (colorY += y) - 2, 5.0, 5.0, Color.darkGray.getRGB(), 0.8f);
            DrawUtil.drawRectangle(poseStack, colorX - 1, colorY, 3.0, 1.0, this.activeColor, 1.0f);
            DrawUtil.drawRectangle(poseStack, colorX, colorY - 1, 1.0, 3.0, this.activeColor, 1.0f);
        }
    }

    protected void drawMapTile(PoseStack poseStack, int x, int y) {
        float scale = 1.0f;
        GridEditor.m_93172_((PoseStack)poseStack, (int)(x - 1), (int)(y - 1), (int)(x + 128 + 1), (int)(y + 128 + 1), (int)-6250336);
        Texture tileTex = this.getTileSample(this.activeMapType);
        DrawUtil.drawImage(poseStack, tileTex, x, y, false, 1.0f, 0.0);
        if (scale == 2.0f) {
            DrawUtil.drawImage(poseStack, tileTex, x + 128, y, true, 1.0f, 0.0);
            DrawUtil.drawImage(poseStack, tileTex, x, y + 128, true, 1.0f, 180.0);
            DrawUtil.drawImage(poseStack, tileTex, x + 128, y + 128, false, 1.0f, 180.0);
        }
        GridSpec gridSpec = this.gridSpecs.getSpec(this.activeMapType);
        gridSpec.beginTexture(9728, 33071, 1.0f);
        DrawUtil.drawBoundTexture(poseStack, 0.0, 0.0, x, y, 0.0, 0.25, 0.25, x + 128, y + 128);
        gridSpec.finishTexture();
    }

    protected void drawLabel(PoseStack poseStack, String label, int x, int y) {
        GridEditor.m_93236_((PoseStack)poseStack, (Font)this.getFontRenderer(), (String)label, (int)x, (int)y, (int)Color.cyan.getRGB());
    }

    @Override
    public boolean m_5534_(char typedChar, int keyCode) {
        try {
            switch (keyCode) {
                case 256: {
                    this.closeAndReturn();
                    return true;
                }
                case 257: {
                    this.saveAndClose();
                    return true;
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.keyTyped: " + LogFormatter.toString(t));
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        try {
            if (this.buttonOpacity.dragging) {
                this.updateGridSpecs();
            } else {
                this.checkColorPicker(mouseX, mouseY);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.mouseClickMove: " + LogFormatter.toString(t));
        }
        return super.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        try {
            super.m_6375_(mouseX, mouseY, mouseButton);
            if (mouseButton == 0) {
                this.checkColorPicker(mouseX, mouseY);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.mouseClicked: " + LogFormatter.toString(t));
        }
        return true;
    }

    protected void checkColorPicker(double mouseX, double mouseY) {
        if (this.colorPickRect.contains(mouseX, mouseY)) {
            int x = (int)(mouseX - (double)((int)this.colorPickRect.x));
            int y = (int)(mouseY - (double)((int)this.colorPickRect.y));
            this.activeColor = this.colorPickTexture.getRGB(x, y);
            GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
            activeSpec.setColorCoords(x, y);
            this.updateGridSpecs();
        }
    }

    protected void updatePreview(MapType mapType) {
        this.activeMapType = mapType;
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        this.activeColor = activeSpec.getColor();
        this.buttonOpacity.setValue((int)(activeSpec.alpha * 100.0f));
        this.buttonStyle.setValue(activeSpec.style);
        this.checkDay.setToggled(mapType.isDay());
        this.checkNight.setToggled(mapType.isNight());
        this.checkUnderground.setToggled(mapType.isUnderground());
        this.buttonDay.setToggled(mapType.isDay());
        this.buttonNight.setToggled(mapType.isNight());
        this.buttonUnderground.setToggled(mapType.isUnderground());
    }

    protected void updateGridSpecs() {
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        int colorX = activeSpec.getColorX();
        int colorY = activeSpec.getColorY();
        GridSpec newSpec = new GridSpec(this.buttonStyle.getField().get(), new Color(this.activeColor), (float)this.buttonOpacity.getValue() / 100.0f).setColorCoords(colorX, colorY);
        if (this.checkDay.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.day((ResourceKey<Level>)Level.f_46428_), newSpec);
        }
        if (this.checkNight.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.night((ResourceKey<Level>)Level.f_46428_), newSpec);
        }
        if (this.checkUnderground.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.underground(0, (ResourceKey<Level>)Level.f_46428_), newSpec);
        }
    }

    protected void saveAndClose() {
        this.updateGridSpecs();
        JourneymapClient.getInstance().getCoreProperties().gridSpecs.updateFrom(this.gridSpecs);
        JourneymapClient.getInstance().getCoreProperties().save();
        this.closeAndReturn();
    }

    protected void resetGridSpecs() {
        if (this.checkDay.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.day((ResourceKey<Level>)Level.f_46428_), GridSpecs.DEFAULT_DAY.clone());
        }
        if (this.checkNight.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.night((ResourceKey<Level>)Level.f_46428_), GridSpecs.DEFAULT_NIGHT.clone());
        }
        if (this.checkUnderground.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.underground(0, (ResourceKey<Level>)Level.f_46428_), GridSpecs.DEFAULT_UNDERGROUND.clone());
        }
        this.m_6702_().clear();
        this.getRenderables().clear();
        this.m_7856_();
    }

    @Override
    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((Screen)returnDisplayStack.pop());
        }
    }

    public Texture getTileSample(MapType mapType) {
        if (mapType.isNight()) {
            return TextureCache.getTexture(TextureCache.TileSampleNight);
        }
        if (mapType.isUnderground()) {
            return TextureCache.getTexture(TextureCache.TileSampleUnderground);
        }
        return TextureCache.getTexture(TextureCache.TileSampleDay);
    }

    @Override
    protected void renderBottomBar(PoseStack stack) {
        DrawUtil.drawRectangle(stack, 0.0, this.f_96544_ - 30, this.f_96543_, this.f_96544_, 0, 0.6f);
    }
}

