/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.inventory.ProjectorMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ProjectorBlockEntity
extends DisguisableBlockEntity
implements Container,
MenuProvider,
ILockable {
    public static final int MIN_WIDTH = 1;
    public static final int MAX_WIDTH = 10;
    public static final int MIN_RANGE = 1;
    public static final int MAX_RANGE = 30;
    public static final int MIN_OFFSET = -10;
    public static final int MAX_OFFSET = 10;
    public static final int RENDER_DISTANCE = 100;
    private int projectionWidth = 1;
    private int projectionHeight = 1;
    private int projectionRange = 5;
    private int projectionOffset = 0;
    public boolean activatedByRedstone = false;
    public boolean active = false;
    private boolean horizontal = false;
    private ItemStack projectedBlock = ItemStack.f_41583_;
    private BlockState projectedState = Blocks.f_50016_.m_49966_();

    public ProjectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.PROJECTOR_BLOCK_ENTITY.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(100.0);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("width", this.projectionWidth);
        tag.m_128405_("height", this.projectionHeight);
        tag.m_128405_("range", this.projectionRange);
        tag.m_128405_("offset", this.projectionOffset);
        tag.m_128379_("active", this.active);
        tag.m_128379_("horizontal", this.horizontal);
        tag.m_128365_("storedItem", (Tag)this.projectedBlock.m_41739_(new CompoundTag()));
        tag.m_128365_("SavedState", (Tag)NbtUtils.m_129202_((BlockState)this.projectedState));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.projectionWidth = tag.m_128451_("width");
        this.projectionHeight = tag.m_128451_("height");
        this.projectionRange = tag.m_128451_("range");
        this.projectionOffset = tag.m_128451_("offset");
        this.activatedByRedstone = this.isModuleEnabled(ModuleType.REDSTONE);
        this.active = tag.m_128471_("active");
        this.horizontal = tag.m_128471_("horizontal");
        this.projectedBlock = ItemStack.m_41712_((CompoundTag)tag.m_128469_("storedItem"));
        if (!tag.m_128441_("SavedState")) {
            this.resetSavedState();
        } else {
            this.setProjectedState(NbtUtils.m_129241_((CompoundTag)tag.m_128469_("SavedState")));
        }
    }

    public int getProjectionWidth() {
        return this.projectionWidth;
    }

    public void setProjectionWidth(int width) {
        this.projectionWidth = width;
        this.m_6596_();
    }

    public int getProjectionHeight() {
        return this.projectionHeight;
    }

    public void setProjectionHeight(int projectionHeight) {
        this.projectionHeight = projectionHeight;
        this.m_6596_();
    }

    public int getProjectionRange() {
        return this.projectionRange;
    }

    public void setProjectionRange(int range) {
        this.projectionRange = range;
        this.m_6596_();
    }

    public int getProjectionOffset() {
        return this.projectionOffset;
    }

    public void setProjectionOffset(int offset) {
        this.projectionOffset = offset;
        this.m_6596_();
    }

    public boolean isActivatedByRedstone() {
        return this.activatedByRedstone;
    }

    public void setActivatedByRedstone(boolean redstone) {
        this.activatedByRedstone = redstone;
        this.m_6596_();
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        this.m_6596_();
    }

    public boolean isActive() {
        return this.activatedByRedstone ? this.active : true;
    }

    public void setActive(boolean isOn) {
        this.active = isOn;
        this.m_6596_();
    }

    public BlockState getProjectedState() {
        return this.projectedState;
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.setActivatedByRedstone(true);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.setActivatedByRedstone(false);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ProjectorMenu(windowId, this.f_58857_, this.f_58858_, inv);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    public void m_6211_() {
        this.projectedBlock = ItemStack.f_41583_;
        this.resetSavedState();
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = this.projectedBlock;
        if (count >= 1) {
            this.projectedBlock = ItemStack.f_41583_;
            this.resetSavedState();
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public int m_6643_() {
        return 1;
    }

    public int m_6893_() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (slot == 36 ? this.projectedBlock : ItemStack.f_41583_);
    }

    public ItemStack m_8020_(int slot) {
        return this.getStackInSlot(slot);
    }

    public boolean m_7983_() {
        return this.projectedBlock.m_41619_();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = this.projectedBlock;
        this.projectedBlock = ItemStack.f_41583_;
        this.resetSavedState();
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack = new ItemStack((ItemLike)stack.m_41720_(), this.m_6893_());
        }
        ItemStack old = this.projectedBlock;
        this.projectedBlock = stack;
        if (old.m_41720_() != this.projectedBlock.m_41720_()) {
            this.resetSavedState();
        }
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.f_46443_) {
            ClientHandler.PROJECTOR_RENDER_DELEGATE.putDelegateFor(this, this.projectedState);
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_.f_46443_) {
            ClientHandler.PROJECTOR_RENDER_DELEGATE.removeDelegateOf(this);
        }
    }

    public void setProjectedState(BlockState projectedState) {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            if (this.projectedState.m_60734_() != projectedState.m_60734_()) {
                ClientHandler.PROJECTOR_RENDER_DELEGATE.removeDelegateOf(this);
            }
            ClientHandler.PROJECTOR_RENDER_DELEGATE.putDelegateFor(this, projectedState);
        }
        this.projectedState = projectedState;
        this.m_6596_();
    }

    public void resetSavedState() {
        Item item = this.projectedBlock.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.setProjectedState(blockItem.m_40614_().m_49966_());
        } else {
            this.projectedState = Blocks.f_50016_.m_49966_();
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                ClientHandler.PROJECTOR_RENDER_DELEGATE.removeDelegateOf(this);
            }
            this.m_6596_();
        }
    }

    public StandingOrWallType getStandingOrWallType() {
        Item item;
        if (this.projectedState != null && this.projectedBlock != null && (item = this.projectedBlock.m_41720_()) instanceof StandingAndWallBlockItem) {
            StandingAndWallBlockItem sawbi = (StandingAndWallBlockItem)item;
            if (this.projectedState.m_60734_() == sawbi.m_40614_()) {
                return StandingOrWallType.STANDING;
            }
            if (this.projectedState.m_60734_() == sawbi.f_43246_) {
                return StandingOrWallType.WALL;
            }
        }
        return StandingOrWallType.NONE;
    }
}

