/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.GameData;

public class SetStateOnDisguiseModule {
    private BlockState state;
    private StandingOrWallType standingOrWall;

    public SetStateOnDisguiseModule() {
    }

    public SetStateOnDisguiseModule(BlockState state, StandingOrWallType standingOrWall) {
        this.state = state;
        this.standingOrWall = standingOrWall;
    }

    public static void encode(SetStateOnDisguiseModule message, FriendlyByteBuf buf) {
        buf.writeInt(GameData.getBlockStateIDMap().m_7447_((Object)message.state));
        buf.m_130068_((Enum)message.standingOrWall);
    }

    public static SetStateOnDisguiseModule decode(FriendlyByteBuf buf) {
        SetStateOnDisguiseModule message = new SetStateOnDisguiseModule();
        message.state = (BlockState)GameData.getBlockStateIDMap().m_7942_(buf.readInt());
        message.standingOrWall = (StandingOrWallType)buf.m_130066_(StandingOrWallType.class);
        return message;
    }

    public static void onMessage(SetStateOnDisguiseModule message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack stack = PlayerUtils.getSelectedItemStack((Player)player, (Item)SCContent.DISGUISE_MODULE.get());
            if (!stack.m_41619_()) {
                CompoundTag tag = stack.m_41784_();
                tag.m_128365_("SavedState", (Tag)NbtUtils.m_129202_((BlockState)message.state));
                tag.m_128405_("StandingOrWall", message.standingOrWall.ordinal());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

